/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

public class ThreadLocalWatch {
    private final ThreadLocal<Long> timestampRef = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return System.nanoTime();
        }
    };

    public long start() {
        long timestamp = System.nanoTime();
        this.timestampRef.set(timestamp);
        return timestamp;
    }

    public long cost() {
        return System.nanoTime() - this.timestampRef.get();
    }

    public double costInMillis() {
        return (double)(System.nanoTime() - this.timestampRef.get()) / 1000000.0;
    }

    public void clear() {
        this.timestampRef.remove();
    }
}

