/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.command.monitor200.TimeFragment;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class TimeTunnelTable {
    private static final int[] TABLE_COL_WIDTH = new int[]{8, 20, 10, 8, 8, 15, 30, 30};
    private static final String[] TABLE_COL_TITLE = new String[]{"INDEX", "TIMESTAMP", "COST(ms)", "IS-RET", "IS-EXP", "OBJECT", "CLASS", "METHOD"};

    static TableElement createTable() {
        return new TableElement(TABLE_COL_WIDTH).leftCellPadding(1).rightCellPadding(1);
    }

    static TableElement createDefaultTable() {
        return new TableElement().leftCellPadding(1).rightCellPadding(1);
    }

    static TableElement fillTableHeader(TableElement table) {
        LabelElement[] headers = new LabelElement[TABLE_COL_TITLE.length];
        for (int i = 0; i < TABLE_COL_TITLE.length; ++i) {
            headers[i] = Element.label((String)TABLE_COL_TITLE[i]).style(Decoration.bold.bold());
        }
        table.row(true, (Element[])headers);
        return table;
    }

    static Element drawTimeTunnelTable(Map<Integer, TimeFragment> timeTunnelMap) {
        TableElement table = TimeTunnelTable.fillTableHeader(TimeTunnelTable.createTable());
        for (Map.Entry<Integer, TimeFragment> entry : timeTunnelMap.entrySet()) {
            int index = entry.getKey();
            TimeFragment tf = entry.getValue();
            TimeTunnelTable.fillTableRow(table, index, tf);
        }
        return table;
    }

    static TableElement fillTableRow(TableElement table, int index, TimeFragment tf) {
        Advice advice = tf.getAdvice();
        return table.row(new String[]{"" + index, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(tf.getGmtCreate()), "" + tf.getCost(), "" + advice.isAfterReturning(), "" + advice.isAfterThrowing(), advice.getTarget() == null ? "NULL" : "0x" + Integer.toHexString(advice.getTarget().hashCode()), StringUtils.substringAfterLast("." + advice.getClazz().getName(), "."), advice.getMethod().getName()});
    }

    static void drawTimeTunnel(TimeFragment tf, Integer index, TableElement table) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        table.row(new String[]{"INDEX", "" + index}).row(new String[]{"GMT-CREATE", sdf.format(tf.getGmtCreate())}).row(new String[]{"COST(ms)", "" + tf.getCost()});
    }

    static void drawMethod(Advice advice, String className, String methodName, String objectAddress, TableElement table) {
        table.row(new String[]{"OBJECT", objectAddress}).row(new String[]{"CLASS", className}).row(new String[]{"METHOD", methodName}).row(new String[]{"IS-RETURN", "" + advice.isAfterReturning()}).row(new String[]{"IS-EXCEPTION", "" + advice.isAfterThrowing()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void drawThrowException(Advice advice, TableElement table, boolean isNeedExpand, int expandLevel) {
        if (advice.isAfterThrowing()) {
            Throwable throwable = advice.getThrowExp();
            if (isNeedExpand) {
                table.row(new String[]{"THROW-EXCEPTION", new ObjectView(advice.getThrowExp(), expandLevel).draw()});
            } else {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    throwable.printStackTrace(printWriter);
                    table.row(new String[]{"THROW-EXCEPTION", stringWriter.toString()});
                }
                finally {
                    printWriter.close();
                }
            }
        }
    }

    static void drawReturnObj(Advice advice, TableElement table, boolean isNeedExpand, int expandLevel, int sizeLimit) {
        if (advice.isAfterReturning()) {
            if (isNeedExpand) {
                table.row(new String[]{"RETURN-OBJ", new ObjectView(advice.getReturnObj(), expandLevel, sizeLimit).draw()});
            } else {
                table.row(new String[]{"RETURN-OBJ", "" + StringUtils.objectToString(advice.getReturnObj())});
            }
        }
    }

    static void drawParameters(Advice advice, TableElement table, boolean isNeedExpand, int expandLevel) {
        if (null != advice.getParams()) {
            int paramIndex = 0;
            for (Object param : advice.getParams()) {
                if (isNeedExpand) {
                    table.row(new String[]{"PARAMETERS[" + paramIndex++ + "]", new ObjectView(param, expandLevel).draw()});
                    continue;
                }
                table.row(new String[]{"PARAMETERS[" + paramIndex++ + "]", "" + StringUtils.objectToString(param)});
            }
        }
    }

    static void drawWatchTableHeader(TableElement table) {
        table.row(true, new Element[]{Element.label((String)"INDEX").style(Decoration.bold.bold()), Element.label((String)"SEARCH-RESULT").style(Decoration.bold.bold())});
    }

    static void drawWatchExpress(Map<Integer, TimeFragment> matchingTimeSegmentMap, TableElement table, String watchExpress, boolean isNeedExpand, int expandLevel, int sizeLimit) throws ExpressException {
        for (Map.Entry<Integer, TimeFragment> entry : matchingTimeSegmentMap.entrySet()) {
            Object value = ExpressFactory.threadLocalExpress(entry.getValue().getAdvice()).get(watchExpress);
            table.row(new String[]{"" + entry.getKey(), "" + (isNeedExpand ? new ObjectView(value, expandLevel, sizeLimit).draw() : StringUtils.objectToString(value))});
        }
    }

    static TableElement drawPlayHeader(String className, String methodName, String objectAddress, int index, TableElement table) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return table.row(new String[]{"RE-INDEX", "" + index}).row(new String[]{"GMT-REPLAY", sdf.format(new Date())}).row(new String[]{"OBJECT", objectAddress}).row(new String[]{"CLASS", className}).row(new String[]{"METHOD", methodName});
    }

    static void drawPlayResult(TableElement table, Object returnObj, boolean isNeedExpand, int expandLevel, int sizeLimit) {
        table.row(new String[]{"IS-RETURN", "true"});
        table.row(new String[]{"IS-EXCEPTION", "false"});
        if (isNeedExpand) {
            table.row(new String[]{"RETURN-OBJ", new ObjectView(returnObj, expandLevel, sizeLimit).draw()});
        } else {
            table.row(new String[]{"RETURN-OBJ", "" + StringUtils.objectToString(returnObj)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void drawPlayException(TableElement table, Throwable t, boolean isNeedExpand, int expandLevel) {
        table.row(new String[]{"IS-RETURN", "false"});
        table.row(new String[]{"IS-EXCEPTION", "true"});
        Throwable cause = t instanceof InvocationTargetException ? t.getCause() : t;
        if (isNeedExpand) {
            table.row(new String[]{"THROW-EXCEPTION", new ObjectView(cause, expandLevel).draw()});
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                cause.printStackTrace(printWriter);
                table.row(new String[]{"THROW-EXCEPTION", stringWriter.toString()});
            }
            finally {
                printWriter.close();
            }
        }
    }
}

