/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.usage;

import com.taobao.middleware.cli.Argument;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.UsageMessageFormatter;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.Collections;

public class StyledUsageFormatter
extends UsageMessageFormatter {
    private Color fontColor;

    public StyledUsageFormatter(Color fontColor) {
        this.fontColor = fontColor;
    }

    public static String styledUsage(CLI cli, int width) {
        StringBuilder usageBuilder = new StringBuilder();
        StyledUsageFormatter formatter = new StyledUsageFormatter(Color.green);
        formatter.setWidth(width);
        cli.usage(usageBuilder, (UsageMessageFormatter)formatter);
        return usageBuilder.toString();
    }

    public void usage(StringBuilder builder, String prefix, CLI cli) {
        TableElement table = new TableElement(new int[]{1, 2}).leftCellPadding(1).rightCellPadding(1);
        table.add(Element.row().add(new Element[]{Element.label((String)"USAGE:").style(this.getHighlightedStyle())}));
        table.add(Element.row().add(new Element[]{Element.label((String)this.computeUsageLine(prefix, cli))}));
        table.add(Element.row().add(new String[]{""}));
        table.add(Element.row().add(new Element[]{Element.label((String)"SUMMARY:").style(this.getHighlightedStyle())}));
        table.add(Element.row().add(new Element[]{Element.label((String)("  " + cli.getSummary()))}));
        if (cli.getDescription() != null) {
            String[] descLines;
            for (String line : descLines = cli.getDescription().split("\\n")) {
                if (this.shouldBeHighlighted(line)) {
                    table.add(Element.row().add(new Element[]{Element.label((String)line).style(this.getHighlightedStyle())}));
                    continue;
                }
                table.add(Element.row().add(new Element[]{Element.label((String)line)}));
            }
        }
        if (!cli.getOptions().isEmpty() || !cli.getArguments().isEmpty()) {
            table.add(Element.row().add(new String[]{""}));
            table.row(new Element[]{Element.label((String)"OPTIONS:").style(this.getHighlightedStyle())});
            for (Option option : cli.getOptions()) {
                if (option.acceptValue()) {
                    table.add(Element.row().add(new Element[]{Element.label((String)("-" + option.getShortName() + ", --" + option.getLongName() + " <value>")).style(this.getHighlightedStyle())}).add(new String[]{option.getDescription()}));
                    continue;
                }
                table.add(Element.row().add(new Element[]{Element.label((String)("-" + option.getShortName() + ", --" + option.getLongName())).style(this.getHighlightedStyle())}).add(new String[]{option.getDescription()}));
            }
            for (Argument argument : cli.getArguments()) {
                table.add(Element.row().add(new Element[]{Element.label((String)("<" + argument.getArgName() + ">")).style(this.getHighlightedStyle())}).add(new String[]{argument.getDescription()}));
            }
        }
        builder.append(RenderUtil.render((Element)table, (int)this.getWidth()));
    }

    private Style.Composite getHighlightedStyle() {
        return Style.style((Decoration)Decoration.bold, (Color)this.fontColor);
    }

    private String computeUsageLine(String prefix, CLI cli) {
        StringBuilder buff;
        if (prefix == null) {
            buff = new StringBuilder("  ");
        } else {
            buff = new StringBuilder("  ").append(prefix);
            if (!prefix.endsWith(" ")) {
                buff.append(" ");
            }
        }
        buff.append(cli.getName()).append(" ");
        if (this.getOptionComparator() != null) {
            Collections.sort(cli.getOptions(), this.getOptionComparator());
        }
        for (Option option : cli.getOptions()) {
            this.appendOption(buff, option);
            buff.append(" ");
        }
        for (Argument arg : cli.getArguments()) {
            this.appendArgument(buff, arg, arg.isRequired());
            buff.append(" ");
        }
        return buff.toString();
    }

    private boolean shouldBeHighlighted(String line) {
        return !line.startsWith(" ");
    }
}

