/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.instrument.Instrumentation;
import java.security.CodeSource;
import java.util.Set;

@Name(value="sc")
@Summary(value="Search all the classes loaded by JVM")
@Description(value="\nEXAMPLES:\n  sc -E org\\\\.apache\\\\.commons\\\\.lang\\\\.StringUtils\n  sc -d org.apache.commons.lang.StringUtils\n  sc -d org/apache/commons/lang/StringUtils\n  sc -d *StringUtils\n\nWIKI:\n  https://alibaba.github.io/arthas/sc")
public class SearchClassCommand
extends AnnotatedCommand {
    private String classPattern;
    private boolean isDetail = false;
    private boolean isField = false;
    private boolean isRegEx = false;
    private Integer expand;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="Display the details of class")
    public void setDetail(boolean detail) {
        this.isDetail = detail;
    }

    @Option(shortName="f", longName="field", flag=true)
    @Description(value="Display all the member variables")
    public void setField(boolean field) {
        this.isField = field;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (0 by default)")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Set<Class<?>> matchedClasses = SearchUtils.searchClass(inst, this.classPattern, this.isRegEx);
        for (Class<?> clazz : matchedClasses) {
            this.processClass(process, clazz);
        }
        affect.rCnt(matchedClasses.size());
        process.write(affect + "\n");
        process.end();
    }

    private void processClass(CommandProcess process, Class<?> clazz) {
        if (this.isDetail) {
            process.write(RenderUtil.render((Element)this.renderClassInfo(clazz, this.isField), (int)process.width()) + "\n");
        } else {
            process.write(clazz.getName() + "\n");
        }
    }

    private Element renderClassInfo(Class<?> clazz, boolean isPrintField) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        table.row(new Element[]{Element.label((String)"class-info").style(Decoration.bold.bold()), Element.label((String)StringUtils.classname(clazz))}).row(new Element[]{Element.label((String)"code-source").style(Decoration.bold.bold()), Element.label((String)SearchClassCommand.getCodeSource(cs))}).row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)StringUtils.classname(clazz))}).row(new Element[]{Element.label((String)"isInterface").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isInterface()))}).row(new Element[]{Element.label((String)"isAnnotation").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isAnnotation()))}).row(new Element[]{Element.label((String)"isEnum").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isEnum()))}).row(new Element[]{Element.label((String)"isAnonymousClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isAnonymousClass()))}).row(new Element[]{Element.label((String)"isArray").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isArray()))}).row(new Element[]{Element.label((String)"isLocalClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isLocalClass()))}).row(new Element[]{Element.label((String)"isMemberClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isMemberClass()))}).row(new Element[]{Element.label((String)"isPrimitive").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isPrimitive()))}).row(new Element[]{Element.label((String)"isSynthetic").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isSynthetic()))}).row(new Element[]{Element.label((String)"simple-name").style(Decoration.bold.bold()), Element.label((String)clazz.getSimpleName())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)StringUtils.modifier(clazz.getModifiers(), ','))}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(clazz))}).row(new Element[]{Element.label((String)"interfaces").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawInterface(clazz))}).row(new Element[]{Element.label((String)"super-class").style(Decoration.bold.bold()), TypeRenderUtils.drawSuperClass(clazz)}).row(new Element[]{Element.label((String)"class-loader").style(Decoration.bold.bold()), TypeRenderUtils.drawClassLoader(clazz)}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)StringUtils.classLoaderHash(clazz))});
        if (isPrintField) {
            table.row(new Element[]{Element.label((String)"fields"), TypeRenderUtils.drawField(clazz, this.expand)});
        }
        return table;
    }

    public static String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return "";
        }
        return cs.getLocation().getFile();
    }
}

