/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.matcher;

import com.taobao.arthas.core.util.matcher.Matcher;

public class WildcardMatcher
implements Matcher<String> {
    private final String pattern;

    public WildcardMatcher(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matching(String target) {
        return this.match(target, this.pattern, 0, 0);
    }

    private boolean match(String string, String pattern, int stringStartNdx, int patternStartNdx) {
        int pNdx = patternStartNdx;
        int sNdx = stringStartNdx;
        int pLen = pattern.length();
        if (pLen == 1 && pattern.charAt(0) == '*') {
            return true;
        }
        int sLen = string.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (sNdx >= sLen) {
                while (pNdx < pLen && pattern.charAt(pNdx) == '*') {
                    ++pNdx;
                }
                return pNdx >= pLen;
            }
            if (pNdx >= pLen) {
                return false;
            }
            char p = pattern.charAt(pNdx);
            if (!nextIsNotWildcard) {
                if (p == '\\') {
                    ++pNdx;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (p == '?') {
                    ++sNdx;
                    ++pNdx;
                    continue;
                }
                if (p == '*') {
                    int pnext = 0;
                    if (pNdx + 1 < pLen) {
                        pnext = pattern.charAt(pNdx + 1);
                    }
                    if (pnext == 42) {
                        ++pNdx;
                        continue;
                    }
                    ++pNdx;
                    for (int i = string.length(); i >= sNdx; --i) {
                        if (!this.match(string, pattern, i, pNdx)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (p != string.charAt(sNdx)) {
                return false;
            }
            ++sNdx;
            ++pNdx;
        }
    }
}

