/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import java.util.regex.Matcher;

public abstract class AnsiLog {
    static boolean enable = System.console() != null;

    public static void red(String msg) {
        if (enable) {
            System.out.println("\u001b[31m" + msg + "\u001b[0m");
        } else {
            System.err.println(msg);
        }
    }

    public static void green(String msg) {
        if (enable) {
            System.out.println("\u001b[32m" + msg + "\u001b[0m");
        } else {
            System.out.println(msg);
        }
    }

    public static void yellow(String msg) {
        if (enable) {
            System.out.println("\u001b[33m" + msg + "\u001b[0m");
        } else {
            System.out.println(msg);
        }
    }

    public static void info(String msg) {
        AnsiLog.green(msg);
    }

    public static void info(String format, Object ... arguments) {
        AnsiLog.green(AnsiLog.format(format, arguments));
    }

    public static void warn(String msg) {
        AnsiLog.yellow(msg);
    }

    public static void warn(String format, Object ... arguments) {
        AnsiLog.yellow(AnsiLog.format(format, arguments));
    }

    public static void error(String msg) {
        AnsiLog.red(msg);
    }

    public static void error(String format, Object ... arguments) {
        AnsiLog.red(AnsiLog.format(format, arguments));
    }

    private static String format(String from, Object ... arguments) {
        if (from != null) {
            String computed = from;
            if (arguments != null && arguments.length != 0) {
                for (Object argument : arguments) {
                    computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                }
            }
            return computed;
        }
        return null;
    }
}

