/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.WatchAdviceListener;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;

@Name(value="watch")
@Summary(value="Display the input/output parameter, return object, and thrown exception of specified method invocation")
@Description(value="  The express may be one of the following expression (evaluated dynamically):\n          target : the object\n           clazz : the object's class\n          method : the constructor or method\n    params[0..n] : the parameters of method\n       returnObj : the returned object of method\n        throwExp : the throw exception of method\n        isReturn : the method ended by return\n         isThrow : the method ended by throwing exception\n           #cost : the execution time in ms of method invocation\nExamples:\n  watch -Eb org\\.apache\\.commons\\.lang\\.StringUtils isBlank params[0]\n  watch -b org.apache.commons.lang.StringUtils isBlank params[0]\n  watch -f org.apache.commons.lang.StringUtils isBlank returnObj\n  watch -bf *StringUtils isBlank params[0]\n  watch *StringUtils isBlank params[0]\n  watch *StringUtils isBlank params[0] params[0].length==1\n  watch *StringUtils isBlank '#cost>100'\n\nWIKI:\n  https://alibaba.github.io/arthas/watch")
public class WatchCommand
extends EnhancerCommand {
    private String classPattern;
    private String methodPattern;
    private String express;
    private String conditionExpress;
    private boolean isBefore = false;
    private boolean isFinish = false;
    private boolean isException = false;
    private boolean isSuccess = false;
    private Integer expand = 1;
    private Integer sizeLimit = 0xA00000;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;

    @Argument(index=0, argName="class-pattern")
    @Description(value="The full qualified class name you want to watch")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(index=1, argName="method-pattern")
    @Description(value="The method name you want to watch")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(index=2, argName="express")
    @Description(value="the content you want to watch, written by ognl.\nExamples:\n  params[0]\n  'params[0]+params[1]'\n  returnObj\n  throwExp\n  target\n  clazz\n  method\n")
    public void setExpress(String express) {
        this.express = express;
    }

    @Argument(index=3, argName="condition-express", required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="b", longName="before", flag=true)
    @Description(value="Watch before invocation")
    public void setBefore(boolean before) {
        this.isBefore = before;
    }

    @Option(shortName="f", longName="finish", flag=true)
    @Description(value="Watch after invocation, enable by default")
    public void setFinish(boolean finish) {
        this.isFinish = finish;
    }

    @Option(shortName="e", longName="exception", flag=true)
    @Description(value="Watch after throw exception")
    public void setException(boolean exception) {
        this.isException = exception;
    }

    @Option(shortName="s", longName="success", flag=true)
    @Description(value="Watch after successful invocation")
    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    @Option(shortName="M", longName="sizeLimit")
    @Description(value="Upper size limit in bytes for the result (10 * 1024 * 1024 by default)")
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default)")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getExpress() {
        return this.express;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public boolean isBefore() {
        return this.isBefore;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public boolean isException() {
        return this.isException;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public Integer getExpand() {
        return this.expand;
    }

    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        return new WatchAdviceListener(this, process);
    }
}

