/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;

@Name(value="redefine")
@Summary(value="Redefine classes. @see Instrumentation#redefineClasses(ClassDefinition...)")
@Description(value="\nEXAMPLES:\n  redefine -p /tmp/Test.class\n  redefine -c 327a647b -p /tmp/Test.class /tmp/Test\\$Inner.class \n\nWIKI:\n  https://alibaba.github.io/arthas/redefine")
public class RedefineCommand
extends AnnotatedCommand {
    private static final int MAX_FILE_SIZE = 0xA00000;
    private String hashCode;
    private List<String> paths;

    @Option(shortName="c", longName="classloader")
    @Description(value="classLoader hashcode")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="p", longName="path", acceptMultipleValues=true)
    @Description(value=".class file paths")
    public void setPathPatterns(List<String> paths) {
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        if (this.paths == null || this.paths.isEmpty()) {
            process.write("paths is empty.\n");
            process.end();
            return;
        }
        Instrumentation inst = process.session().getInstrumentation();
        for (String string : this.paths) {
            File file = new File(string);
            if (!file.exists()) {
                process.write("path is not exists, path:" + string + "\n");
                process.end();
                return;
            }
            if (!file.isFile()) {
                process.write("path is not a normal file, path:" + string + "\n");
                process.end();
                return;
            }
            if (file.length() < 0xA00000L) continue;
            process.write("file size: " + file.length() + " >= " + 0xA00000 + ", path: " + string + "\n");
            process.end();
            return;
        }
        HashMap<String, byte[]> bytesMap = new HashMap<String, byte[]>();
        for (String string : this.paths) {
            RandomAccessFile f = null;
            try {
                f = new RandomAccessFile(string, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                String clazzName = RedefineCommand.readClassName(bytes);
                bytesMap.put(clazzName, bytes);
            }
            catch (Exception e) {
                process.write("" + e + "\n");
            }
            finally {
                if (f == null) continue;
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bytesMap.size() != this.paths.size()) {
            process.write("paths may contains same class name!\n");
            process.end();
            return;
        }
        ArrayList<ClassDefinition> arrayList = new ArrayList<ClassDefinition>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            if (!bytesMap.containsKey(clazz.getName()) || this.hashCode != null && !Integer.toHexString(clazz.getClassLoader().hashCode()).equals(this.hashCode)) continue;
            arrayList.add(new ClassDefinition(clazz, (byte[])bytesMap.get(clazz.getName())));
        }
        try {
            inst.redefineClasses(arrayList.toArray(new ClassDefinition[0]));
            process.write("redefine success, size: " + arrayList.size() + "\n");
        }
        catch (Exception exception) {
            process.write("redefine error! " + exception + "\n");
        }
        process.end();
    }

    private static String readClassName(byte[] bytes) {
        return new ClassReader(bytes).getClassName().replace("/", ".");
    }
}

