/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.system.impl;

import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.shell.ShellForegroundUpdateHandler;
import com.taobao.arthas.core.shell.impl.ShellImpl;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class JobImpl
implements Job {
    final int id;
    final JobControllerImpl controller;
    final Process process;
    final String line;
    private volatile ExecStatus actualStatus;
    volatile long lastStopped;
    volatile ShellImpl shell;
    volatile Handler<ExecStatus> statusUpdateHandler;
    volatile Date timeoutDate;
    final Future<Void> terminateFuture;
    final AtomicBoolean runInBackground;
    final Handler<Job> foregroundUpdatedHandler;

    JobImpl(int id, JobControllerImpl controller, Process process, String line, boolean runInBackground, ShellImpl shell) {
        this.id = id;
        this.controller = controller;
        this.process = process;
        this.line = line;
        this.terminateFuture = Future.future();
        this.runInBackground = new AtomicBoolean(runInBackground);
        this.shell = shell;
        this.foregroundUpdatedHandler = new ShellForegroundUpdateHandler(shell);
        process.terminatedHandler(new TerminatedHandler(controller));
    }

    public ExecStatus actualStatus() {
        return this.actualStatus;
    }

    @Override
    public boolean interrupt() {
        return this.process.interrupt();
    }

    @Override
    public Job resume() {
        return this.resume(true);
    }

    @Override
    public Date timeoutDate() {
        return this.timeoutDate;
    }

    @Override
    public void setTimeoutDate(Date date) {
        this.timeoutDate = date;
    }

    @Override
    public Session getSession() {
        return this.shell.session();
    }

    @Override
    public Job resume(boolean foreground) {
        try {
            this.process.resume(new ResumeHandler());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.runInBackground.set(!foreground);
        if (foreground && this.foregroundUpdatedHandler != null) {
            this.foregroundUpdatedHandler.handle(this);
        }
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle(this.process.status());
        }
        if (foreground) {
            this.shell.setForegroundJob(this);
        } else {
            this.shell.setForegroundJob(null);
        }
        return this;
    }

    @Override
    public Job suspend() {
        try {
            this.process.suspend(new SuspendHandler());
        }
        catch (IllegalStateException ignore) {
            return this;
        }
        if (!this.runInBackground.get() && this.foregroundUpdatedHandler != null) {
            this.foregroundUpdatedHandler.handle(null);
        }
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle(this.process.status());
        }
        this.shell.setForegroundJob(null);
        return this;
    }

    @Override
    public void terminate() {
        try {
            this.process.terminate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.controller.removeJob(this.id);
    }

    @Override
    public Process process() {
        return this.process;
    }

    @Override
    public ExecStatus status() {
        return this.process.status();
    }

    @Override
    public String line() {
        return this.line;
    }

    @Override
    public Job toBackground() {
        if (!this.runInBackground.get() && this.runInBackground.compareAndSet(false, true)) {
            this.process.toBackground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle(this.process.status());
            }
        }
        this.shell.setForegroundJob(null);
        return this;
    }

    @Override
    public Job toForeground() {
        if (this.runInBackground.get() && this.runInBackground.compareAndSet(true, false)) {
            if (this.foregroundUpdatedHandler != null) {
                this.foregroundUpdatedHandler.handle(this);
            }
            this.process.toForeground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle(this.process.status());
            }
            this.shell.setForegroundJob(this);
        }
        return this;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Job run() {
        return this.run(!this.runInBackground.get());
    }

    @Override
    public Job run(boolean foreground) {
        if (foreground && this.foregroundUpdatedHandler != null) {
            this.foregroundUpdatedHandler.handle(this);
        }
        this.actualStatus = ExecStatus.RUNNING;
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle(ExecStatus.RUNNING);
        }
        this.process.setTty(this.shell.term());
        this.process.setSession(this.shell.session());
        this.process.run(foreground);
        if (!foreground && this.foregroundUpdatedHandler != null) {
            this.foregroundUpdatedHandler.handle(null);
        }
        if (foreground) {
            this.shell.setForegroundJob(this);
        } else {
            this.shell.setForegroundJob(null);
        }
        return this;
    }

    private class SuspendHandler
    implements Handler<Void> {
        private SuspendHandler() {
        }

        @Override
        public void handle(Void event) {
            JobImpl.this.actualStatus = ExecStatus.STOPPED;
        }
    }

    private class ResumeHandler
    implements Handler<Void> {
        private ResumeHandler() {
        }

        @Override
        public void handle(Void event) {
            JobImpl.this.actualStatus = ExecStatus.RUNNING;
        }
    }

    private class TerminatedHandler
    implements Handler<Integer> {
        private final JobControllerImpl controller;

        public TerminatedHandler(JobControllerImpl controller) {
            this.controller = controller;
        }

        @Override
        public void handle(Integer exitCode) {
            if (!JobImpl.this.runInBackground.get() && JobImpl.this.actualStatus.equals((Object)ExecStatus.RUNNING) && JobImpl.this.foregroundUpdatedHandler != null) {
                JobImpl.this.foregroundUpdatedHandler.handle(null);
            }
            this.controller.removeJob(JobImpl.this.id);
            if (JobImpl.this.statusUpdateHandler != null) {
                JobImpl.this.statusUpdateHandler.handle(ExecStatus.TERMINATED);
            }
            JobImpl.this.terminateFuture.complete();
        }
    }
}

