/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArrayUtils;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Renderer;
import com.taobao.text.renderers.ThreadRenderer;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

@Name(value="thread")
@Summary(value="Display thread info, thread stack")
@Description(value="\nEXAMPLES:\n  thread\n  thread 51\n  thread -n -1\n  thread -n 5\n  thread -b\n  thread -i 2000\n\nWIKI:\n  middleware-container/arthas/wikis/cmds/thread")
public class ThreadCommand
extends AnnotatedCommand {
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private long id = -1L;
    private Integer topNBusy = null;
    private boolean findMostBlockingThread = false;
    private int sampleInterval = 100;

    @Argument(index=0, required=false, argName="id")
    @Description(value="Show thread stack")
    public void setId(long id) {
        this.id = id;
    }

    @Option(shortName="n", longName="top-n-threads")
    @Description(value="The number of thread(s) to show, ordered by cpu utilization, -1 to show all.")
    public void setTopNBusy(Integer topNBusy) {
        this.topNBusy = topNBusy;
    }

    @Option(shortName="b", longName="include-blocking-thread", flag=true)
    @Description(value="Find the thread who is holding a lock that blocks the most number of threads.")
    public void setFindMostBlockingThread(boolean findMostBlockingThread) {
        this.findMostBlockingThread = findMostBlockingThread;
    }

    @Option(shortName="i", longName="sample-interval")
    @Description(value="Specify the sampling interval (in ms) when calculating cpu usage.")
    public void setSampleInterval(int sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            if (this.id > 0L) {
                this.processThread(process);
            } else if (this.topNBusy != null) {
                this.processTopBusyThreads(process);
            } else if (this.findMostBlockingThread) {
                this.processBlockingThread(process);
            } else {
                this.processAllThreads(process);
            }
        }
        finally {
            process.write(affect + "\n");
            process.end();
        }
    }

    private void processAllThreads(CommandProcess process) {
        Map<String, Thread> threads = ThreadUtil.getThreads();
        StringBuilder threadStat = new StringBuilder();
        HashMap<Thread.State, Integer> stateCountMap = new HashMap<Thread.State, Integer>();
        for (Thread.State state : Thread.State.values()) {
            stateCountMap.put(state, 0);
        }
        for (Thread thread : threads.values()) {
            Thread.State threadState = thread.getState();
            Integer n = (Integer)stateCountMap.get((Object)threadState);
            stateCountMap.put(threadState, n + 1);
        }
        threadStat.append("Threads Total: ").append(threads.values().size());
        for (Thread.State state : Thread.State.values()) {
            Integer count = (Integer)stateCountMap.get((Object)state);
            threadStat.append(", ").append(state.name()).append(": ").append(count);
        }
        String stat = RenderUtil.render((Element)new LabelElement((Object)threadStat), (int)process.width());
        String content = RenderUtil.render(threads.values().iterator(), (Renderer)new ThreadRenderer((long)this.sampleInterval), (int)process.width());
        process.write(stat + content);
    }

    private void processBlockingThread(CommandProcess process) {
        ThreadUtil.BlockingLockInfo blockingLockInfo = ThreadUtil.findMostBlockingLock();
        if (blockingLockInfo.threadInfo == null) {
            process.write("No most blocking thread found!\n");
        } else {
            String stacktrace = ThreadUtil.getFullStacktrace(blockingLockInfo);
            process.write(stacktrace);
        }
    }

    private void processTopBusyThreads(CommandProcess process) {
        Map<Long, Long> topNThreads = ThreadUtil.getTopNThreads(this.sampleInterval, this.topNBusy);
        Long[] tids = topNThreads.keySet().toArray(new Long[topNThreads.keySet().size()]);
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(ArrayUtils.toPrimitive(tids), true, true);
        if (threadInfos == null) {
            process.write("thread do not exist! id: " + this.id + "\n");
        } else {
            for (ThreadInfo info : threadInfos) {
                String stacktrace = ThreadUtil.getFullStacktrace(info, topNThreads.get(info.getThreadId()));
                process.write(stacktrace + "\n");
            }
        }
    }

    private void processThread(CommandProcess process) {
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(new long[]{this.id}, true, true);
        String content = threadInfos == null || threadInfos[0] == null ? "thread do not exist! id: " + this.id + "\n" : ThreadUtil.getFullStacktrace(threadInfos[0], -1L);
        process.write(content);
    }
}

