/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.arthas.core.command.monitor200.DashboardInterruptHandler;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.NetUtils;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.arthas.core.util.metrics.SumRateCounter;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Renderer;
import com.taobao.text.Style;
import com.taobao.text.renderers.ThreadRenderer;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

@Name(value="dashboard")
@Summary(value="Overview of target jvm's thread, memory, gc, vm, tomcat info.")
@Description(value="\nEXAMPLES:\n  dashboard\n  dashboard -n 10\n  dashboard -i 2000\n\nWIKI:\n  middleware-container/arthas/wikis/cmds/dashboard")
public class DashboardCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private SumRateCounter tomcatRequestCounter = new SumRateCounter();
    private SumRateCounter tomcatErrorCounter = new SumRateCounter();
    private SumRateCounter tomcatReceivedBytesCounter = new SumRateCounter();
    private SumRateCounter tomcatSentBytesCounter = new SumRateCounter();
    private int numOfExecutions = Integer.MAX_VALUE;
    private boolean batchMode;
    private long interval = 5000L;
    private volatile long count = 0L;
    private volatile Timer timer;
    private Boolean running = false;

    @Option(shortName="n", longName="number-of-execution")
    @Description(value="The number of times this command will be executed.")
    public void setNumOfExecutions(int numOfExecutions) {
        this.numOfExecutions = numOfExecutions;
    }

    @Option(shortName="b", longName="batch")
    @Description(value="Execute this command in batch mode.")
    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="The interval (in ms) between two executions, default is 5000 ms.")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public void process(final CommandProcess process) {
        Session session = process.session();
        this.timer = new Timer("Timer-for-arthas-dashboard-" + session.getSessionId(), true);
        process.interruptHandler(new DashboardInterruptHandler(process, this.timer));
        Handler<Void> stopHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                DashboardCommand.this.stop();
            }
        };
        Handler<Void> restartHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                DashboardCommand.this.restart(process);
            }
        };
        process.suspendHandler(stopHandler);
        process.resumeHandler(restartHandler);
        process.endHandler(stopHandler);
        this.timer.scheduleAtFixedRate((TimerTask)new DashboardTimerTask(process), 0L, this.getInterval());
        this.running = true;
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public synchronized void restart(CommandProcess process) {
        if (this.timer == null) {
            Session session = process.session();
            this.timer = new Timer("Timer-for-arthas-dashboard-" + session.getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new DashboardTimerTask(process), 0L, this.getInterval());
        }
    }

    public int getNumOfExecutions() {
        return this.numOfExecutions;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public long getInterval() {
        return this.interval;
    }

    private static String beautifyName(String name) {
        return name.replace(' ', '_').toLowerCase();
    }

    private static void addBufferPoolMemoryInfo(TableElement table) {
        try {
            Class<?> bufferPoolMXBeanClass = Class.forName("java.lang.management.BufferPoolMXBean");
            List<BufferPoolMXBean> bufferPoolMXBeans = ManagementFactory.getPlatformMXBeans(bufferPoolMXBeanClass);
            for (BufferPoolMXBean mbean : bufferPoolMXBeans) {
                long used = mbean.getMemoryUsed();
                long total = mbean.getTotalCapacity();
                new MemoryEntry(mbean.getName(), used, total, Long.MIN_VALUE).addTableRow(table);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void addRuntimeInfo(TableElement table) {
        table.row(new String[]{"os.name", System.getProperty("os.name")});
        table.row(new String[]{"os.version", System.getProperty("os.version")});
        table.row(new String[]{"java.version", System.getProperty("java.version")});
        table.row(new String[]{"java.home", System.getProperty("java.home")});
        table.row(new String[]{"systemload.average", String.format("%.2f", ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage())});
        table.row(new String[]{"processors", "" + Runtime.getRuntime().availableProcessors()});
        table.row(new String[]{"uptime", "" + ManagementFactory.getRuntimeMXBean().getUptime() / 1000L + "s"});
    }

    private static void addMemoryInfo(TableElement table) {
        String poolName;
        MemoryUsage usage;
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        new MemoryEntry("heap", heapMemoryUsage).addTableRow(table, Decoration.bold.bold());
        for (MemoryPoolMXBean poolMXBean : memoryPoolMXBeans) {
            if (!MemoryType.HEAP.equals((Object)poolMXBean.getType())) continue;
            usage = poolMXBean.getUsage();
            poolName = DashboardCommand.beautifyName(poolMXBean.getName());
            new MemoryEntry(poolName, usage).addTableRow(table);
        }
        new MemoryEntry("nonheap", nonHeapMemoryUsage).addTableRow(table, Decoration.bold.bold());
        for (MemoryPoolMXBean poolMXBean : memoryPoolMXBeans) {
            if (!MemoryType.NON_HEAP.equals((Object)poolMXBean.getType())) continue;
            usage = poolMXBean.getUsage();
            poolName = DashboardCommand.beautifyName(poolMXBean.getName());
            new MemoryEntry(poolName, usage).addTableRow(table);
        }
        DashboardCommand.addBufferPoolMemoryInfo(table);
    }

    private static void addGcInfo(TableElement table) {
        List<GarbageCollectorMXBean> garbageCollectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMxBeans) {
            String name = garbageCollectorMXBean.getName();
            table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"gc." + DashboardCommand.beautifyName(name) + ".count", "" + garbageCollectorMXBean.getCollectionCount()}));
            table.row(new String[]{"gc." + DashboardCommand.beautifyName(name) + ".time(ms)", "" + garbageCollectorMXBean.getCollectionTime()});
        }
    }

    private static String formatBytes(long size) {
        int unit = 1;
        String unitStr = "B";
        if (size / 1024L > 0L) {
            unit = 1024;
            unitStr = "K";
        } else if (size / 1024L / 1024L > 0L) {
            unit = 0x100000;
            unitStr = "M";
        }
        return String.format("%d%s", size / (long)unit, unitStr);
    }

    private void addTomcatInfo(TableElement table) {
        NetUtils.Response threadPoolResponse;
        String threadPoolPath = "http://localhost:8006/connector/threadpool";
        String connectorStatPath = "http://localhost:8006/connector/stats";
        NetUtils.Response connectorStatResponse = NetUtils.request(connectorStatPath);
        if (connectorStatResponse.isSuccess()) {
            List connectorStats = JSON.parseArray((String)connectorStatResponse.getContent(), JSONObject.class);
            for (JSONObject stat : connectorStats) {
                String name = stat.getString("name").replace("\"", "");
                long bytesReceived = stat.getLongValue("bytesReceived");
                long bytesSent = stat.getLongValue("bytesSent");
                long processingTime = stat.getLongValue("processingTime");
                long requestCount = stat.getLongValue("requestCount");
                long errorCount = stat.getLongValue("errorCount");
                this.tomcatRequestCounter.update(requestCount);
                this.tomcatErrorCounter.update(errorCount);
                this.tomcatReceivedBytesCounter.update(bytesReceived);
                this.tomcatSentBytesCounter.update(bytesSent);
                table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"connector", name}));
                table.row(new String[]{"QPS", String.format("%.2f", this.tomcatRequestCounter.rate())});
                table.row(new String[]{"RT(ms)", String.format("%.2f", (double)processingTime / (double)requestCount)});
                table.row(new String[]{"error/s", String.format("%.2f", this.tomcatErrorCounter.rate())});
                table.row(new String[]{"received/s", DashboardCommand.formatBytes((long)this.tomcatReceivedBytesCounter.rate())});
                table.row(new String[]{"sent/s", DashboardCommand.formatBytes((long)this.tomcatSentBytesCounter.rate())});
            }
        }
        if ((threadPoolResponse = NetUtils.request(threadPoolPath)).isSuccess()) {
            List threadPoolInfos = JSON.parseArray((String)threadPoolResponse.getContent(), JSONObject.class);
            for (JSONObject info : threadPoolInfos) {
                String name = info.getString("name").replace("\"", "");
                long busy = info.getLongValue("threadBusy");
                long total = info.getLongValue("threadCount");
                table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"threadpool", name}));
                table.row(new String[]{"busy", "" + busy});
                table.row(new String[]{"total", "" + total});
            }
        }
    }

    static String drawThreadInfo(int width, int height) {
        Map<String, Thread> threads = ThreadUtil.getThreads();
        return RenderUtil.render(threads.values().iterator(), (Renderer)new ThreadRenderer(), (int)width, (int)height);
    }

    static String drawMemoryInfoAndGcInfo(int width, int height) {
        TableElement table = new TableElement(new int[]{1, 1});
        TableElement memoryInfoTable = new TableElement(new int[]{3, 1, 1, 1, 1}).rightCellPadding(1);
        memoryInfoTable.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add(new String[]{"Memory", "used", "total", "max", "usage"}));
        DashboardCommand.addMemoryInfo(memoryInfoTable);
        TableElement gcInfoTable = new TableElement(new int[]{1, 1}).rightCellPadding(1);
        gcInfoTable.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add(new String[]{"GC", ""}));
        DashboardCommand.addGcInfo(gcInfoTable);
        table.row(new Element[]{memoryInfoTable, gcInfoTable});
        return RenderUtil.render((Element)table, (int)width, (int)height);
    }

    String drawRuntineInfoAndTomcatInfo(int width, int height) {
        TableElement table = new TableElement(new int[]{1, 1});
        TableElement runtimeInfoTable = new TableElement(new int[]{1, 1}).rightCellPadding(1);
        runtimeInfoTable.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add(new String[]{"Runtime", ""}));
        DashboardCommand.addRuntimeInfo(runtimeInfoTable);
        TableElement tomcatInfoTable = new TableElement(new int[]{1, 1}).rightCellPadding(1);
        try {
            if (NetUtils.request("http://localhost:8006").isSuccess()) {
                tomcatInfoTable.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add(new String[]{"Tomcat", ""}));
                this.addTomcatInfo(tomcatInfoTable);
            }
        }
        catch (Throwable t) {
            logger.error(null, "get Tomcat Info error!", t);
        }
        table.row(new Element[]{runtimeInfoTable, tomcatInfoTable});
        return RenderUtil.render((Element)table, (int)width, (int)height);
    }

    private class DashboardTimerTask
    extends TimerTask {
        private CommandProcess process;

        public DashboardTimerTask(CommandProcess process) {
            this.process = process;
        }

        @Override
        public void run() {
            if (DashboardCommand.this.count >= (long)DashboardCommand.this.getNumOfExecutions()) {
                DashboardCommand.this.timer.cancel();
                DashboardCommand.this.timer.purge();
                this.process.write("Process ends after " + DashboardCommand.this.getNumOfExecutions() + " time(s).\n");
                this.process.end();
                return;
            }
            int width = this.process.width();
            int height = this.process.height();
            int totalHeight = height - 1;
            int threadTopHeight = totalHeight / 2;
            int lowerHalf = totalHeight - threadTopHeight;
            int runtimeInfoHeight = lowerHalf / 2;
            int heapInfoHeight = lowerHalf - runtimeInfoHeight;
            String threadInfo = DashboardCommand.drawThreadInfo(width, threadTopHeight);
            String memoryAndGc = DashboardCommand.drawMemoryInfoAndGcInfo(width, runtimeInfoHeight);
            String runTimeAndTomcat = DashboardCommand.this.drawRuntineInfoAndTomcatInfo(width, heapInfoHeight);
            this.process.write(threadInfo + memoryAndGc + runTimeAndTomcat);
            DashboardCommand.this.count++;
            this.process.times().incrementAndGet();
        }
    }

    static class MemoryEntry {
        String name;
        long used;
        long total;
        long max;
        int unit;
        String unitStr;

        public MemoryEntry(String name, long used, long total, long max) {
            this.name = name;
            this.used = used;
            this.total = total;
            this.max = max;
            this.unitStr = "K";
            this.unit = 1024;
            if (used / 1024L / 1024L > 0L) {
                this.unitStr = "M";
                this.unit = 0x100000;
            }
        }

        public MemoryEntry(String name, MemoryUsage usage) {
            this(name, usage.getUsed(), usage.getCommitted(), usage.getMax());
        }

        private String format(long value) {
            String valueStr = "-";
            if (value == -1L) {
                return "-1";
            }
            if (value != Long.MIN_VALUE) {
                valueStr = value / (long)this.unit + this.unitStr;
            }
            return valueStr;
        }

        public void addTableRow(TableElement table) {
            double usage = (double)this.used / (double)(this.max == -1L || this.max == Long.MIN_VALUE ? this.total : this.max) * 100.0;
            table.row(new String[]{this.name, this.format(this.used), this.format(this.total), this.format(this.max), String.format("%.2f%%", usage)});
        }

        public void addTableRow(TableElement table, Style.Composite style) {
            double usage = (double)this.used / (double)(this.max == -1L || this.max == Long.MIN_VALUE ? this.total : this.max) * 100.0;
            table.add(new RowElement().style(style).add(new String[]{this.name, this.format(this.used), this.format(this.total), this.format(this.max), String.format("%.2f%%", usage)}));
        }
    }
}

