/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import com.taobao.arthas.common.PlatformEnum;
import java.util.Locale;

public class OSUtils {
    private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    static PlatformEnum platform = OPERATING_SYSTEM_NAME.startsWith("linux") ? PlatformEnum.LINUX : (OPERATING_SYSTEM_NAME.startsWith("mac") || OPERATING_SYSTEM_NAME.startsWith("darwin") ? PlatformEnum.MACOSX : (OPERATING_SYSTEM_NAME.startsWith("windows") ? PlatformEnum.WINDOWS : PlatformEnum.UNKNOWN));

    public static boolean isWindows() {
        return platform == PlatformEnum.WINDOWS;
    }

    public static boolean isLinux() {
        return platform == PlatformEnum.LINUX;
    }

    public static boolean isMac() {
        return platform == PlatformEnum.MACOSX;
    }

    public static boolean isCygwinOrMinGW() {
        return OSUtils.isWindows() && (System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") || "/bin/bash".equals(System.getenv("SHELL")));
    }
}

