/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.client;

import com.taobao.arthas.client.IOUtil;
import com.taobao.arthas.common.OSUtils;
import com.taobao.arthas.common.UsageRender;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.UsageMessageFormatter;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jline.Terminal;
import jline.TerminalSupport;
import jline.UnixTerminal;
import jline.console.ConsoleReader;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;

@Name(value="arthas-client")
@Summary(value="Arthas Telnet Client")
@Description(value="EXAMPLES:\n  java -jar arthas-client.jar 127.0.0.1 3658\n  java -jar arthas-client.jar -c 'dashboard -n 1' \n  java -jar arthas-client.jar -f batch.as 127.0.0.1\n")
public class TelnetConsole {
    private static final String PROMPT = "$";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final byte CTRL_C = 3;
    private boolean help = false;
    private String targetIp = "127.0.0.1";
    private int port = 3658;
    private String command;
    private String batchFile;
    private Integer width = null;
    private Integer height = null;

    @Argument(argName="target-ip", index=0, required=false)
    @Description(value="Target ip")
    public void setTargetIp(String targetIp) {
        this.targetIp = targetIp;
    }

    @Argument(argName="port", index=1, required=false)
    @Description(value="The remote server port")
    public void setPort(int port) {
        this.port = port;
    }

    @Option(longName="help", flag=true)
    @Description(value="Print usage")
    public void setHelp(boolean help) {
        this.help = help;
    }

    @Option(shortName="c", longName="command")
    @Description(value="Command to execute, multiple commands separated by ;")
    public void setCommand(String command) {
        this.command = command;
    }

    @Option(shortName="f", longName="batch-file")
    @Description(value="The batch file to execute")
    public void setBatchFile(String batchFile) {
        this.batchFile = batchFile;
    }

    @Option(shortName="w", longName="width")
    @Description(value="The terminal width")
    public void setWidth(int width) {
        this.width = width;
    }

    @Option(shortName="h", longName="height")
    @Description(value="The terminal height")
    public void setheight(int height) {
        this.height = height;
    }

    private static String readUntil(InputStream in, String prompt) {
        try {
            StringBuilder sBuffer = new StringBuilder();
            byte[] b = new byte[1024];
            while (true) {
                int size;
                if (-1 == (size = in.read(b))) {
                    continue;
                }
                sBuffer.append(new String(b, 0, size));
                String data = sBuffer.toString();
                if (data.trim().endsWith(prompt)) break;
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(File batchFile) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(batchFile));
            String line = br.readLine();
            while (line != null) {
                list.add(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public static void main(String[] args) throws IOException {
        if (OSUtils.isCygwinOrMinGW()) {
            System.setProperty("jline.terminal", System.getProperty("jline.terminal", "jline.UnixTerminal"));
        }
        TelnetConsole telnetConsole = new TelnetConsole();
        CLI cli = CLIConfigurator.define(TelnetConsole.class);
        try {
            CommandLine commandLine = cli.parse(Arrays.asList(args));
            CLIConfigurator.inject((CommandLine)commandLine, (Object)telnetConsole);
            if (telnetConsole.isHelp()) {
                System.out.println(TelnetConsole.usage(cli));
                System.exit(0);
            }
            ArrayList<String> cmds = new ArrayList<String>();
            if (telnetConsole.getCommand() != null) {
                for (String c : telnetConsole.getCommand().split(";")) {
                    cmds.add(c.trim());
                }
            } else if (telnetConsole.getBatchFile() != null) {
                File file = new File(telnetConsole.getBatchFile());
                if (!file.exists()) {
                    throw new IllegalArgumentException("batch file do not exist: " + telnetConsole.getBatchFile());
                }
                cmds.addAll(TelnetConsole.readLines(file));
            }
            final ConsoleReader consoleReader = new ConsoleReader(System.in, (OutputStream)System.out);
            consoleReader.setHandleUserInterrupt(true);
            Terminal terminal = consoleReader.getTerminal();
            if (terminal instanceof TerminalSupport) {
                ((TerminalSupport)terminal).disableInterruptCharacter();
            }
            terminal.disableInterruptCharacter();
            if (terminal instanceof UnixTerminal) {
                ((UnixTerminal)terminal).disableLitteralNextCharacter();
            }
            int width = 80;
            int height = 24;
            if (!cmds.isEmpty()) {
                if (telnetConsole.getWidth() != null) {
                    width = telnetConsole.getWidth();
                }
                if (telnetConsole.getheight() != null) {
                    height = telnetConsole.getheight();
                }
            } else {
                if (telnetConsole.getWidth() != null) {
                    width = telnetConsole.getWidth();
                } else {
                    width = terminal.getWidth();
                    if (OSUtils.isWindows()) {
                        --width;
                    }
                }
                height = telnetConsole.getheight() != null ? telnetConsole.getheight().intValue() : terminal.getHeight();
            }
            final TelnetClient telnet = new TelnetClient();
            telnet.setConnectTimeout(5000);
            WindowSizeOptionHandler sizeOpt = new WindowSizeOptionHandler(width, height, true, true, false, false);
            try {
                telnet.addOptionHandler(sizeOpt);
            }
            catch (InvalidTelnetOptionException invalidTelnetOptionException) {
                // empty catch block
            }
            consoleReader.getKeys().bind((CharSequence)new Character('\u0003').toString(), (Object)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        consoleReader.getCursorBuffer().clear();
                        telnet.getOutputStream().write(3);
                        telnet.getOutputStream().flush();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
            consoleReader.getKeys().bind((CharSequence)new Character('\u0004').toString(), (Object)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            try {
                telnet.connect(telnetConsole.getTargetIp(), telnetConsole.getPort());
            }
            catch (IOException e) {
                System.out.println("Connect to telnet server error: " + telnetConsole.getTargetIp() + " " + telnetConsole.getPort());
                throw e;
            }
            if (cmds.isEmpty()) {
                IOUtil.readWrite(telnet.getInputStream(), telnet.getOutputStream(), System.in, consoleReader.getOutput());
            } else {
                TelnetConsole.batchModeRun(telnet, cmds);
                telnet.disconnect();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(TelnetConsole.usage(cli));
            System.exit(1);
        }
    }

    private static void batchModeRun(TelnetClient telnet, List<String> commands) throws IOException {
        InputStream inputStream = telnet.getInputStream();
        OutputStream outputStream = telnet.getOutputStream();
        for (String command : commands) {
            if (command.trim().isEmpty()) continue;
            outputStream.write((command + " | plaintext\n").getBytes());
            outputStream.flush();
            String response = TelnetConsole.readUntil(inputStream, PROMPT);
            System.out.print(response);
            System.out.flush();
        }
    }

    private static String usage(CLI cli) {
        StringBuilder usageStringBuilder = new StringBuilder();
        UsageMessageFormatter usageMessageFormatter = new UsageMessageFormatter();
        usageMessageFormatter.setOptionComparator(null);
        cli.usage(usageStringBuilder, usageMessageFormatter);
        return UsageRender.render((String)usageStringBuilder.toString());
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public int getPort() {
        return this.port;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBatchFile() {
        return this.batchFile;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getheight() {
        return this.height;
    }

    public boolean isHelp() {
        return this.help;
    }
}

