/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.agent334;

import com.taobao.arthas.agent.ArthasClassloader;
import java.arthas.SpyAPI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;

public class AgentBootstrap {
    private static final String ARTHAS_CORE_JAR = "arthas-core.jar";
    private static final String ARTHAS_BOOTSTRAP = "com.taobao.arthas.core.server.ArthasBootstrap";
    private static final String GET_INSTANCE = "getInstance";
    private static final String IS_BIND = "isBind";
    private static PrintStream ps = System.err;
    private static volatile ClassLoader arthasClassLoader;

    public static void premain(String args, Instrumentation inst) {
        AgentBootstrap.main(args, inst);
    }

    public static void agentmain(String args, Instrumentation inst) {
        AgentBootstrap.main(args, inst);
    }

    public static synchronized void resetArthasClassLoader() {
        arthasClassLoader = null;
    }

    private static ClassLoader getClassLoader(Instrumentation inst, File arthasCoreJarFile) throws Throwable {
        return AgentBootstrap.loadOrDefineClassLoader(arthasCoreJarFile);
    }

    private static ClassLoader loadOrDefineClassLoader(File arthasCoreJarFile) throws Throwable {
        if (arthasClassLoader == null) {
            arthasClassLoader = new ArthasClassloader(new URL[]{arthasCoreJarFile.toURI().toURL()});
        }
        return arthasClassLoader;
    }

    private static synchronized void main(String args, final Instrumentation inst) {
        try {
            Class.forName("java.arthas.SpyAPI");
            if (SpyAPI.isInited()) {
                ps.println("Arthas server already stared, skip attach.");
                ps.flush();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String agentArgs;
            String arthasCoreJar;
            int index;
            ps.println("Arthas server agent start...");
            if (args == null) {
                args = "";
            }
            if ((index = (args = AgentBootstrap.decodeArg(args)).indexOf(59)) != -1) {
                arthasCoreJar = args.substring(0, index);
                agentArgs = args.substring(index);
            } else {
                arthasCoreJar = "";
                agentArgs = args;
            }
            File arthasCoreJarFile = new File(arthasCoreJar);
            if (!arthasCoreJarFile.exists()) {
                ps.println("Can not find arthas-core jar file from args: " + arthasCoreJarFile);
                CodeSource codeSource = AgentBootstrap.class.getProtectionDomain().getCodeSource();
                if (codeSource != null) {
                    try {
                        File arthasAgentJarFile = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                        arthasCoreJarFile = new File(arthasAgentJarFile.getParentFile(), ARTHAS_CORE_JAR);
                        if (!arthasCoreJarFile.exists()) {
                            ps.println("Can not find arthas-core jar file from agent jar directory: " + arthasAgentJarFile);
                        }
                    }
                    catch (Throwable e) {
                        ps.println("Can not find arthas-core jar file from " + codeSource.getLocation());
                        e.printStackTrace(ps);
                    }
                }
            }
            if (!arthasCoreJarFile.exists()) {
                return;
            }
            final ClassLoader agentLoader = AgentBootstrap.getClassLoader(inst, arthasCoreJarFile);
            Thread bindingThread = new Thread(){

                @Override
                public void run() {
                    try {
                        AgentBootstrap.bind(inst, agentLoader, agentArgs);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(ps);
                    }
                }
            };
            bindingThread.setName("arthas-binding-thread");
            bindingThread.start();
            bindingThread.join();
        }
        catch (Throwable t) {
            t.printStackTrace(ps);
            try {
                if (ps != System.err) {
                    ps.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(t);
        }
    }

    private static void bind(Instrumentation inst, ClassLoader agentLoader, String args) throws Throwable {
        Class<?> bootstrapClass = agentLoader.loadClass(ARTHAS_BOOTSTRAP);
        Object bootstrap = bootstrapClass.getMethod(GET_INSTANCE, Instrumentation.class, String.class).invoke(null, inst, args);
        boolean isBind = (Boolean)bootstrapClass.getMethod(IS_BIND, new Class[0]).invoke(bootstrap, new Object[0]);
        if (!isBind) {
            String errorMsg = "Arthas server port binding failed! Please check $HOME/logs/arthas/arthas.log for more details.";
            ps.println(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        ps.println("Arthas server already bind.");
    }

    private static String decodeArg(String arg) {
        try {
            return URLDecoder.decode(arg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return arg;
        }
    }

    static {
        try {
            File log;
            File arthasLogDir = new File(System.getProperty("user.home") + File.separator + "logs" + File.separator + "arthas" + File.separator);
            if (!arthasLogDir.exists()) {
                arthasLogDir.mkdirs();
            }
            if (!arthasLogDir.exists() && !(arthasLogDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "logs" + File.separator + "arthas" + File.separator)).exists()) {
                arthasLogDir.mkdirs();
            }
            if (!(log = new File(arthasLogDir, "arthas.log")).exists()) {
                log.createNewFile();
            }
            ps = new PrintStream(new FileOutputStream(log, true));
        }
        catch (Throwable t) {
            t.printStackTrace(ps);
        }
    }
}

