/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.agent3;

import com.taobao.arthas.agent.ArthasClassloader;
import java.arthas.Spy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarFile;

public class AgentBootstrap {
    private static final String RESET = "resetArthasClassLoader";
    private static final String ARTHAS_SPY_JAR = "arthas-spy.jar";
    private static final String ARTHAS_BOOTSTRAP = "com.taobao.arthas.core.server.ArthasBootstrap";
    private static final String GET_INSTANCE = "getInstance";
    private static final String IS_BIND = "isBind";
    private static final String BIND = "bind";
    private static PrintStream ps = System.err;
    private static volatile ClassLoader arthasClassLoader;

    public static void premain(String args, Instrumentation inst) {
        AgentBootstrap.main(args, inst);
    }

    public static void agentmain(String args, Instrumentation inst) {
        AgentBootstrap.main(args, inst);
    }

    public static synchronized void resetArthasClassLoader() {
        arthasClassLoader = null;
    }

    private static ClassLoader getClassLoader(Instrumentation inst, File spyJarFile, File agentJarFile) throws Throwable {
        ClassLoader parent = ClassLoader.getSystemClassLoader().getParent();
        Object spyClass = null;
        if (parent != null) {
            try {
                parent.loadClass("java.arthas.Spy");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (spyClass == null) {
            inst.appendToBootstrapClassLoaderSearch(new JarFile(spyJarFile));
        }
        return AgentBootstrap.loadOrDefineClassLoader(agentJarFile);
    }

    private static ClassLoader loadOrDefineClassLoader(File agentJar) throws Throwable {
        if (arthasClassLoader == null) {
            arthasClassLoader = new ArthasClassloader(new URL[]{agentJar.toURI().toURL()});
        }
        return arthasClassLoader;
    }

    private static void initSpy() throws NoSuchMethodException {
        Spy.AGENT_RESET_METHOD = AgentBootstrap.class.getMethod(RESET, new Class[0]);
    }

    private static synchronized void main(String args, final Instrumentation inst) {
        try {
            ps.println("Arthas server agent start...");
            args = AgentBootstrap.decodeArg(args);
            int index = args.indexOf(59);
            String agentJar = args.substring(0, index);
            final String agentArgs = args.substring(index);
            File agentJarFile = new File(agentJar);
            if (!agentJarFile.exists()) {
                ps.println("Agent jar file does not exist: " + agentJarFile);
                return;
            }
            File spyJarFile = new File(agentJarFile.getParentFile(), ARTHAS_SPY_JAR);
            if (!spyJarFile.exists()) {
                ps.println("Spy jar file does not exist: " + spyJarFile);
                return;
            }
            final ClassLoader agentLoader = AgentBootstrap.getClassLoader(inst, spyJarFile, agentJarFile);
            AgentBootstrap.initSpy();
            Thread bindingThread = new Thread(){

                @Override
                public void run() {
                    try {
                        AgentBootstrap.bind(inst, agentLoader, agentArgs);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(ps);
                    }
                }
            };
            bindingThread.setName("arthas-binding-thread");
            bindingThread.start();
            bindingThread.join();
        }
        catch (Throwable t) {
            t.printStackTrace(ps);
            try {
                if (ps != System.err) {
                    ps.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(t);
        }
    }

    private static void bind(Instrumentation inst, ClassLoader agentLoader, String args) throws Throwable {
        Class<?> bootstrapClass = agentLoader.loadClass(ARTHAS_BOOTSTRAP);
        Object bootstrap = bootstrapClass.getMethod(GET_INSTANCE, Instrumentation.class, String.class).invoke(null, inst, args);
        boolean isBind = (Boolean)bootstrapClass.getMethod(IS_BIND, new Class[0]).invoke(bootstrap, new Object[0]);
        if (!isBind) {
            try {
                ps.println("Arthas start to bind...");
                bootstrapClass.getMethod(BIND, String.class).invoke(bootstrap, args);
                ps.println("Arthas server bind success.");
                return;
            }
            catch (Exception e) {
                ps.println("Arthas server port binding failed! Please check $HOME/logs/arthas/arthas.log for more details.");
                throw e;
            }
        }
        ps.println("Arthas server already bind.");
    }

    private static String decodeArg(String arg) {
        try {
            return URLDecoder.decode(arg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return arg;
        }
    }

    static {
        try {
            File log;
            File arthasLogDir = new File(System.getProperty("user.home") + File.separator + "logs" + File.separator + "arthas" + File.separator);
            if (!arthasLogDir.exists()) {
                arthasLogDir.mkdirs();
            }
            if (!arthasLogDir.exists() && !(arthasLogDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "logs" + File.separator + "arthas" + File.separator)).exists()) {
                arthasLogDir.mkdirs();
            }
            if (!(log = new File(arthasLogDir, "arthas.log")).exists()) {
                log.createNewFile();
            }
            ps = new PrintStream(new FileOutputStream(log, true));
        }
        catch (Throwable t) {
            t.printStackTrace(ps);
        }
    }
}

