/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.weex.plugin.loader;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.weex.plugin.loader.utils.WeexSDKUtil;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.SimpleComponentHolder;
import com.taobao.weex.ui.component.WXComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class WeexPluginContainer {
    private static final ClassLoader a = WeexPluginContainer.class.getClassLoader();

    public static void loadAll(final Context context, final ClassLoader classLoader) {
        try {
            String string = Thread.currentThread().getName();
            if ("main".equals(string)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Log.i((String)"WeexPluginContainer", (String)("currentThread name [main],start new thread [" + Thread.currentThread().getName() + "] execute"));
                        WeexPluginContainer.loadAdapters(context, classLoader);
                        WeexPluginContainer.loadDomObjects(context, classLoader);
                        WeexPluginContainer.loadComponents(context, classLoader);
                        WeexPluginContainer.loadModules(context, classLoader);
                    }
                }, "loader_weex_plugin_thread").start();
            } else {
                Log.i((String)"WeexPluginContainer", (String)("currentThread name [" + string + "]"));
                WeexPluginContainer.loadAdapters(context, classLoader);
                WeexPluginContainer.loadDomObjects(context, classLoader);
                WeexPluginContainer.loadComponents(context, classLoader);
                WeexPluginContainer.loadModules(context, classLoader);
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"WeexPluginContainer", (String)"Unexpected throwable in loadAll", (Throwable)throwable);
        }
    }

    public static void loadAll(Context context) {
        WeexPluginContainer.loadAll(context, null);
    }

    public static void loadModules(Context context) {
        WeexPluginContainer.loadModules(context, null);
    }

    public static void loadModules(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject jSONObject : WeexPluginContainer.a(context, "weex_plugin/module")) {
                String string = jSONObject.optString("name", null);
                String string2 = jSONObject.optString("class", null);
                boolean bl = jSONObject.optBoolean("canOverrideExisting", true);
                boolean bl2 = jSONObject.optBoolean("globalRegistration", false);
                boolean bl3 = jSONObject.optBoolean("lazyLoad", false);
                JSONArray jSONArray = null;
                if (bl3) {
                    jSONArray = jSONObject.optJSONArray("functions");
                }
                if (string == null || string2 == null) {
                    Log.w((String)"WeexPluginContainer", (String)"Module name or module class is null");
                    continue;
                }
                if (!bl && WeexSDKUtil.containsModule(string, bl2)) {
                    Log.w((String)"WeexPluginContainer", (String)("Ignore duplicated module: " + string));
                    continue;
                }
                try {
                    Class<?> clazz = WeexPluginContainer.loadClass(string2, classLoader);
                    if (clazz == null) continue;
                    if (!WXModule.class.isAssignableFrom(clazz)) {
                        Log.e((String)"WeexPluginContainer", (String)("Class " + string2 + " is not a subclass of WXModule"));
                        continue;
                    }
                    WXSDKEngine.registerModule((String)string, clazz, (boolean)bl2);
                    Log.d((String)"WeexPluginContainer", (String)("Module plugin [" + string + "][clazz:" + clazz + "][globalRegistration:" + bl2 + "][lazyLoad:" + bl3 + "][canOverride:" + bl + "]"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (WXException wXException) {
                    wXException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"WeexPluginContainer", (String)"Unexpected throwable in loadModules", (Throwable)throwable);
        }
    }

    public static void loadComponents(Context context) {
        WeexPluginContainer.loadModules(context, null);
    }

    public static void loadComponents(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject jSONObject : WeexPluginContainer.a(context, "weex_plugin/component")) {
                String string;
                ArrayList<String> arrayList = new ArrayList<String>();
                JSONArray jSONArray = jSONObject.optJSONArray("names");
                for (int i = 0; i < jSONArray.length(); ++i) {
                    string = jSONArray.optString(i);
                    if (TextUtils.isEmpty((CharSequence)string)) continue;
                    arrayList.add(string);
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                string = jSONObject.optString("class");
                boolean bl = jSONObject.optBoolean("appendTree", false);
                boolean bl2 = jSONObject.optBoolean("usingHolder", false);
                boolean bl3 = jSONObject.optBoolean("canOverrideExisting", true);
                String string2 = null;
                if (bl2) {
                    string2 = jSONObject.optString("creator", null);
                }
                if (arrayList.size() == 0 || TextUtils.isEmpty((CharSequence)string)) {
                    Log.w((String)"WeexPluginContainer", (String)"Component names or component class is null");
                    continue;
                }
                if (!bl3 && WeexSDKUtil.containsComponent(arrayList)) {
                    Log.w((String)"WeexPluginContainer", (String)("Ignore duplicated component: " + ((Object)arrayList).toString()));
                    continue;
                }
                try {
                    Class<?> clazz = WeexPluginContainer.loadClass(string, classLoader);
                    if (clazz == null) continue;
                    if (!WXComponent.class.isAssignableFrom(clazz)) {
                        Log.e((String)"WeexPluginContainer", (String)("Class " + string + " is not a subclass of WXComponent"));
                        continue;
                    }
                    if (bl2) {
                        if (string2 == null || !"NULL".equals(string2)) {
                            WXSDKEngine.registerComponent((IFComponentHolder)new SimpleComponentHolder(clazz), (boolean)bl, (String[])stringArray);
                        } else {
                            Class<?> clazz2 = WeexPluginContainer.loadClass(string2, classLoader);
                            if (clazz2 == null) {
                                WXSDKEngine.registerComponent((IFComponentHolder)new SimpleComponentHolder(clazz), (boolean)bl, (String[])stringArray);
                            } else {
                                ComponentCreator componentCreator = (ComponentCreator)clazz2.newInstance();
                                WXSDKEngine.registerComponent((IFComponentHolder)new SimpleComponentHolder(clazz, componentCreator), (boolean)bl, (String[])stringArray);
                            }
                        }
                    } else {
                        WXSDKEngine.registerComponent(clazz, (boolean)bl, (String[])stringArray);
                    }
                    Log.d((String)"WeexPluginContainer", (String)("Component plugin [" + arrayList + "][clazz:" + clazz + "][appendTree:" + bl + "][usingHolder:" + bl2 + "][canOverride:" + bl3 + "][" + string2 + "]"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (WXException wXException) {
                    wXException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"WeexPluginContainer", (String)"Unexpected throwable in loadComponents", (Throwable)throwable);
        }
    }

    public static void loadAdapters(Context context) {
        WeexPluginContainer.loadAdapters(context, null);
    }

    public static void loadAdapters(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject jSONObject : WeexPluginContainer.a(context, "weex_plugin/adapter")) {
                String string = jSONObject.optString("type");
                String string2 = jSONObject.optString("class");
                boolean bl = jSONObject.optBoolean("canOverrideExisting", true);
                if (!WeexSDKUtil.isValidAdapterType(string)) {
                    Log.e((String)"WeexPluginContainer", (String)("Invalid adapter type: " + string));
                    continue;
                }
                if (!bl && WeexSDKUtil.containsAdapter(string)) {
                    Log.w((String)"WeexPluginContainer", (String)("Ignore duplicated adapter: " + string2));
                    continue;
                }
                try {
                    Class<?> clazz = WeexPluginContainer.loadClass(string2, classLoader);
                    if (clazz == null) continue;
                    try {
                        Object obj = clazz.newInstance();
                        String string3 = WeexSDKUtil.getAdapterField(string);
                        Field field = WXSDKManager.class.getDeclaredField(string3);
                        field.setAccessible(true);
                        field.set(WXSDKManager.getInstance(), obj);
                        Log.d((String)"WeexPluginContainer", (String)("Adapter plugin " + string2 + " registered."));
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        noSuchFieldException.printStackTrace();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"WeexPluginContainer", (String)"Unexpected throwable in loadAdapters", (Throwable)throwable);
        }
    }

    public static void loadDomObjects(Context context) {
        WeexPluginContainer.loadDomObjects(context, null);
    }

    public static void loadDomObjects(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject jSONObject : WeexPluginContainer.a(context, "weex_plugin/domObject")) {
                String string = jSONObject.optString("class");
                String string2 = jSONObject.optString("type");
                boolean bl = jSONObject.optBoolean("canOverrideExisting", false);
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                try {
                    Class<?> clazz = WeexPluginContainer.loadClass(string, classLoader);
                    if (clazz == null) continue;
                    if (!WXDomObject.class.isAssignableFrom(clazz)) {
                        Log.e((String)"WeexPluginContainer", (String)("Class " + string + " is not a subclass of WXDomObject"));
                        continue;
                    }
                    if (!WXDomObject.class.isAssignableFrom(clazz)) continue;
                    WXSDKEngine.registerDomObject((String)string2, clazz);
                    Log.d((String)"WeexPluginContainer", (String)("Dom object plugin " + string2 + " registered."));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (WXException wXException) {
                    wXException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"WeexPluginContainer", (String)"Unexpected throwable in loadDomObjects", (Throwable)throwable);
        }
    }

    private static Class<?> loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = a;
        }
        return classLoader.loadClass(string);
    }

    private static List<JSONObject> a(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        try {
            String[] stringArray = assetManager.list(string);
            if (stringArray != null && stringArray.length > 0) {
                for (String string2 : stringArray) {
                    String string3;
                    if (!string2.endsWith(".json")) continue;
                    Log.d((String)"WeexPluginContainer", (String)("Parse plugin meta info >>> " + string2));
                    InputStream inputStream = assetManager.open(string + "/" + string2);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string3);
                    }
                    JSONArray jSONArray = new JSONArray(stringBuffer.toString());
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        JSONObject jSONObject = jSONArray.optJSONObject(i);
                        if (jSONObject == null) continue;
                        arrayList.add(jSONObject);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return arrayList;
    }
}

