/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXLoadingLayout;
import com.taobao.weex.ui.view.WXRefreshLayout;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;

public abstract class BaseBounceView<T extends View>
extends FrameLayout {
    private int mOrientation = 1;
    protected WXSwipeLayout swipeLayout;
    private T innerView;

    public BaseBounceView(Context context, int orientation) {
        this(context, null, orientation);
    }

    public BaseBounceView(Context context, AttributeSet attrs, int orientataion) {
        super(context, attrs);
        this.mOrientation = orientataion;
        this.init(context);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    private void init(Context context) {
        this.createBounceView(context);
    }

    boolean isVertical() {
        return this.mOrientation == 1;
    }

    public void setOnRefreshListener(WXSwipeLayout.WXOnRefreshListener onRefreshListener) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnRefreshListener(onRefreshListener);
        }
    }

    public void setOnLoadingListener(WXSwipeLayout.WXOnLoadingListener onLoadingListener) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnLoadingListener(onLoadingListener);
        }
    }

    public void finishPullRefresh() {
        if (this.swipeLayout != null) {
            this.swipeLayout.finishPullRefresh();
        }
    }

    public void finishPullLoad() {
        if (this.swipeLayout != null) {
            this.swipeLayout.finishPullLoad();
        }
    }

    private WXSwipeLayout createBounceView(Context context) {
        this.swipeLayout = new WXSwipeLayout(context);
        this.swipeLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.innerView = this.setInnerView(context);
        if (this.innerView == null) {
            return null;
        }
        this.swipeLayout.addView((View)this.innerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.swipeLayout, -1, -1);
        return this.swipeLayout;
    }

    public T getInnerView() {
        return this.innerView;
    }

    public abstract T setInnerView(Context var1);

    public void setHeaderView(WXComponent refresh) {
        this.setRefreshEnable(true);
        if (this.swipeLayout != null && this.swipeLayout.getHeaderView() != null) {
            int colorInt;
            this.swipeLayout.setRefreshHeight((int)refresh.getDomObject().getLayoutHeight());
            String colorStr = (String)refresh.getDomObject().getStyles().get("backgroundColor");
            String bgColor = WXUtils.getString(colorStr, null);
            if (bgColor != null && !TextUtils.isEmpty((CharSequence)bgColor) && (colorInt = WXResourceUtils.getColor(bgColor)) != 0) {
                this.swipeLayout.setRefreshBgColor(colorInt);
            }
            this.swipeLayout.getHeaderView().setRefreshView((View)refresh.getHostView());
        }
    }

    public void setFooterView(WXComponent loading) {
        this.setLoadmoreEnable(true);
        if (this.swipeLayout != null && this.swipeLayout.getFooterView() != null) {
            int colorInt;
            this.swipeLayout.setLoadingHeight((int)loading.getDomObject().getLayoutHeight());
            String colorStr = (String)loading.getDomObject().getStyles().get("backgroundColor");
            String bgColor = WXUtils.getString(colorStr, null);
            if (bgColor != null && !TextUtils.isEmpty((CharSequence)bgColor) && (colorInt = WXResourceUtils.getColor(bgColor)) != 0) {
                this.swipeLayout.setLoadingBgColor(colorInt);
            }
            this.swipeLayout.getFooterView().setRefreshView((View)loading.getHostView());
        }
    }

    public void removeFooterView(WXComponent loading) {
        this.setLoadmoreEnable(false);
        if (this.swipeLayout != null && this.swipeLayout.getFooterView() != null) {
            this.swipeLayout.setLoadingHeight(0);
            this.swipeLayout.getFooterView().removeView((View)loading.getHostView());
            this.swipeLayout.finishPullLoad();
        }
    }

    public void removeHeaderView(WXComponent refresh) {
        this.setRefreshEnable(false);
        if (this.swipeLayout != null && this.swipeLayout.getHeaderView() != null) {
            this.swipeLayout.setRefreshHeight(0);
            this.swipeLayout.getHeaderView().removeView((View)refresh.getHostView());
            this.swipeLayout.finishPullRefresh();
        }
    }

    public void setRefreshEnable(boolean enable) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setPullRefreshEnable(enable);
        }
    }

    public void setLoadmoreEnable(boolean enable) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setPullLoadEnable(enable);
        }
    }

    public void removeView(View view) {
        if (view instanceof WXLoadingLayout) {
            this.finishPullLoad();
            this.setLoadmoreEnable(false);
            if (this.swipeLayout != null) {
                this.swipeLayout.removeView((View)this.swipeLayout.getFooterView());
            }
        } else if (view instanceof WXRefreshLayout) {
            this.finishPullRefresh();
            this.setRefreshEnable(false);
            if (this.swipeLayout != null) {
                this.swipeLayout.removeView((View)this.swipeLayout.getHeaderView());
            }
        } else {
            super.removeView(view);
        }
    }

    public WXSwipeLayout getSwipeLayout() {
        return this.swipeLayout;
    }

    public abstract void onRefreshingComplete();

    public abstract void onLoadmoreComplete();
}

