/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.gesture;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WXGesture
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private static final String TAG = "Gesture";
    private static final int CUR_EVENT = -1;
    public static final String START = "start";
    public static final String MOVE = "move";
    public static final String END = "end";
    public static final String UNKNOWN = "unknown";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String UP = "up";
    public static final String DOWN = "down";
    private WXComponent component;
    private GestureDetector mGestureDetector;
    private Rect globalRect;
    private Point globalOffset;
    private Point globalEventOffset;
    private PointF locEventOffset;
    private PointF locLeftTop;
    private long swipeDownTime = -1L;
    private long panDownTime = -1L;
    private WXGestureType mPendingPan = null;

    public WXGesture(WXComponent wxComponent, Context context) {
        this.component = wxComponent;
        this.globalRect = new Rect();
        this.globalOffset = new Point();
        this.globalEventOffset = new Point();
        this.locEventOffset = new PointF();
        this.locLeftTop = new PointF();
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this, (Handler)new GestureHandler());
    }

    public boolean onTouch(View v, MotionEvent event) {
        try {
            boolean result = this.mGestureDetector.onTouchEvent(event);
            switch (event.getActionMasked()) {
                case 0: 
                case 5: {
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_DOWN, event);
                    break;
                }
                case 2: {
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_MOVE, event);
                    break;
                }
                case 1: 
                case 6: {
                    this.finishDisallowInterceptTouchEvent(v);
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_UP, event);
                    result |= this.handlePanMotionEvent(event);
                    break;
                }
                case 3: {
                    this.finishDisallowInterceptTouchEvent(v);
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_CANCEL, event);
                    result |= this.handlePanMotionEvent(event);
                }
            }
            return result;
        }
        catch (Exception e) {
            WXLogUtils.e("Gesture RunTime Error ", e);
            return false;
        }
    }

    private String getPanEventAction(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                return START;
            }
            case 2: {
                return MOVE;
            }
            case 1: {
                return END;
            }
            case 3: {
                return END;
            }
        }
        return UNKNOWN;
    }

    private void finishDisallowInterceptTouchEvent(View v) {
        if (v.getParent() != null) {
            v.getParent().requestDisallowInterceptTouchEvent(false);
        }
    }

    private boolean handlePanMotionEvent(MotionEvent motionEvent) {
        if (this.mPendingPan == null) {
            return false;
        }
        String state = null;
        if (this.mPendingPan == WXGestureType.HighLevelGesture.HORIZONTALPAN || this.mPendingPan == WXGestureType.HighLevelGesture.VERTICALPAN) {
            state = this.getPanEventAction(motionEvent);
        }
        if (this.component.containsGesture(this.mPendingPan)) {
            List<Map<String, Object>> list = this.createMultipleFireEventParam(motionEvent, state);
            for (Map<String, Object> map : list) {
                this.component.fireEvent(this.mPendingPan.toString(), map);
            }
            if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
                this.mPendingPan = null;
            }
            return true;
        }
        return false;
    }

    private boolean handleMotionEvent(WXGestureType WXGestureType2, MotionEvent motionEvent) {
        if (this.component.containsGesture(WXGestureType2)) {
            List<Map<String, Object>> list = this.createMultipleFireEventParam(motionEvent, null);
            for (Map<String, Object> map : list) {
                this.component.fireEvent(WXGestureType2.toString(), map);
            }
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> createMultipleFireEventParam(MotionEvent motionEvent, String state) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(motionEvent.getHistorySize() + 1);
        list.addAll(this.getHistoricalEvents(motionEvent));
        list.add(this.createFireEventParam(motionEvent, -1, state));
        return list;
    }

    private List<Map<String, Object>> getHistoricalEvents(MotionEvent motionEvent) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(motionEvent.getHistorySize());
        if (motionEvent.getActionMasked() == 2) {
            for (int i = 0; i < motionEvent.getHistorySize(); ++i) {
                Map<String, Object> param = this.createFireEventParam(motionEvent, i, null);
                list.add(param);
            }
        }
        return list;
    }

    private Map<String, Object> createFireEventParam(MotionEvent motionEvent, int pos, String state) {
        JSONArray jsonArray = new JSONArray(motionEvent.getPointerCount());
        if (motionEvent.getActionMasked() == 2) {
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                jsonArray.add((Object)this.createJSONObject(motionEvent, pos, i));
            }
        } else if (this.isPointerNumChanged(motionEvent)) {
            int pointerIndex = motionEvent.getActionIndex();
            jsonArray.add((Object)this.createJSONObject(motionEvent, -1, pointerIndex));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changedTouches", jsonArray);
        if (state != null) {
            map.put("state", state);
        }
        return map;
    }

    private boolean isPointerNumChanged(MotionEvent event) {
        return event.getActionMasked() == 0 || event.getActionMasked() == 5 || event.getActionMasked() == 1 || event.getActionMasked() == 6 || event.getActionMasked() == 3;
    }

    private boolean containsSimplePan() {
        return this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_START) || this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_MOVE) || this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_END);
    }

    private JSONObject createJSONObject(MotionEvent motionEvent, int pos, int pointerIndex) {
        PointF screenXY;
        PointF pageXY;
        if (pos == -1) {
            pageXY = this.getEventLocInPageCoordinate(motionEvent, pointerIndex);
            screenXY = this.getEventLocInScreenCoordinate(motionEvent, pointerIndex);
        } else {
            pageXY = this.getEventLocInPageCoordinate(motionEvent, pointerIndex, pos);
            screenXY = this.getEventLocInScreenCoordinate(motionEvent, pointerIndex, pos);
        }
        return this.createJSONObject(screenXY, pageXY, (float)motionEvent.getPointerId(pointerIndex));
    }

    @NonNull
    private JSONObject createJSONObject(PointF screenXY, PointF pageXY, float pointerId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pageX", (Object)Float.valueOf(pageXY.x));
        jsonObject.put("pageY", (Object)Float.valueOf(pageXY.y));
        jsonObject.put("screenX", (Object)Float.valueOf(screenXY.x));
        jsonObject.put("screenY", (Object)Float.valueOf(screenXY.y));
        jsonObject.put("identifier", (Object)Float.valueOf(pointerId));
        return jsonObject;
    }

    private PointF getEventLocInScreenCoordinate(MotionEvent motionEvent, int pointerIndex) {
        return this.getEventLocInScreenCoordinate(motionEvent, pointerIndex, -1);
    }

    private PointF getEventLocInScreenCoordinate(MotionEvent motionEvent, int pointerIndex, int position) {
        float eventY;
        float eventX;
        if (position == -1) {
            eventX = motionEvent.getX(pointerIndex);
            eventY = motionEvent.getY(pointerIndex);
        } else {
            eventX = motionEvent.getHistoricalX(pointerIndex, position);
            eventY = motionEvent.getHistoricalY(pointerIndex, position);
        }
        return this.getEventLocInScreenCoordinate(eventX, eventY);
    }

    @NonNull
    private PointF getEventLocInScreenCoordinate(float eventX, float eventY) {
        this.globalRect.set(0, 0, 0, 0);
        this.globalOffset.set(0, 0);
        this.globalEventOffset.set((int)eventX, (int)eventY);
        this.component.getRealView().getGlobalVisibleRect(this.globalRect, this.globalOffset);
        this.globalEventOffset.offset(this.globalOffset.x, this.globalOffset.y);
        return new PointF(WXViewUtils.getWebPxByWidth(this.globalEventOffset.x, this.component.getInstance().getViewPortWidth()), WXViewUtils.getWebPxByWidth(this.globalEventOffset.y, this.component.getInstance().getViewPortWidth()));
    }

    private PointF getEventLocInPageCoordinate(MotionEvent motionEvent, int pointerIndex) {
        return this.getEventLocInPageCoordinate(motionEvent, pointerIndex, -1);
    }

    private PointF getEventLocInPageCoordinate(MotionEvent motionEvent, int pointerIndex, int position) {
        float eventY;
        float eventX;
        if (position == -1) {
            eventX = motionEvent.getX(pointerIndex);
            eventY = motionEvent.getY(pointerIndex);
        } else {
            eventX = motionEvent.getHistoricalX(pointerIndex, position);
            eventY = motionEvent.getHistoricalY(pointerIndex, position);
        }
        return this.getEventLocInPageCoordinate(eventX, eventY);
    }

    @NonNull
    private PointF getEventLocInPageCoordinate(float eventX, float eventY) {
        this.locEventOffset.set(eventX, eventY);
        this.locLeftTop.set(0.0f, 0.0f);
        this.component.computeVisiblePointInViewCoordinate(this.locLeftTop);
        this.locEventOffset.offset(this.locLeftTop.x, this.locLeftTop.y);
        return new PointF(WXViewUtils.getWebPxByWidth(this.locEventOffset.x, this.component.getInstance().getViewPortWidth()), WXViewUtils.getWebPxByWidth(this.locEventOffset.y, this.component.getInstance().getViewPortWidth()));
    }

    public void onLongPress(MotionEvent e) {
        if (this.component.containsGesture(WXGestureType.HighLevelGesture.LONG_PRESS)) {
            List<Map<String, Object>> list = this.createMultipleFireEventParam(e, null);
            this.component.getInstance().fireEvent(this.component.getDomObject().getRef(), WXGestureType.HighLevelGesture.LONG_PRESS.toString(), list.get(list.size() - 1));
        }
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float dy;
        boolean result = false;
        if (e1 == null || e2 == null) {
            return false;
        }
        float dx = Math.abs(e2.getX() - e1.getX());
        WXGestureType.HighLevelGesture possiblePan = dx > (dy = Math.abs(e2.getY() - e1.getY())) ? WXGestureType.HighLevelGesture.HORIZONTALPAN : WXGestureType.HighLevelGesture.VERTICALPAN;
        if (this.mPendingPan == WXGestureType.HighLevelGesture.HORIZONTALPAN || this.mPendingPan == WXGestureType.HighLevelGesture.VERTICALPAN) {
            this.handlePanMotionEvent(e2);
            result = true;
        } else if (this.component.containsGesture(possiblePan)) {
            ViewParent p = this.component.getRealView().getParent();
            if (p != null) {
                p.requestDisallowInterceptTouchEvent(true);
            }
            if (this.mPendingPan != null) {
                this.handleMotionEvent(this.mPendingPan, e2);
            }
            this.mPendingPan = possiblePan;
            this.component.fireEvent(((Object)possiblePan).toString(), this.createFireEventParam(e2, -1, START));
            result = true;
        } else if (this.containsSimplePan()) {
            if (this.panDownTime != e1.getEventTime()) {
                this.panDownTime = e1.getEventTime();
                this.mPendingPan = WXGestureType.HighLevelGesture.PAN_END;
                this.component.fireEvent(WXGestureType.HighLevelGesture.PAN_START.toString(), this.createFireEventParam(e1, -1, null));
            } else {
                this.component.fireEvent(WXGestureType.HighLevelGesture.PAN_MOVE.toString(), this.createFireEventParam(e2, -1, null));
            }
            result = true;
        } else if (this.component.containsGesture(WXGestureType.HighLevelGesture.SWIPE) && this.swipeDownTime != e1.getEventTime()) {
            this.swipeDownTime = e1.getEventTime();
            List<Map<String, Object>> list = this.createMultipleFireEventParam(e2, null);
            Map<String, Object> param = list.get(list.size() - 1);
            if (Math.abs(distanceX) > Math.abs(distanceY)) {
                param.put("direction", distanceX > 0.0f ? LEFT : RIGHT);
            } else {
                param.put("direction", distanceY > 0.0f ? UP : DOWN);
            }
            this.component.getInstance().fireEvent(this.component.getDomObject().getRef(), WXGestureType.HighLevelGesture.SWIPE.toString(), param);
            result = true;
        }
        return result;
    }

    public boolean onDown(MotionEvent e) {
        return true;
    }

    private static class GestureHandler
    extends Handler {
        public GestureHandler() {
            super(Looper.getMainLooper());
        }
    }
}

