/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.ImageDrawable;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public class WXImageView
extends ImageView
implements WXGestureObservable,
IRenderStatus<WXImage> {
    private WeakReference<WXImage> mWeakReference;
    private WXGesture wxGesture;
    private float[] borderRadius;
    private boolean gif;

    public WXImageView(Context context) {
        super(context);
    }

    public void setImageResource(int resId) {
        Drawable drawable2 = this.getResources().getDrawable(resId);
        this.setImageDrawable(drawable2);
    }

    public void setImageDrawable(@Nullable Drawable drawable2, boolean isGif) {
        this.gif = isGif;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            WXImage component;
            ImageDrawable imageDrawable;
            Drawable wrapDrawable = ImageDrawable.createImageDrawable(drawable2, this.getScaleType(), this.borderRadius, layoutParams.width - this.getPaddingLeft() - this.getPaddingRight(), layoutParams.height - this.getPaddingTop() - this.getPaddingBottom(), isGif);
            if (wrapDrawable instanceof ImageDrawable && !Arrays.equals((imageDrawable = (ImageDrawable)wrapDrawable).getCornerRadii(), this.borderRadius)) {
                imageDrawable.setCornerRadii(this.borderRadius);
            }
            super.setImageDrawable(wrapDrawable);
            if (this.mWeakReference != null && (component = (WXImage)this.mWeakReference.get()) != null) {
                component.readyToRender();
            }
        }
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        this.setImageDrawable(drawable2, false);
    }

    public void setImageBitmap(@Nullable Bitmap bm) {
        this.setImageDrawable((Drawable)(bm == null ? null : new BitmapDrawable(this.getResources(), bm)));
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    public void setBorderRadius(@NonNull float[] borderRadius) {
        this.borderRadius = borderRadius;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.setImageDrawable(this.getDrawable(), this.gif);
        }
    }

    @Override
    public void holdComponent(WXImage component) {
        this.mWeakReference = new WeakReference<WXImage>(component);
    }
}

