/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class WXSliderNeighbor
extends WXSlider {
    public static final String NEIGHBOR_SCALE = "neighborScale";
    public static final String NEIGHBOR_ALPHA = "neighborAlpha";
    public static final String NEIGHBOR_SPACE = "neighborSpace";
    private static final int DEFAULT_NEIGHBOR_SPACE = 25;
    private static final float DEFAULT_NEIGHBOR_SCALE = 0.8f;
    private static final float DEFAULT_NEIGHBOR_ALPHA = 0.6f;
    private float mNeighborScale = 0.8f;
    private float mNeighborAlpha = 0.6f;
    private float mNeighborSpace = 25.0f;
    private static final float WX_DEFAULT_MAIN_NEIGHBOR_SCALE = 0.9f;
    private ZoomTransformer mCachedTransformer;

    public WXSliderNeighbor(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    public void bindData(WXComponent component) {
        super.bindData(component);
        if (this.mAdapter.getRealCount() > 3) {
            this.mViewPager.setOffscreenPageLimit(2);
        } else if (this.mAdapter.getRealCount() == 3) {
            this.mViewPager.setOffscreenPageLimit(1);
        }
    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        FrameLayout view = new FrameLayout(context);
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        pagerParams.gravity = 17;
        this.mViewPager = new WXCircleViewPager(this.getContext());
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter();
        this.mViewPager.setAdapter(this.mAdapter);
        view.addView((View)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        this.mViewPager.setOverScrollMode(2);
        this.registerActivityStateListener();
        return view;
    }

    private int getNeighborChildrenCount() {
        try {
            WXDomManager domManager = WXSDKManager.getInstance().getWXDomManager();
            Field domRegistriesField = domManager.getClass().getDeclaredField("mDomRegistries");
            domRegistriesField.setAccessible(true);
            ConcurrentHashMap domRegistriesMap = (ConcurrentHashMap)domRegistriesField.get(domManager);
            Object domStatement = domRegistriesMap.get(this.getInstanceId());
            Field mRegistryField = domStatement.getClass().getDeclaredField("mRegistry");
            mRegistryField.setAccessible(true);
            ConcurrentHashMap mRegistryMap = (ConcurrentHashMap)mRegistryField.get(domStatement);
            for (WXDomObject domObject : mRegistryMap.values()) {
                if (!domObject.getType().equalsIgnoreCase("slider-neighbor")) continue;
                int sum = 0;
                int count = domObject.getChildCount();
                for (int i = 0; i < count; ++i) {
                    if (domObject.getChild(i) instanceof WXIndicator.IndicatorDomNode) continue;
                    ++sum;
                }
                return sum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    ZoomTransformer createTransformer() {
        if (this.mCachedTransformer == null) {
            this.mCachedTransformer = new ZoomTransformer();
        }
        return this.mCachedTransformer;
    }

    @Override
    protected void addSubView(View view, int index) {
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        FrameLayout wrapper = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        wrapper.addView(view);
        super.addSubView((View)wrapper, index);
        this.updateAdapterScaleAndAlpha(this.mNeighborAlpha, this.mNeighborScale);
        view.postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                int childCountByDomTree = WXSliderNeighbor.this.getNeighborChildrenCount();
                if (WXSliderNeighbor.this.mAdapter.getRealCount() == childCountByDomTree || childCountByDomTree == -1) {
                    WXSliderNeighbor.this.mViewPager.setPageTransformer(false, WXSliderNeighbor.this.createTransformer());
                }
            }
        }), 100L);
    }

    private void updateScaleAndAlpha(View view, float alpha, float scale) {
        if (null == view) {
            return;
        }
        if (alpha >= 0.0f && view.getAlpha() != alpha) {
            view.setAlpha(alpha);
        }
        if (scale >= 0.0f && view.getScaleX() != scale) {
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private void updateAdapterScaleAndAlpha(final float alpha, final float scale) {
        List<View> pageViews = this.mAdapter.getViews();
        int curPos = this.mViewPager.getCurrentItem();
        if (pageViews.size() > 0) {
            final View currentPage = pageViews.get(curPos);
            this.updateScaleAndAlpha(((ViewGroup)currentPage).getChildAt(0), 1.0f, 0.9f);
            if (pageViews.size() < 2) {
                return;
            }
            currentPage.post(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    WXSliderNeighbor.this.updateNeighbor(currentPage, alpha, scale);
                }
            }));
            int left = curPos == 0 ? pageViews.size() - 1 : curPos - 1;
            int right = curPos == pageViews.size() - 1 ? 0 : curPos + 1;
            for (int i = 0; i < this.mAdapter.getRealCount(); ++i) {
                if (i == left || i == curPos || i == right) continue;
                ((ViewGroup)pageViews.get(i)).getChildAt(0).setAlpha(0.0f);
            }
        }
    }

    private void updateNeighbor(View currentPage, float alpha, float scale) {
        List<View> pageViews = this.mAdapter.getViews();
        int curPos = this.mViewPager.getCurrentItem();
        float translation = this.calculateTranslation(currentPage);
        int left = curPos == 0 ? pageViews.size() - 1 : curPos - 1;
        View leftPage = pageViews.get(left);
        int right = curPos == pageViews.size() - 1 ? 0 : curPos + 1;
        View rightPage = pageViews.get(right);
        if (pageViews.size() == 2) {
            if (curPos == 0) {
                this.moveRight(rightPage, translation, alpha, scale);
            } else if (curPos == 1) {
                this.moveLeft(leftPage, translation, alpha, scale);
            }
        } else {
            this.moveLeft(leftPage, translation, alpha, scale);
            this.moveRight(rightPage, translation, alpha, scale);
        }
    }

    private void moveLeft(View page, float translation, float alpha, float scale) {
        this.updateScaleAndAlpha(((ViewGroup)page).getChildAt(0), alpha, scale);
        page.setTranslationX(translation);
        ((ViewGroup)page).getChildAt(0).setTranslationX(translation);
    }

    private void moveRight(View page, float translation, float alpha, float scale) {
        this.moveLeft(page, -translation, alpha, scale);
    }

    @WXComponentProp(name="neighborScale")
    public void setNeighborScale(String input) {
        float neighborScale = 0.8f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborScale = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNeighborScale != neighborScale) {
            this.mNeighborScale = neighborScale;
            this.updateAdapterScaleAndAlpha(-1.0f, neighborScale);
        }
    }

    @WXComponentProp(name="neighborAlpha")
    public void setNeighborAlpha(String input) {
        float neighborAlpha = 0.6f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborAlpha = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNeighborAlpha != neighborAlpha) {
            this.mNeighborAlpha = neighborAlpha;
            this.updateAdapterScaleAndAlpha(neighborAlpha, -1.0f);
        }
    }

    @WXComponentProp(name="neighborSpace")
    public void setNeighborSpace(String input) {
        float neighborSpace = 25.0f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborSpace = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNeighborSpace != neighborSpace) {
            this.mNeighborSpace = neighborSpace;
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "neighborScale": {
                String input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborScale(input);
                }
                return true;
            }
            case "neighborAlpha": {
                String input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborAlpha(input);
                }
                return true;
            }
            case "neighborSpace": {
                String input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborSpace(input);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    private float calculateTranslation(@NonNull View hostPage) {
        if (!(hostPage instanceof ViewGroup)) {
            return 0.0f;
        }
        View realView = ((ViewGroup)hostPage).getChildAt(0);
        float translation = ((float)hostPage.getMeasuredWidth() - (float)realView.getMeasuredWidth() * this.mNeighborScale) / 4.0f;
        return translation += (((float)hostPage.getMeasuredWidth() - (float)realView.getMeasuredWidth() * 0.9f) / 2.0f - WXViewUtils.getRealPxByWidth(this.mNeighborSpace)) / 2.0f;
    }

    class ZoomTransformer
    implements ViewPager.PageTransformer {
        ZoomTransformer() {
        }

        public void transformPage(View page, float position) {
            int pagePosition = WXSliderNeighbor.this.mAdapter.getPagePosition(page);
            int curPosition = WXSliderNeighbor.this.mViewPager.getCurrentItem();
            boolean ignore = false;
            if (curPosition != 0 && curPosition != WXSliderNeighbor.this.mAdapter.getRealCount() - 1 && Math.abs(pagePosition - curPosition) > 1) {
                ignore = true;
            }
            if (curPosition == 0 && pagePosition < WXSliderNeighbor.this.mAdapter.getRealCount() - 1 && pagePosition > 1) {
                ignore = true;
            }
            if (curPosition == WXSliderNeighbor.this.mAdapter.getRealCount() - 1 && pagePosition < WXSliderNeighbor.this.mAdapter.getRealCount() - 2 && pagePosition > 0) {
                ignore = true;
            }
            if (ignore) {
                return;
            }
            View realView = ((ViewGroup)page).getChildAt(0);
            if (realView == null) {
                return;
            }
            if (position <= (float)(-WXSliderNeighbor.this.mAdapter.getRealCount() + 1)) {
                position += (float)WXSliderNeighbor.this.mAdapter.getRealCount();
            }
            if (position >= (float)(WXSliderNeighbor.this.mAdapter.getRealCount() - 1)) {
                position -= (float)WXSliderNeighbor.this.mAdapter.getRealCount();
            }
            if (position >= -1.0f && position <= 1.0f) {
                float factor = Math.abs(Math.abs(position) - 1.0f);
                float scale = WXSliderNeighbor.this.mNeighborScale + factor * (0.9f - WXSliderNeighbor.this.mNeighborScale);
                float alpha = (1.0f - WXSliderNeighbor.this.mNeighborAlpha) * factor + WXSliderNeighbor.this.mNeighborAlpha;
                float translation = WXSliderNeighbor.this.calculateTranslation(page);
                if (position > 0.0f) {
                    translation = position * translation;
                    realView.setTranslationX(-translation);
                    page.setTranslationX(-translation);
                } else if (position == 0.0f) {
                    page.setTranslationX(0.0f);
                    realView.setTranslationX(0.0f);
                    WXSliderNeighbor.this.updateAdapterScaleAndAlpha(WXSliderNeighbor.this.mNeighborAlpha, WXSliderNeighbor.this.mNeighborScale);
                } else {
                    if (WXSliderNeighbor.this.mAdapter.getRealCount() == 2 && Math.abs(position) == 1.0f) {
                        return;
                    }
                    translation = -position * translation;
                    realView.setTranslationX(translation);
                    page.setTranslationX(translation);
                }
                realView.setAlpha(alpha);
                realView.setScaleX(scale);
                realView.setScaleY(scale);
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXSliderNeighbor(instance, node, parent);
        }
    }
}

