/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.ImageView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.ImageDrawable;
import com.taobao.weex.utils.ImgURIUtil;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXImage
extends WXComponent<ImageView> {
    @Deprecated
    public WXImage(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXImage(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    protected ImageView initComponentHostView(@NonNull Context context) {
        WXImageView view = new WXImageView(context);
        view.setScaleType(ImageView.ScaleType.FIT_XY);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setCropToPadding(true);
        }
        view.holdComponent(this);
        return view;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "resizeMode": {
                String resize_mode = WXUtils.getString(param, null);
                if (resize_mode != null) {
                    this.setResizeMode(resize_mode);
                }
                return true;
            }
            case "resize": {
                String resize = WXUtils.getString(param, null);
                if (resize != null) {
                    this.setResize(resize);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "imageQuality": {
                return true;
            }
            case "filter": {
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    public void refreshData(WXComponent component) {
        super.refreshData(component);
        if (component instanceof WXImage) {
            this.setSrc(component.getDomObject().getAttrs().getImageSrc());
        }
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resizeMode));
    }

    private ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        switch (resizeMode) {
            case "cover": {
                scaleType = ImageView.ScaleType.CENTER_CROP;
                break;
            }
            case "contain": {
                scaleType = ImageView.ScaleType.FIT_CENTER;
                break;
            }
            case "stretch": {
                scaleType = ImageView.ScaleType.FIT_XY;
            }
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resize));
    }

    private void setLocalSrc(Uri rewrited) {
        ImageView imageView;
        Drawable localDrawable = ImgURIUtil.getDrawableFromLoaclSrc(this.getContext(), rewrited);
        if (localDrawable != null && (imageView = (ImageView)this.getHostView()) != null) {
            imageView.setImageDrawable(localDrawable);
        }
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (src == null) {
            return;
        }
        WXSDKInstance instance = this.getInstance();
        Uri rewrited = instance.rewriteUri(Uri.parse((String)src), "image");
        if ("local".equals(rewrited.getScheme())) {
            this.setLocalSrc(rewrited);
        } else {
            this.setRemoteSrc(rewrited);
        }
    }

    private void setRemoteSrc(Uri rewrited) {
        IWXImgLoaderAdapter imgLoaderAdapter;
        String attr;
        WXImageStrategy imageStrategy = new WXImageStrategy();
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.getDomObject().getAttrs().getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        int radius = this.getDomObject().getStyles().getBlur();
        radius = Math.max(0, radius);
        imageStrategy.blurRadius = Math.min(10, radius);
        imageStrategy.setImageListener(new WXImageStrategy.ImageListener(){

            @Override
            public void onImageFinish(String url, ImageView imageView, boolean result, Map extra) {
                if (WXImage.this.getDomObject() != null && WXImage.this.getDomObject().getEvents().contains("load")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    HashMap<String, Integer> size = new HashMap<String, Integer>(2);
                    if (imageView != null && imageView.getDrawable() != null && imageView.getDrawable() instanceof ImageDrawable) {
                        size.put("naturalWidth", ((ImageDrawable)imageView.getDrawable()).getBitmapWidth());
                        size.put("naturalHeight", ((ImageDrawable)imageView.getDrawable()).getBitmapHeight());
                    } else {
                        size.put("naturalWidth", 0);
                        size.put("naturalHeight", 0);
                    }
                    if (WXImage.this.getDomObject() != null && WXImage.this.containsEvent("load")) {
                        params.put("success", result);
                        params.put("size", size);
                        WXImage.this.fireEvent("load", params);
                    }
                }
            }
        });
        WXSDKInstance instance = this.getInstance();
        if (this.getDomObject().getAttrs().containsKey("placeHolder") && TextUtils.isEmpty((CharSequence)(attr = (String)this.getDomObject().getAttrs().get("placeHolder")))) {
            imageStrategy.placeHolder = instance.rewriteUri(Uri.parse((String)attr), "image").toString();
        }
        if ((imgLoaderAdapter = this.getInstance().getImgLoaderAdapter()) != null) {
            imgLoaderAdapter.setImage(rewrited.toString(), (ImageView)this.getHostView(), this.getDomObject().getAttrs().getImageQuality(), imageStrategy);
        }
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        ImmutableDomObject imageDom = this.getDomObject();
        if (imageDom != null && this.getHostView() instanceof WXImageView) {
            ImageDrawable imageDrawable;
            float[] previousRadius;
            float[] borderRadius;
            WXImageView imageView = (WXImageView)this.getHostView();
            BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(this.getHostView());
            if (borderDrawable != null) {
                RectF borderBox = new RectF(0.0f, 0.0f, WXDomUtils.getContentWidth(imageDom), WXDomUtils.getContentHeight(imageDom));
                borderRadius = borderDrawable.getBorderRadius(borderBox);
            } else {
                borderRadius = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            }
            imageView.setBorderRadius(borderRadius);
            if (imageView.getDrawable() instanceof ImageDrawable && !Arrays.equals(previousRadius = (imageDrawable = (ImageDrawable)imageView.getDrawable()).getCornerRadii(), borderRadius)) {
                imageDrawable.setCornerRadii(borderRadius);
            }
            this.readyToRender();
        }
    }

    public static class Ceator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXImage(instance, node, parent);
        }
    }
}

