/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ScrollView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.Map;

class WXRenderStatement {
    private Map<String, WXComponent> mRegistry;
    private WXSDKInstance mWXSDKInstance;

    public WXRenderStatement(WXSDKInstance instance) {
        this.mWXSDKInstance = instance;
        this.mRegistry = new HashMap<String, WXComponent>();
    }

    public void destroy() {
        this.mWXSDKInstance = null;
        this.mRegistry.clear();
    }

    public WXSDKInstance getWXSDKInstance() {
        return this.mWXSDKInstance;
    }

    void createBody(WXComponent component) {
        WXScroller scroller;
        long start = System.currentTimeMillis();
        component.createView();
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.renderPerformanceLog("createView", System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        component.applyLayoutAndEvent(component);
        component.bindData(component);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.renderPerformanceLog("bind", System.currentTimeMillis() - start);
        }
        if (component instanceof WXScroller && (scroller = (WXScroller)component).getInnerView() instanceof ScrollView) {
            this.mWXSDKInstance.setRootScrollView((ScrollView)scroller.getInnerView());
        }
        this.mWXSDKInstance.onRootCreated(component);
        if (this.mWXSDKInstance.getRenderStrategy() != WXRenderStrategy.APPEND_ONCE) {
            this.mWXSDKInstance.onCreateFinish();
        }
    }

    WXComponent createBodyOnDomThread(WXDomObject dom) {
        if (this.mWXSDKInstance == null) {
            return null;
        }
        WXComponent rootComp = this.generateComponentTree(dom, null);
        return rootComp;
    }

    void setPadding(String ref, Spacing padding, Spacing border) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.setPadding(padding, border);
    }

    void setLayout(String ref, WXDomObject domObject) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.setLayout(domObject);
    }

    void setExtra(String ref, Object extra) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateExtra(extra);
    }

    void addComponent(WXDomObject dom, String parentRef, int index) {
        WXVContainer parent = (WXVContainer)this.mRegistry.get(parentRef);
        WXComponent component = this.generateComponentTree(dom, parent);
        parent.addChild(component, index);
    }

    @Nullable
    WXComponent createComponentOnDomThread(WXDomObject dom, String parentRef, int index) {
        WXComponent comp = this.mRegistry.get(parentRef);
        if (comp == null || !(comp instanceof WXVContainer)) {
            return null;
        }
        return this.generateComponentTree(dom, (WXVContainer)comp);
    }

    void addComponent(WXComponent component, String parentRef, int index) {
        WXVContainer parent = (WXVContainer)this.mRegistry.get(parentRef);
        if (parent == null || component == null) {
            return;
        }
        parent.addChild(component, index);
        parent.createChildViewAt(index);
        component.applyLayoutAndEvent(component);
        component.bindData(component);
    }

    WXComponent removeComponent(String ref) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null || component.getParent() == null) {
            return component;
        }
        WXVContainer parent = component.getParent();
        this.clearRegistryForComponent(component);
        parent.remove(component, true);
        this.mRegistry.remove(ref);
        return component;
    }

    public WXComponent getComponent(String ref) {
        return this.mRegistry.get(ref);
    }

    private void clearRegistryForComponent(WXComponent component) {
        WXComponent removedComponent = this.mRegistry.remove(component.getDomObject().getRef());
        if (removedComponent != null) {
            removedComponent.removeAllEvent();
            removedComponent.removeStickyStyle();
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = count - 1; i >= 0; --i) {
                this.clearRegistryForComponent(container.getChild(i));
            }
        }
    }

    void move(String ref, String parentRef, int index) {
        WXComponent component = this.mRegistry.get(ref);
        WXComponent newParent = this.mRegistry.get(parentRef);
        if (component == null || component.getParent() == null || newParent == null || !(newParent instanceof WXVContainer)) {
            return;
        }
        WXVContainer oldParent = component.getParent();
        oldParent.remove(component, false);
        ((WXVContainer)newParent).addChild(component, index);
    }

    void addEvent(String ref, String type) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.addEvent(type);
    }

    void removeEvent(String ref, String type) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.removeEvent(type);
    }

    void updateAttrs(String ref, Map<String, Object> attrs) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateProperties(attrs);
    }

    void updateStyle(String ref, Map<String, Object> style) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateProperties(style);
    }

    void scrollTo(String ref, Map<String, Object> options) {
        Scrollable scroller;
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        float offsetFloat = 0.0f;
        if (options != null) {
            String offset;
            String string2 = offset = options.get("offset") == null ? "0" : options.get("offset").toString();
            if (offset != null) {
                try {
                    offsetFloat = WXViewUtils.getRealPxByWidth(Float.parseFloat(offset), this.mWXSDKInstance.getViewPortWidth());
                }
                catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
        }
        if ((scroller = component.getParentScroller()) == null) {
            return;
        }
        scroller.scrollTo(component, (int)offsetFloat);
    }

    void createFinish(int width, int height) {
        if (this.mWXSDKInstance.getRenderStrategy() == WXRenderStrategy.APPEND_ONCE) {
            this.mWXSDKInstance.onCreateFinish();
        }
        this.mWXSDKInstance.onRenderSuccess(width, height);
    }

    void refreshFinish(int width, int height) {
        this.mWXSDKInstance.onRefreshSuccess(width, height);
    }

    void updateFinish() {
        this.mWXSDKInstance.onUpdateFinish();
    }

    private WXComponent generateComponentTree(WXDomObject dom, WXVContainer parent) {
        if (dom == null) {
            return null;
        }
        WXComponent component = WXComponentFactory.newInstance(this.mWXSDKInstance, dom, parent);
        this.mRegistry.put(dom.getRef(), component);
        if (component instanceof WXVContainer) {
            WXVContainer parentC = (WXVContainer)component;
            int count = dom.childCount();
            WXDomObject child = null;
            for (int i = 0; i < count; ++i) {
                child = dom.getChild(i);
                if (child == null) continue;
                parentC.addChild(this.generateComponentTree(child, parentC));
            }
        }
        return component;
    }

    void startAnimation(@NonNull String ref, @NonNull WXAnimationBean animationBean, @Nullable String callBack) {
        WXAnimationModule.startAnimation(this.mWXSDKInstance, this.mRegistry.get(ref), animationBean, callBack);
    }

    public void getComponentSize(String ref, JSCallback callback) {
        WXComponent component = this.mRegistry.get(ref);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (component != null) {
            HashMap<String, String> size = new HashMap<String, String>();
            Rect sizes = component.getComponentSize();
            size.put("width", String.valueOf(WXViewUtils.getWebPxByWidth(sizes.width(), this.mWXSDKInstance.getViewPortWidth())));
            size.put("height", String.valueOf(WXViewUtils.getWebPxByWidth(sizes.height(), this.mWXSDKInstance.getViewPortWidth())));
            size.put("bottom", String.valueOf(WXViewUtils.getWebPxByWidth(sizes.bottom, this.mWXSDKInstance.getViewPortWidth())));
            size.put("left", String.valueOf(WXViewUtils.getWebPxByWidth(sizes.left, this.mWXSDKInstance.getViewPortWidth())));
            size.put("right", String.valueOf(WXViewUtils.getWebPxByWidth(sizes.right, this.mWXSDKInstance.getViewPortWidth())));
            size.put("top", String.valueOf(WXViewUtils.getWebPxByWidth(sizes.top, this.mWXSDKInstance.getViewPortWidth())));
            options.put("size", size);
            options.put("result", true);
        } else {
            options.put("errMsg", "Component does not exist");
        }
        callback.invoke(options);
    }
}

