/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Handler;
import android.os.Message;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.dom.WXDomManager;
import com.taobao.weex.dom.WXDomTask;

public class WXDomHandler
implements Handler.Callback {
    private static final int DELAY_TIME = 16;
    private WXDomManager mWXDomManager;
    private boolean mHasBatch = false;

    public WXDomHandler(WXDomManager domManager) {
        this.mWXDomManager = domManager;
    }

    public boolean handleMessage(Message msg) {
        if (msg == null) {
            return false;
        }
        int what = msg.what;
        Object obj = msg.obj;
        WXDomTask task = null;
        if (obj instanceof WXDomTask) {
            task = (WXDomTask)obj;
        }
        if (!this.mHasBatch) {
            this.mHasBatch = true;
            this.mWXDomManager.sendEmptyMessageDelayed(255, 16L);
        }
        switch (what) {
            case 0: {
                this.mWXDomManager.createBody(task.instanceId, (JSONObject)task.args.get(0));
                break;
            }
            case 1: {
                this.mWXDomManager.updateAttrs(task.instanceId, (String)task.args.get(0), (JSONObject)task.args.get(1));
                break;
            }
            case 2: {
                this.mWXDomManager.updateStyle(task.instanceId, (String)task.args.get(0), (JSONObject)task.args.get(1), task.args.size() > 2 && (Boolean)task.args.get(2) != false);
                break;
            }
            case 3: {
                this.mWXDomManager.addDom(task.instanceId, (String)task.args.get(0), (JSONObject)task.args.get(1), (Integer)task.args.get(2));
                break;
            }
            case 4: {
                this.mWXDomManager.removeDom(task.instanceId, (String)task.args.get(0));
                break;
            }
            case 5: {
                this.mWXDomManager.moveDom(task.instanceId, (String)task.args.get(0), (String)task.args.get(1), (Integer)task.args.get(2));
                break;
            }
            case 6: {
                this.mWXDomManager.addEvent(task.instanceId, (String)task.args.get(0), (String)task.args.get(1));
                break;
            }
            case 7: {
                this.mWXDomManager.removeEvent(task.instanceId, (String)task.args.get(0), (String)task.args.get(1));
                break;
            }
            case 9: {
                this.mWXDomManager.createFinish(task.instanceId);
                break;
            }
            case 10: {
                this.mWXDomManager.refreshFinish(task.instanceId);
                break;
            }
            case 11: {
                this.mWXDomManager.updateFinish(task.instanceId);
                break;
            }
            case 12: {
                this.mWXDomManager.startAnimation(task.instanceId, (String)task.args.get(0), (String)task.args.get(1), (String)task.args.get(2));
                break;
            }
            case 255: {
                this.mWXDomManager.batch();
                this.mHasBatch = false;
                break;
            }
            case 8: {
                this.mWXDomManager.scrollToDom(task.instanceId, (String)task.args.get(0), (JSONObject)task.args.get(1));
                break;
            }
            case 13: {
                this.mWXDomManager.addRule(task.instanceId, (String)task.args.get(0), (JSONObject)task.args.get(1));
                break;
            }
            case 4081: {
                this.mWXDomManager.getComponentSize(task.instanceId, (String)task.args.get(0), (JSCallback)task.args.get(1));
                break;
            }
            case 14: {
                this.mWXDomManager.invokeMethod(task.instanceId, (String)task.args.get(0), (String)task.args.get(1), (JSONArray)task.args.get(2));
                break;
            }
        }
        return true;
    }

    public static class MsgType {
        public static final int WX_DOM_CREATE_BODY = 0;
        public static final int WX_DOM_UPDATE_ATTRS = 1;
        public static final int WX_DOM_UPDATE_STYLE = 2;
        public static final int WX_DOM_ADD_DOM = 3;
        public static final int WX_DOM_REMOVE_DOM = 4;
        public static final int WX_DOM_MOVE_DOM = 5;
        public static final int WX_DOM_ADD_EVENT = 6;
        public static final int WX_DOM_REMOVE_EVENT = 7;
        public static final int WX_DOM_SCROLLTO = 8;
        public static final int WX_DOM_CREATE_FINISH = 9;
        public static final int WX_DOM_REFRESH_FINISH = 10;
        public static final int WX_DOM_UPDATE_FINISH = 11;
        public static final int WX_ANIMATION = 12;
        public static final int WX_DOM_ADD_RULE = 13;
        public static final int WX_DOM_INVOKE = 14;
        public static final int WX_DOM_BATCH = 255;
        public static final int WX_COMPONENT_SIZE = 4081;
    }
}

