/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.InitConfig;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.DefaultUriAdapter;
import com.taobao.weex.adapter.DefaultWXHttpAdapter;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXDebugAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.storage.DefaultWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomManager;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WXSDKManager {
    private static volatile WXSDKManager sManager;
    private static AtomicInteger sInstanceId;
    private final WXDomManager mWXDomManager;
    private WXBridgeManager mBridgeManager;
    WXRenderManager mWXRenderManager = new WXRenderManager();
    private IWXUserTrackAdapter mIWXUserTrackAdapter;
    private IWXImgLoaderAdapter mIWXImgLoaderAdapter;
    private IDrawableLoader mDrawableLoader;
    private IWXHttpAdapter mIWXHttpAdapter;
    private IWXDebugAdapter mIWXDebugAdapter;
    private IActivityNavBarSetter mActivityNavBarSetter;
    private IWXStorageAdapter mIWXStorageAdapter;
    private URIAdapter mURIAdapter;
    private IWebSocketAdapterFactory mIWebSocketAdapterFactory;

    private WXSDKManager() {
        this.mWXDomManager = new WXDomManager(this.mWXRenderManager);
        this.mBridgeManager = WXBridgeManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXSDKManager getInstance() {
        if (sManager != null) return sManager;
        Class<WXSDKManager> clazz = WXSDKManager.class;
        synchronized (WXSDKManager.class) {
            if (sManager != null) return sManager;
            sManager = new WXSDKManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    public static int getInstanceViewPortWidth(String instanceId) {
        return WXSDKManager.getInstance().getSDKInstance(instanceId).getViewPortWidth();
    }

    static void setInstance(WXSDKManager manager) {
        sManager = manager;
    }

    public IActivityNavBarSetter getActivityNavBarSetter() {
        return this.mActivityNavBarSetter;
    }

    public void setActivityNavBarSetter(IActivityNavBarSetter mActivityNavBarSetter) {
        this.mActivityNavBarSetter = mActivityNavBarSetter;
    }

    public void restartBridge() {
        this.mBridgeManager.restart();
    }

    public WXDomManager getWXDomManager() {
        return this.mWXDomManager;
    }

    public WXBridgeManager getWXBridgeManager() {
        return this.mBridgeManager;
    }

    public WXRenderManager getWXRenderManager() {
        return this.mWXRenderManager;
    }

    public WXSDKInstance getSDKInstance(String instanceId) {
        return instanceId == null ? null : this.mWXRenderManager.getWXSDKInstance(instanceId);
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderManager.postOnUiThread(WXThread.secure(runnable), delayMillis);
    }

    public void destroy() {
        if (this.mWXDomManager != null) {
            this.mWXDomManager.destroy();
        }
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data) {
        this.mBridgeManager.callback(instanceId, funcId, data);
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data, boolean keepAlive) {
        this.mBridgeManager.callback(instanceId, funcId, data, keepAlive);
    }

    public void initScriptsFramework(String framework) {
        this.mBridgeManager.initScriptsFramework(framework);
    }

    public void registerComponents(List<Map<String, Object>> components) {
        this.mBridgeManager.registerComponents(components);
    }

    public void registerModules(Map<String, Object> modules) {
        this.mBridgeManager.registerModules(modules);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type) {
        this.fireEvent(instanceId, ref, type, new HashMap<String, Object>());
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params) {
        this.fireEvent(instanceId, ref, type, params, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params, Map<String, Object> domChanges) {
        if (WXEnvironment.isApkDebugable() && Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            throw new WXRuntimeException("[WXSDKManager]  fireEvent error");
        }
        this.mBridgeManager.fireEventOnNode(instanceId, ref, type, params, domChanges);
    }

    void createInstance(WXSDKInstance instance, String code, Map<String, Object> options, String jsonInitData) {
        this.mWXRenderManager.registerInstance(instance);
        this.mBridgeManager.createInstance(instance.getInstanceId(), code, options, jsonInitData);
    }

    void refreshInstance(String instanceId, WXRefreshData jsonData) {
        this.mBridgeManager.refreshInstance(instanceId, jsonData);
    }

    void destroyInstance(String instanceId) {
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXSDKManager] destroyInstance error");
        }
        this.mWXRenderManager.removeRenderStatement(instanceId);
        this.mWXDomManager.removeDomStatement(instanceId);
        this.mBridgeManager.destroyInstance(instanceId);
        WXModuleManager.destroyInstanceModules(instanceId);
    }

    String generateInstanceId() {
        return String.valueOf(sInstanceId.incrementAndGet());
    }

    public IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return this.mIWXUserTrackAdapter;
    }

    public IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return this.mIWXImgLoaderAdapter;
    }

    public IDrawableLoader getDrawableLoader() {
        return this.mDrawableLoader;
    }

    @NonNull
    public IWXHttpAdapter getIWXHttpAdapter() {
        if (this.mIWXHttpAdapter == null) {
            this.mIWXHttpAdapter = new DefaultWXHttpAdapter();
        }
        return this.mIWXHttpAdapter;
    }

    @NonNull
    public URIAdapter getURIAdapter() {
        if (this.mURIAdapter == null) {
            this.mURIAdapter = new DefaultUriAdapter();
        }
        return this.mURIAdapter;
    }

    void setInitConfig(InitConfig config) {
        this.mIWXDebugAdapter = config.getDebugAdapter();
        this.mIWXHttpAdapter = config.getHttpAdapter();
        this.mIWXImgLoaderAdapter = config.getImgAdapter();
        this.mDrawableLoader = config.getDrawableLoader();
        this.mIWXStorageAdapter = config.getStorageAdapter();
        this.mIWXUserTrackAdapter = config.getUtAdapter();
        this.mURIAdapter = config.getURIAdapter();
        this.mIWebSocketAdapterFactory = config.getWebSocketAdapterFactory();
    }

    public IWXDebugAdapter getIWXDebugAdapter() {
        return this.mIWXDebugAdapter;
    }

    public IWXStorageAdapter getIWXStorageAdapter() {
        if (this.mIWXStorageAdapter == null) {
            if (WXEnvironment.sApplication != null) {
                this.mIWXStorageAdapter = new DefaultWXStorage((Context)WXEnvironment.sApplication);
            } else {
                WXLogUtils.e("WXStorageModule", "No Application context found,you should call WXSDKEngine#initialize() method in your application");
            }
        }
        return this.mIWXStorageAdapter;
    }

    public void notifyTrimMemory() {
        this.mBridgeManager.notifyTrimMemory();
    }

    @Nullable
    public IWebSocketAdapter getIWXWebSocketAdapter() {
        if (this.mIWebSocketAdapterFactory != null) {
            return this.mIWebSocketAdapterFactory.createWebSocketAdapter();
        }
        return null;
    }

    static {
        sInstanceId = new AtomicInteger(0);
    }
}

