/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXLogUtils;

public class WXViewUtils {
    public static final int TRANSLUCENT = -3;
    public static final int TRANSPARENT = -2;
    public static final int OPAQUE = -1;
    public static final int DIMENSION_UNSET = -1;
    private static final boolean mUseWebPx = false;

    public static int getWeexHeight(String instanceId) {
        return WXViewUtils.getWeexHeight(instanceId, true);
    }

    public static int getWeexHeight(String instanceId, boolean useDefault) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            int weexHeight = instance.getWeexHeight();
            if (weexHeight >= 0 || weexHeight == -2) {
                return weexHeight;
            }
            if (useDefault) {
                return WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
            }
            return weexHeight;
        }
        return -3;
    }

    @Deprecated
    public static int getScreenHeight() {
        if (WXEnvironment.sApplication != null) {
            return WXEnvironment.sApplication.getResources().getDisplayMetrics().heightPixels;
        }
        if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return 0;
    }

    public static int getScreenHeight(Context cxt) {
        if (cxt != null) {
            return cxt.getResources().getDisplayMetrics().heightPixels;
        }
        if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return 0;
    }

    public static int getWeexWidth(String instanceId) {
        return WXViewUtils.getWeexWidth(instanceId, true);
    }

    public static int getWeexWidth(String instanceId, boolean useDefault) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            int weexWidth = instance.getWeexWidth();
            if (weexWidth >= 0 || weexWidth == -2) {
                return weexWidth;
            }
            if (useDefault) {
                return WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            }
            return weexWidth;
        }
        return -3;
    }

    @Deprecated
    public static int getScreenWidth() {
        if (WXEnvironment.sApplication != null) {
            int width = WXEnvironment.sApplication.getResources().getDisplayMetrics().widthPixels;
            if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                int height = WXEnvironment.sApplication.getResources().getDisplayMetrics().heightPixels;
                width = height > width ? width : height;
            }
            return width;
        }
        if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return 0;
    }

    public static int getScreenWidth(Context cxt) {
        if (cxt != null) {
            int width = WXEnvironment.sApplication.getResources().getDisplayMetrics().widthPixels;
            if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                int height = WXEnvironment.sApplication.getResources().getDisplayMetrics().heightPixels;
                width = height > width ? width : height;
            }
            return width;
        }
        if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return 0;
    }

    public static float getRealPxByWidth(float pxValue) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)WXEnvironment.sDefaultWidth;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : (float)Math.rint(realPx);
    }

    public static float getRealSubPxByWidth(float pxValue) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)WXEnvironment.sDefaultWidth;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : realPx;
    }

    public static float getWeexPxByReal(float pxValue) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        return pxValue * (float)WXEnvironment.sDefaultWidth / (float)WXViewUtils.getScreenWidth();
    }

    public static int getRealPxByWidth2(float pxValue) {
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)WXEnvironment.sDefaultWidth;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1 : (int)realPx - 1;
    }

    public static float getWebPxByWidth(float pxValue) {
        if ((double)pxValue < -1.9999 && (double)pxValue > -2.005) {
            return Float.NaN;
        }
        float realPx = pxValue * (float)WXEnvironment.sDefaultWidth / (float)WXViewUtils.getScreenWidth();
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : realPx;
    }

    public static int dip2px(float dpValue) {
        float scale = 2.0f;
        try {
            scale = WXEnvironment.getApplication().getResources().getDisplayMetrics().density;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXViewUtils] dip2px:", e);
        }
        float finalPx = dpValue * scale + 0.5f;
        return finalPx > 0.0f && finalPx < 1.0f ? 1 : (int)finalPx;
    }

    public static boolean onScreenArea(View view) {
        if (view == null || view.getVisibility() != 0) {
            return false;
        }
        int[] p = new int[2];
        view.getLocationOnScreen(p);
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        int viewH = 0;
        viewH = lp != null ? lp.height : view.getHeight();
        return p[1] > 0 && p[1] - WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication) < 0 || viewH + p[1] > 0 && p[1] <= 0;
    }

    public static int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        alpha += alpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * alpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    public static int getOpacityFromColor(int color) {
        int colorAlpha = color >>> 24;
        if (colorAlpha == 255) {
            return -1;
        }
        if (colorAlpha == 0) {
            return -2;
        }
        return -3;
    }

    public static void setBackGround(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable2);
        } else {
            view.setBackground(drawable2);
        }
    }

    @Nullable
    public static BorderDrawable getBorderDrawable(@NonNull View view) {
        Drawable innerDrawable;
        Drawable drawable2 = view.getBackground();
        if (drawable2 instanceof BorderDrawable) {
            return (BorderDrawable)drawable2;
        }
        if (drawable2 instanceof LayerDrawable && ((LayerDrawable)drawable2).getNumberOfLayers() > 1 && (innerDrawable = ((LayerDrawable)drawable2).getDrawable(0)) instanceof BorderDrawable) {
            return (BorderDrawable)innerDrawable;
        }
        return null;
    }
}

