/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXSmoothScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.Field;

@SuppressLint(value={"HandlerLeak"})
public class WXCircleViewPager
extends ViewPager
implements WXGestureObservable {
    private WXGesture wxGesture;
    private boolean isAutoScroll;
    private long intervalTime = 3000L;
    private WXSmoothScroller mScroller;
    private boolean needLoop = true;
    private Runnable scrollAction = new Runnable(){

        @Override
        public void run() {
            WXLogUtils.d("[CircleViewPager] trigger auto play action");
            WXCircleViewPager.this.superSetCurrentItem(WXCircleViewPager.super.getCurrentItem() + 1, true);
            WXCircleViewPager.this.removeCallbacks(this);
            WXCircleViewPager.this.postDelayed(this, WXCircleViewPager.this.intervalTime);
        }
    };

    @SuppressLint(value={"NewApi"})
    public WXCircleViewPager(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setOverScrollMode(2);
        this.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
                WXCirclePageAdapter adapter = WXCircleViewPager.this.getCirclePageAdapter();
                int currentItemInternal = WXCircleViewPager.super.getCurrentItem();
                if (WXCircleViewPager.this.needLoop && state == 0 && adapter.getCount() > 1) {
                    if (currentItemInternal == adapter.getCount() - 1) {
                        WXCircleViewPager.this.superSetCurrentItem(1, false);
                    } else if (currentItemInternal == 0) {
                        WXCircleViewPager.this.superSetCurrentItem(adapter.getCount() - 2, false);
                    }
                }
            }
        });
        this.postInitViewPager();
    }

    private void postInitViewPager() {
        if (this.isInEditMode()) {
            return;
        }
        try {
            Field scroller = ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new WXSmoothScroller(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set(this, (Object)this.mScroller);
        }
        catch (Exception e) {
            WXLogUtils.e("[CircleViewPager] postInitViewPager: ", e);
        }
    }

    @SuppressLint(value={"NewApi"})
    public WXCircleViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public int getCurrentItem() {
        return this.getRealCurrentItem();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean result = super.onTouchEvent(ev);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, ev);
        }
        return result;
    }

    public void startAutoScroll() {
        this.isAutoScroll = true;
        this.removeCallbacks(this.scrollAction);
        this.postDelayed(this.scrollAction, this.intervalTime);
    }

    public void pauseAutoScroll() {
        this.removeCallbacks(this.scrollAction);
    }

    public void stopAutoScroll() {
        this.isAutoScroll = false;
        this.removeCallbacks(this.scrollAction);
    }

    public boolean isAutoScroll() {
        return this.isAutoScroll;
    }

    public void setCurrentItem(int item) {
        this.setRealCurrentItem(item);
    }

    public WXCirclePageAdapter getCirclePageAdapter() {
        return (WXCirclePageAdapter)this.getAdapter();
    }

    public void setCirclePageAdapter(WXCirclePageAdapter circlePageAdapter) {
        this.setAdapter(circlePageAdapter);
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(long intervalTime) {
        this.intervalTime = intervalTime;
    }

    public void setCircle(boolean circle) {
        this.needLoop = circle;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: 
            case 2: {
                this.removeCallbacks(this.scrollAction);
                break;
            }
            case 1: 
            case 3: {
                if (!this.isAutoScroll()) break;
                this.postDelayed(this.scrollAction, this.intervalTime);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void destory() {
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public int getRealCurrentItem() {
        int i = super.getCurrentItem();
        return ((WXCirclePageAdapter)this.getAdapter()).getRealPosition(i);
    }

    private void setRealCurrentItem(int item) {
        this.superSetCurrentItem(((WXCirclePageAdapter)this.getAdapter()).getFirst() + item, false);
    }

    private void superSetCurrentItem(int item, boolean smooth) {
        block2: {
            try {
                super.setCurrentItem(item, smooth);
            }
            catch (IllegalStateException e) {
                WXLogUtils.e(e.toString());
                if (this.getAdapter() == null) break block2;
                this.getAdapter().notifyDataSetChanged();
                super.setCurrentItem(item, smooth);
            }
        }
    }

    public int getRealCount() {
        return ((WXCirclePageAdapter)this.getAdapter()).getRealCount();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block2: {
            try {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            catch (IllegalStateException e) {
                WXLogUtils.e(e.toString());
                if (this.getAdapter() == null) break block2;
                this.getAdapter().notifyDataSetChanged();
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }
}

