/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import java.util.ArrayList;

public abstract class WXVContainer<T extends ViewGroup>
extends WXComponent<T> {
    private static final String TAG = "WXVContainer";
    protected ArrayList<WXComponent> mChildren = new ArrayList();

    @Deprecated
    public WXVContainer(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    @Deprecated
    public WXVContainer(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent);
    }

    public WXVContainer(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    public void interceptFocus() {
        ViewGroup host = (ViewGroup)this.getHostView();
        if (host != null) {
            host.setFocusable(true);
            host.setFocusableInTouchMode(true);
            host.setDescendantFocusability(131072);
            host.requestFocus();
        }
    }

    public void ignoreFocus() {
        ViewGroup host = (ViewGroup)this.getHostView();
        if (host != null) {
            host.setFocusable(false);
            host.setFocusableInTouchMode(false);
            host.clearFocus();
        }
    }

    @Deprecated
    public ViewGroup getView() {
        return (ViewGroup)this.getHostView();
    }

    @Override
    public void applyLayoutAndEvent(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            super.applyLayoutAndEvent(component);
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.getChild(i).applyLayoutAndEvent(((WXVContainer)component).getChild(i));
            }
        }
    }

    @Override
    public void bindData(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            super.bindData(component);
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.getChild(i).bindData(((WXVContainer)component).getChild(i));
            }
        }
    }

    @Override
    public void refreshData(WXComponent component) {
        if (component == null) {
            component = this;
        }
        super.refreshData(component);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).refreshData(((WXVContainer)component).getChild(i));
        }
    }

    public ViewGroup getRealView() {
        return (ViewGroup)super.getRealView();
    }

    @Override
    public void createViewImpl(WXVContainer parent, int index) {
        super.createViewImpl(parent, index);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).createViewImpl(this, i);
        }
        if (this.getHostView() != null) {
            ((ViewGroup)this.getHostView()).setClipToPadding(false);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mChildren != null) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).destroy();
            }
            this.mChildren.clear();
        }
    }

    @Override
    public View detachViewAndClearPreInfo() {
        View original = super.detachViewAndClearPreInfo();
        if (this.mChildren != null) {
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).detachViewAndClearPreInfo();
            }
        }
        return original;
    }

    public int childCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public WXComponent getChild(int index) {
        return this.mChildren.get(index);
    }

    public int getChildCount() {
        return this.mChildren.size();
    }

    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    public void addChild(WXComponent child, int index) {
        if (child == null || index < -1) {
            return;
        }
        int count = this.mChildren.size();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
    }

    protected void addSubView(View child, int index) {
        if (child == null || this.getRealView() == null) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.getRealView().addView(child);
        } else {
            this.getRealView().addView(child, index);
        }
    }

    public void remove(WXComponent child) {
        this.remove(child, true);
    }

    public void remove(WXComponent child, boolean destroy) {
        if (child == null || this.mChildren == null || this.mChildren.size() == 0) {
            return;
        }
        this.mChildren.remove(child);
        if (this.getInstance() != null && this.getInstance().getRootView() != null && child.getDomObject().isFixed()) {
            this.getInstance().getRootView().removeView(child.getHostView());
        } else if (this.getRealView() != null) {
            this.getRealView().removeView(child.getHostView());
        }
        if (destroy) {
            child.destroy();
        }
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        super.notifyAppearStateChange(wxEventType, direction);
        if (this.getHostView() == null || this.mChildren == null) {
            return;
        }
        for (WXComponent component : this.mChildren) {
            if (component.getHostView() != null && component.getHostView().getVisibility() != 0) {
                wxEventType = "disappear";
            }
            component.notifyAppearStateChange(wxEventType, direction);
        }
    }
}

