/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class WXSliderNeighbor
extends WXSlider {
    public static final String NEIGHBOR_SCALE = "neighborScale";
    public static final String NEIGHBOR_ALPHA = "neighborAlpha";
    public static final String NEIGHBOR_SPACE = "neighborSpace";
    private static final int DEFAULT_NEIGHBOR_SPACE = 25;
    private static final float DEFAULT_NEIGHBOR_SCALE = 0.8f;
    private static final float DEFAULT_NEIGHBOR_ALPHA = 0.6f;
    private float mNeighborScale = 0.8f;
    private float mNeighborAlpha = 0.6f;
    private float mNeighborSpace = 25.0f;
    private static final float WX_DEFAULT_MAIN_NEIGHBOR_SCALE = 0.9f;

    public WXSliderNeighbor(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    public void bindData(WXComponent component) {
        super.bindData(component);
        if (this.mAdapter.getRealCount() > 3) {
            this.mViewPager.setOffscreenPageLimit(2);
        } else if (this.mAdapter.getRealCount() == 3) {
            this.mViewPager.setOffscreenPageLimit(1);
        }
    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        FrameLayout view = new FrameLayout(context);
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        pagerParams.gravity = 17;
        this.mViewPager = new WXCircleViewPager(this.getContext());
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter();
        this.mViewPager.setAdapter(this.mAdapter);
        view.addView((View)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        this.mViewPager.setPageTransformer(true, this.createTransformer());
        this.mViewPager.setOverScrollMode(2);
        this.registerActivityStateListener();
        return view;
    }

    ZoomTransformer createTransformer() {
        return new ZoomTransformer();
    }

    @Override
    protected void addSubView(View view, int index) {
        this.updateScaleAndAlpha(view, this.mNeighborAlpha, this.mNeighborScale);
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        FrameLayout wrapper = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        wrapper.addView(view);
        super.addSubView((View)wrapper, index);
    }

    private void updateScaleAndAlpha(View view, float alpha, float scale) {
        if (null == view) {
            return;
        }
        if (alpha >= 0.0f) {
            view.setAlpha(alpha);
        }
        if (scale >= 0.0f) {
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private void updateAdapterScaleAndAlpha(float alpha, float scale) {
        List<View> pageViews = this.mAdapter.getViews();
        int cusPos = this.mViewPager.getCurrentItem();
        if (null != pageViews && pageViews.size() > 0) {
            for (View v : pageViews) {
                View realView = ((ViewGroup)v).getChildAt(0);
                if (this.mAdapter.getItemIndex(v) != cusPos) {
                    this.updateScaleAndAlpha(realView, alpha, scale);
                    continue;
                }
                this.updateScaleAndAlpha(realView, 1.0f, 0.9f);
            }
        }
    }

    @WXComponentProp(name="neighborScale")
    public void setNeighborScale(String input) {
        float neighborScale = 0.8f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborScale = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNeighborScale != neighborScale) {
            this.mNeighborScale = neighborScale;
            this.updateAdapterScaleAndAlpha(-1.0f, neighborScale);
        }
    }

    @WXComponentProp(name="neighborAlpha")
    public void setNeighborAlpha(String input) {
        float neighborAlpha = 0.6f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborAlpha = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNeighborAlpha != neighborAlpha) {
            this.mNeighborAlpha = neighborAlpha;
            this.updateAdapterScaleAndAlpha(neighborAlpha, -1.0f);
        }
    }

    @WXComponentProp(name="neighborSpace")
    public void setNeighborSpace(String input) {
        float neighborSpace = 25.0f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborSpace = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNeighborSpace != neighborSpace) {
            this.mNeighborSpace = neighborSpace;
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "neighborScale": {
                String input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborScale(input);
                }
                return true;
            }
            case "neighborAlpha": {
                String input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborAlpha(input);
                }
                return true;
            }
            case "neighborSpace": {
                String input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborSpace(input);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    class ZoomTransformer
    implements ViewPager.PageTransformer {
        ZoomTransformer() {
        }

        public void transformPage(View page, float position) {
            View realView = ((ViewGroup)page).getChildAt(0);
            if (realView == null) {
                return;
            }
            if (position <= (float)(-WXSliderNeighbor.this.mAdapter.getRealCount() + 1)) {
                position += (float)WXSliderNeighbor.this.mAdapter.getRealCount();
            }
            if (position >= (float)(WXSliderNeighbor.this.mAdapter.getRealCount() - 1)) {
                position -= (float)WXSliderNeighbor.this.mAdapter.getRealCount();
            }
            if (position >= -1.0f && position <= 1.0f) {
                float factor = Math.abs(Math.abs(position) - 1.0f);
                float scale = WXSliderNeighbor.this.mNeighborScale + factor * (0.9f - WXSliderNeighbor.this.mNeighborScale);
                float alpha = (1.0f - WXSliderNeighbor.this.mNeighborAlpha) * factor + WXSliderNeighbor.this.mNeighborAlpha;
                float translation = ((float)page.getMeasuredWidth() - (float)realView.getMeasuredWidth() * WXSliderNeighbor.this.mNeighborScale) / 4.0f;
                translation += (((float)page.getMeasuredWidth() - (float)realView.getMeasuredWidth() * 0.9f) / 2.0f - WXViewUtils.getRealPxByWidth(WXSliderNeighbor.this.mNeighborSpace)) / 2.0f;
                if (position > 0.0f) {
                    translation = position * translation;
                    realView.setTranslationX(-translation);
                    page.setTranslationX(-translation);
                } else if (position == 0.0f) {
                    page.setTranslationX(0.0f);
                    realView.setTranslationX(0.0f);
                } else {
                    translation = -position * translation;
                    realView.setTranslationX(translation);
                    page.setTranslationX(translation);
                }
                realView.setPivotY((float)(realView.getMeasuredHeight() / 2));
                realView.setAlpha(alpha);
                realView.setScaleX(scale);
                realView.setScaleY(scale);
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXSliderNeighbor(instance, node, parent);
        }
    }
}

