/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXIndicator
extends WXComponent<WXCircleIndicator> {
    @Deprecated
    public WXIndicator(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXIndicator(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
    }

    @Override
    protected WXCircleIndicator initComponentHostView(@NonNull Context context) {
        WXCircleIndicator view = new WXCircleIndicator(context);
        if (this.getParent() instanceof WXSlider) {
            return view;
        }
        if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("WXIndicator initView error.");
        }
        return null;
    }

    @Override
    protected void onHostViewInitialized(WXCircleIndicator host) {
        super.onHostViewInitialized(host);
        if (this.getParent() instanceof WXSlider) {
            ((WXSlider)this.getParent()).addIndicator(this);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "itemColor": {
                String item_color = WXUtils.getString(param, null);
                if (item_color != null) {
                    this.setItemColor(item_color);
                }
                return true;
            }
            case "itemSelectedColor": {
                String selected_color = WXUtils.getString(param, null);
                if (selected_color != null) {
                    this.setItemSelectedColor(selected_color);
                }
                return true;
            }
            case "itemSize": {
                Integer item_size = WXUtils.getInteger(param, null);
                if (item_size != null) {
                    this.setItemSize(item_size);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="itemColor")
    public void setItemColor(String itemColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)itemColor) && (colorInt = WXResourceUtils.getColor(itemColor)) != Integer.MIN_VALUE) {
            ((WXCircleIndicator)this.getHostView()).setPageColor(colorInt);
            ((WXCircleIndicator)this.getHostView()).forceLayout();
            ((WXCircleIndicator)this.getHostView()).requestLayout();
        }
    }

    @WXComponentProp(name="itemSelectedColor")
    public void setItemSelectedColor(String itemSelectedColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)itemSelectedColor) && (colorInt = WXResourceUtils.getColor(itemSelectedColor)) != Integer.MIN_VALUE) {
            ((WXCircleIndicator)this.getHostView()).setFillColor(colorInt);
            ((WXCircleIndicator)this.getHostView()).forceLayout();
            ((WXCircleIndicator)this.getHostView()).requestLayout();
        }
    }

    @WXComponentProp(name="itemSize")
    public void setItemSize(int itemSize) {
        if (itemSize < 0) {
            return;
        }
        ((WXCircleIndicator)this.getHostView()).setRadius(WXViewUtils.getRealPxByWidth(itemSize) / 2.0f);
        ((WXCircleIndicator)this.getHostView()).forceLayout();
        ((WXCircleIndicator)this.getHostView()).requestLayout();
    }

    public void setShowIndicators(boolean show) {
        if (this.getHostView() == null) {
            return;
        }
        if (show) {
            ((WXCircleIndicator)this.getHostView()).setVisibility(0);
        } else {
            ((WXCircleIndicator)this.getHostView()).setVisibility(8);
        }
    }

    public static class IndicatorDomNode
    extends WXDomObject {
        @Override
        protected Map<String, String> getDefaultStyle() {
            WXStyle pendingStyles = this.getStyles();
            HashMap<String, String> map = new HashMap<String, String>();
            if (!pendingStyles.containsKey("right")) {
                map.put("left", "0");
            }
            if (!pendingStyles.containsKey("bottom")) {
                map.put("top", "0");
            }
            return map;
        }
    }
}

