/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.res.ResourcesCompat;
import android.text.TextUtils;
import android.widget.ImageView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXImage
extends WXComponent<ImageView> {
    @Deprecated
    public WXImage(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXImage(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    protected ImageView initComponentHostView(@NonNull Context context) {
        WXImageView view = new WXImageView(context);
        view.setScaleType(ImageView.ScaleType.FIT_XY);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setCropToPadding(true);
        }
        return view;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "resizeMode": {
                String resize_mode = WXUtils.getString(param, null);
                if (resize_mode != null) {
                    this.setResizeMode(resize_mode);
                }
                return true;
            }
            case "resize": {
                String resize = WXUtils.getString(param, null);
                if (resize != null) {
                    this.setResize(resize);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "imageQuality": {
                return true;
            }
            case "filter": {
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    public void refreshData(WXComponent component) {
        super.refreshData(component);
        if (component instanceof WXImage) {
            this.setSrc(component.getDomObject().getAttrs().getImageSrc());
        }
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resizeMode));
    }

    private ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        if (resizeMode.equals("cover")) {
            scaleType = ImageView.ScaleType.CENTER_CROP;
        } else if (resizeMode.equals("contain")) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        } else if (resizeMode.equals("stretch")) {
            scaleType = ImageView.ScaleType.FIT_XY;
        } else if (resizeMode.equals("center")) {
            scaleType = ImageView.ScaleType.CENTER;
        } else if (resizeMode.equals("start")) {
            scaleType = ImageView.ScaleType.MATRIX;
        } else if (resizeMode.equals("end")) {
            scaleType = ImageView.ScaleType.FIT_END;
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resize));
    }

    private void setLocalSrc(Uri rewrited) {
        ImageView imageView;
        Resources resources = this.getContext().getResources();
        List segments = rewrited.getPathSegments();
        if (segments.size() != 1) {
            WXLogUtils.e("Local src format is invalid.");
            return;
        }
        int id = resources.getIdentifier((String)segments.get(0), "drawable", this.getContext().getPackageName());
        if (id != 0 && (imageView = (ImageView)this.getHostView()) != null) {
            imageView.setImageDrawable(ResourcesCompat.getDrawable((Resources)resources, (int)id, null));
        }
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (src == null) {
            return;
        }
        WXSDKInstance instance = this.getInstance();
        Uri rewrited = instance.rewriteUri(Uri.parse((String)src), "image");
        if ("local".equals(rewrited.getScheme())) {
            this.setLocalSrc(rewrited);
        } else {
            this.setRemoteSrc(rewrited);
        }
    }

    private void setRemoteSrc(Uri rewrited) {
        IWXImgLoaderAdapter imgLoaderAdapter;
        WXSDKInstance instance = this.getInstance();
        WXImageStrategy imageStrategy = new WXImageStrategy();
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.getDomObject().getAttrs().getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        imageStrategy.blurRadius = this.getDomObject().getStyles().getBlur();
        imageStrategy.setImageListener(new WXImageStrategy.ImageListener(){

            @Override
            public void onImageFinish(String url, ImageView imageView, boolean result, Map extra) {
                if (WXImage.this.getDomObject() != null && WXImage.this.getDomObject().containsEvent("load")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("success", result);
                    WXImage.this.getInstance().fireEvent(WXImage.this.getDomObject().getRef(), "load", params);
                }
            }
        });
        String placeholder = null;
        if (this.getDomObject().getAttrs().containsKey("placeholder")) {
            placeholder = (String)this.getDomObject().getAttrs().get("placeholder");
        } else if (this.getDomObject().getAttrs().containsKey("placeHolder")) {
            placeholder = (String)this.getDomObject().getAttrs().get("placeHolder");
        }
        if (placeholder != null) {
            imageStrategy.placeHolder = instance.rewriteUri(Uri.parse((String)placeholder), "image").toString();
        }
        if ((imgLoaderAdapter = this.getInstance().getImgLoaderAdapter()) != null) {
            imgLoaderAdapter.setImage(rewrited.toString(), (ImageView)this.getHostView(), this.getDomObject().getAttrs().getImageQuality(), imageStrategy);
        }
    }

    public static class Ceator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXImage(instance, node, parent);
        }
    }
}

