/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.alibaba.fastjson.JSONArray;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.JSCallbackCreator;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.CSSLayout;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class WXComponent<T extends View>
implements IWXObject,
IWXActivityStateListener {
    public static int mComponentNum = 0;
    public T mHost;
    @Deprecated
    public volatile WXVContainer mParent;
    @Deprecated
    public volatile WXDomObject mDomObj;
    @Deprecated
    public final String mInstanceId;
    @Deprecated
    protected WXSDKInstance mInstance;
    @Deprecated
    protected Context mContext;
    protected int mAbsoluteY = 0;
    protected int mAbsoluteX = 0;
    protected Set<String> mGestureType;
    private BorderDrawable mBackgroundDrawable;
    private int mPreRealWidth = 0;
    private int mPreRealHeight = 0;
    private int mPreRealLeft = 0;
    private int mPreRealTop = 0;
    private WXGesture wxGesture;
    private IFComponentHolder mHolder;
    private boolean isUsing = false;
    private List<OnClickListener> mHostClickListeners;
    private List<OnFocusChangeListener> mFocusChangeListeners;
    private String mCurrentRef;
    private OnClickListener mClickEventListener = new OnClickListener(){

        @Override
        public void onHostViewClick() {
            HashMap<String, Object> param = WXDataStructureUtil.newHashMapWithExpectedSize(1);
            HashMap<String, Float> position = WXDataStructureUtil.newHashMapWithExpectedSize(4);
            int[] location = new int[2];
            WXComponent.this.mHost.getLocationOnScreen(location);
            position.put("x", Float.valueOf(WXViewUtils.getWebPxByWidth(location[0])));
            position.put("y", Float.valueOf(WXViewUtils.getWebPxByWidth(location[1])));
            position.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(WXComponent.this.mDomObj.getCSSLayoutWidth())));
            position.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(WXComponent.this.mDomObj.getCSSLayoutHeight())));
            param.put("position", position);
            WXComponent.this.getInstance().fireEvent(WXComponent.this.mCurrentRef, "click", param);
        }
    };

    public String getInstanceId() {
        return this.mInstanceId;
    }

    public final void invoke(String method, JSONArray args) {
        block5: {
            final Invoker invoker = this.mHolder.getMethodInvoker(method);
            if (invoker != null) {
                try {
                    final Object[] params = WXReflectionUtils.prepareArguments(invoker.getParameterTypes(), args, SimpleJSCallbackCreator.getCreatorForOnetimeUsage(this.mInstanceId));
                    if (invoker.isRunInUIThread()) {
                        WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    invoker.invoke(WXComponent.this, params);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }, 0L);
                        break block5;
                    }
                    invoker.invoke(this, params);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + invoker.toString() + " function " + WXLogUtils.getStackTrace(e));
                }
            } else {
                this.onInvokeUnknownMethod(method, args);
            }
        }
    }

    protected void onInvokeUnknownMethod(String method, JSONArray args) {
    }

    public Rect getComponentSize() {
        Rect size = new Rect();
        if (this.mHost != null) {
            int[] location = new int[2];
            this.mHost.getLocationOnScreen(location);
            int left = location[0];
            int top = location[1];
            int width = (int)this.mDomObj.getCSSLayoutWidth();
            int height = (int)this.mDomObj.getCSSLayoutHeight();
            size.set(left, top, left + width, top + height);
        }
        return size;
    }

    @Deprecated
    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    @Deprecated
    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent) {
        this.mInstance = instance;
        this.mContext = this.mInstance.getContext();
        this.mParent = parent;
        this.mDomObj = dom.clone();
        this.mInstanceId = instance.getInstanceId();
        this.mCurrentRef = this.mDomObj.getRef();
        this.mGestureType = new HashSet<String>();
        ++mComponentNum;
        this.onCreate();
    }

    protected void onCreate() {
    }

    public void bindHolder(IFComponentHolder holder) {
        this.mHolder = holder;
    }

    public WXSDKInstance getInstance() {
        return this.mInstance;
    }

    public Context getContext() {
        return this.mContext;
    }

    public boolean isLazy() {
        return this.mParent != null && this.mParent.isLazy();
    }

    public void applyLayoutAndEvent(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            this.setLayout(component.getDomObject());
            this.setPadding(component.getDomObject().getPadding(), component.getDomObject().getBorder());
            this.addEvents();
        }
    }

    protected final void addFocusChangeListener(OnFocusChangeListener l) {
        View view;
        if (l != null && (view = this.getRealView()) != null) {
            if (this.mFocusChangeListeners == null) {
                this.mFocusChangeListeners = new ArrayList<OnFocusChangeListener>();
                view.setFocusable(true);
                view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                    public void onFocusChange(View v, boolean hasFocus) {
                        for (OnFocusChangeListener listener : WXComponent.this.mFocusChangeListeners) {
                            if (listener == null) continue;
                            listener.onFocusChange(hasFocus);
                        }
                    }
                });
            }
            this.mFocusChangeListeners.add(l);
        }
    }

    protected final void addClickListener(OnClickListener l) {
        View view;
        if (l != null && (view = this.getRealView()) != null) {
            if (this.mHostClickListeners == null) {
                this.mHostClickListeners = new ArrayList<OnClickListener>();
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        for (OnClickListener listener : WXComponent.this.mHostClickListeners) {
                            if (listener == null) continue;
                            listener.onHostViewClick();
                        }
                    }
                });
            }
            this.mHostClickListeners.add(l);
        }
    }

    protected final void removeClickListener(OnClickListener l) {
        this.mHostClickListeners.remove(l);
    }

    public void bindData(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            this.mCurrentRef = component.getDomObject().getRef();
            this.updateProperties(component.getDomObject().getStyles());
            this.updateProperties(component.getDomObject().getAttrs());
            this.updateExtra(component.getDomObject().getExtra());
        }
    }

    public void refreshData(WXComponent component) {
    }

    protected BorderDrawable getOrCreateBorder() {
        if (this.mBackgroundDrawable == null) {
            Drawable backgroundDrawable = this.mHost.getBackground();
            WXViewUtils.setBackGround(this.mHost, null);
            this.mBackgroundDrawable = new BorderDrawable();
            if (backgroundDrawable == null) {
                WXViewUtils.setBackGround(this.mHost, this.mBackgroundDrawable);
            } else {
                WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mBackgroundDrawable, backgroundDrawable}));
            }
        }
        return this.mBackgroundDrawable;
    }

    public final void setLayout(WXDomObject domObject) {
        if (this.mParent == null || domObject == null || TextUtils.isEmpty((CharSequence)this.mCurrentRef)) {
            return;
        }
        this.mDomObj = domObject;
        if (this instanceof WXRefresh && this.mParent instanceof WXScroller && this.hasScrollParent(this.mParent)) {
            this.mInstance.setRefreshMargin(this.mDomObj.getCSSLayoutHeight());
        }
        if (this instanceof WXBaseRefresh && this.mParent instanceof WXScroller) {
            return;
        }
        if (this.mParent instanceof WXScroller && this.hasScrollParent(this.mParent) && !(this instanceof WXBaseRefresh)) {
            CSSLayout newLayout = new CSSLayout();
            newLayout.copy(this.mDomObj.csslayout);
            newLayout.position[1] = this.mDomObj.getCSSLayoutTop() - this.mInstance.getRefreshMargin();
            this.mDomObj.csslayout.copy(newLayout);
        }
        Spacing parentPadding = this.mParent.getDomObject().getPadding();
        Spacing parentBorder = this.mParent.getDomObject().getBorder();
        Spacing margin = this.mDomObj.getMargin();
        int realWidth = (int)this.mDomObj.getLayoutWidth();
        int realHeight = (int)this.mDomObj.getLayoutHeight();
        int realLeft = (int)(this.mDomObj.getLayoutX() - parentPadding.get(0) - parentBorder.get(0));
        int realTop = (int)(this.mDomObj.getLayoutY() - parentPadding.get(1) - parentBorder.get(1));
        int realRight = (int)margin.get(2);
        int realBottom = (int)margin.get(3);
        if (this.mPreRealWidth == realWidth && this.mPreRealHeight == realHeight && this.mPreRealLeft == realLeft && this.mPreRealTop == realTop) {
            return;
        }
        if (this.mParent != null) {
            this.mAbsoluteY = (int)((float)this.mParent.mAbsoluteY + this.mDomObj.getLayoutY());
            this.mAbsoluteX = (int)((float)this.mParent.mAbsoluteX + this.mDomObj.getLayoutX());
        }
        if (!this.mInstance.mEnd && !(this.mHost instanceof ViewGroup) && this.mAbsoluteY + realHeight > this.mInstance.getWeexHeight() + 1) {
            this.mInstance.firstScreenRenderFinished();
        }
        if (this.mHost == null) {
            return;
        }
        MeasureOutput measureOutput = this.measure(realWidth, realHeight);
        realWidth = measureOutput.width;
        realHeight = measureOutput.height;
        if (this.mHost instanceof WXCircleIndicator) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(realWidth, realHeight);
            params.setMargins(realLeft, realTop, realRight, realBottom);
            this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            return;
        }
        if (this.mDomObj.isFixed() && this.mInstance.getRootView() != null) {
            if (this.mHost.getParent() instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)this.mHost.getParent();
                viewGroup.removeView(this.mHost);
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.width = realWidth;
            params.height = realHeight;
            params.setMargins(realLeft, realTop, realRight, realBottom);
            this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mInstance.getRootView().addView(this.mHost);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout :" + realLeft + " " + realTop + " " + realWidth + " " + realHeight);
                WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout Left:" + this.mDomObj.getStyles().getLeft() + " " + (int)this.mDomObj.getStyles().getTop());
            }
            return;
        }
        if (!(this.mParent.getRealView() instanceof ViewPager)) {
            if (this.mParent.getRealView() instanceof BounceRecyclerView && this instanceof WXCell) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)this.mHost.getLayoutParams();
                if (params == null) {
                    params = new RecyclerView.LayoutParams(realWidth, realHeight);
                }
                params.width = realWidth;
                params.height = realHeight;
                params.setMargins(realLeft, 0, realRight, 0);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof BaseBounceView && this instanceof WXBaseRefresh) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(realWidth, realHeight);
                realTop = (int)(parentPadding.get(1) - parentBorder.get(1));
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof FrameLayout) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(realWidth, realHeight);
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof LinearLayout) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(realWidth, realHeight);
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof ScrollView) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(realWidth, realHeight);
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        this.mPreRealWidth = realWidth;
        this.mPreRealHeight = realHeight;
        this.mPreRealLeft = realLeft;
        this.mPreRealTop = realTop;
        this.onFinishLayout();
    }

    protected void onFinishLayout() {
    }

    public void setPadding(Spacing padding, Spacing border) {
        int left = (int)(padding.get(0) + border.get(0));
        int top = (int)(padding.get(1) + border.get(1));
        int right = (int)(padding.get(2) + border.get(2));
        int bottom = (int)(padding.get(3) + border.get(3));
        if (this.mHost == null) {
            return;
        }
        this.mHost.setPadding(left, top, right, bottom);
    }

    private void addEvents() {
        int count = this.mDomObj.getEvents().size();
        for (int i = 0; i < count; ++i) {
            this.addEvent((String)this.mDomObj.getEvents().get(i));
        }
    }

    public void updateExtra(Object extra) {
    }

    public WXDomObject getDomObject() {
        return this.mDomObj;
    }

    protected MeasureOutput measure(int width, int height) {
        MeasureOutput measureOutput = new MeasureOutput();
        measureOutput.width = width;
        measureOutput.height = height;
        return measureOutput;
    }

    public void updateProperties(Map<String, Object> props) {
        if (props == null || this.mHost == null) {
            return;
        }
        for (String key : props.keySet()) {
            Invoker invoker;
            Object param = props.get(key);
            String value = WXUtils.getString(param, null);
            if (TextUtils.isEmpty((CharSequence)value)) {
                param = this.convertEmptyProperty(key);
            }
            if (this.setProperty(key, param) || (invoker = this.mHolder.getPropertyInvoker(key)) == null) continue;
            try {
                Type[] paramClazzs = invoker.getParameterTypes();
                if (paramClazzs.length != 1) {
                    WXLogUtils.e("[WXComponent] setX method only one parameter\uff1a" + invoker);
                    return;
                }
                param = WXReflectionUtils.parseArgument(paramClazzs[0], props.get(key));
                invoker.invoke(this, param);
            }
            catch (Exception e) {
                WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + invoker.toString() + " function " + WXLogUtils.getStackTrace(e));
            }
        }
    }

    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "disabled": {
                Boolean disabled = WXUtils.getBoolean(param, null);
                if (disabled != null) {
                    this.setDisabled(disabled);
                }
                return true;
            }
            case "position": {
                String position = WXUtils.getString(param, null);
                if (position != null) {
                    this.setSticky(position);
                }
                return true;
            }
            case "backgroundColor": {
                String bgColor = WXUtils.getString(param, null);
                if (bgColor != null) {
                    this.setBackgroundColor(bgColor);
                }
                return true;
            }
            case "opacity": {
                Float opacity = WXUtils.getFloat(param, null);
                if (opacity != null) {
                    this.setOpacity(opacity.floatValue());
                }
                return true;
            }
            case "borderRadius": 
            case "borderTopLeftRadius": 
            case "borderTopRightRadius": 
            case "borderBottomRightRadius": 
            case "borderBottomLeftRadius": {
                Float radius = WXUtils.getFloat(param, null);
                if (radius != null) {
                    this.setBorderRadius(key, radius.floatValue());
                }
                return true;
            }
            case "borderWidth": 
            case "borderTopWidth": 
            case "borderRightWidth": 
            case "borderBottomWidth": 
            case "borderLeftWidth": {
                Float width = WXUtils.getFloat(param, null);
                if (width != null) {
                    this.setBorderWidth(key, width.floatValue());
                }
                return true;
            }
            case "borderStyle": 
            case "borderRightStyle": 
            case "borderBottomStyle": 
            case "borderLeftStyle": 
            case "borderTopStyle": {
                String border_style = WXUtils.getString(param, null);
                if (border_style != null) {
                    this.setBorderStyle(key, border_style);
                }
                return true;
            }
            case "borderColor": 
            case "borderTopColor": 
            case "borderRightColor": 
            case "borderBottomColor": 
            case "borderLeftColor": {
                String border_color = WXUtils.getString(param, null);
                if (border_color != null) {
                    this.setBorderColor(key, border_color);
                }
                return true;
            }
            case "visibility": {
                String visibility = WXUtils.getString(param, null);
                if (visibility != null) {
                    this.setVisibility(visibility);
                }
                return true;
            }
            case "width": 
            case "minWidth": 
            case "maxWidth": 
            case "height": 
            case "minHeight": 
            case "maxHeight": 
            case "alignItems": 
            case "alignSelf": 
            case "flex": 
            case "flexDirection": 
            case "justifyContent": 
            case "flexWrap": 
            case "margin": 
            case "marginTop": 
            case "marginLeft": 
            case "marginRight": 
            case "marginBottom": 
            case "padding": 
            case "paddingTop": 
            case "paddingLeft": 
            case "paddingRight": 
            case "paddingBottom": 
            case "left": 
            case "top": 
            case "right": 
            case "bottom": {
                return true;
            }
        }
        return false;
    }

    public void addEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.mDomObj.addEvent(type);
        if (type.equals("click") && this.getRealView() != null) {
            this.addClickListener(this.mClickEventListener);
        } else if (type.equals("focus") || type.equals("blur")) {
            this.addFocusChangeListener(new OnFocusChangeListener(){

                @Override
                public void onFocusChange(boolean hasFocus) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("timeStamp", System.currentTimeMillis());
                    WXComponent.this.getInstance().fireEvent(WXComponent.this.mCurrentRef, hasFocus ? "focus" : "blur", params);
                }
            });
        } else if (this.getRealView() != null && this.needGestureDetector(type)) {
            if (this.getRealView() instanceof WXGestureObservable) {
                if (this.wxGesture == null) {
                    this.wxGesture = new WXGesture(this, this.mContext);
                }
                this.mGestureType.add(type);
                ((WXGestureObservable)this.getRealView()).registerGestureListener(this.wxGesture);
            } else {
                WXLogUtils.e(this.getRealView().getClass().getSimpleName() + " don't implement " + "WXGestureObservable, so no gesture is supported.");
            }
        } else {
            Scrollable scroller = this.getParentScroller();
            if (type.equals("appear") && scroller != null) {
                scroller.bindAppearEvent(this);
            }
            if (type.equals("disappear") && scroller != null) {
                scroller.bindDisappearEvent(this);
            }
        }
    }

    public View getRealView() {
        return this.mHost;
    }

    private boolean needGestureDetector(String type) {
        if (this.mHost != null) {
            for (WXGestureType.LowLevelGesture lowLevelGesture : WXGestureType.LowLevelGesture.values()) {
                if (!type.equals(((Object)lowLevelGesture).toString())) continue;
                return true;
            }
            for (Enum enum_ : WXGestureType.HighLevelGesture.values()) {
                if (!type.equals(enum_.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public Scrollable getParentScroller() {
        WXComponent component = this;
        WXVContainer container;
        while ((container = component.getParent()) != null) {
            if (container instanceof Scrollable) {
                Scrollable scroller = (Scrollable)((Object)container);
                return scroller;
            }
            if (container.getRef().equals("_root")) {
                return null;
            }
            component = container;
        }
        return null;
    }

    public WXVContainer getParent() {
        return this.mParent;
    }

    public String getRef() {
        if (this.mDomObj == null) {
            return null;
        }
        return this.mCurrentRef;
    }

    public final void createView(WXVContainer parent, int index) {
        if (!this.isLazy()) {
            this.createViewImpl(parent, index);
        }
    }

    protected void createViewImpl(WXVContainer parent, int index) {
        if (this.mContext != null) {
            this.mHost = this.initComponentHostView(this.mContext);
            if (this.mHost == null) {
                this.initView();
            }
            this.onHostViewInitialized(this.mHost);
            if (parent != null) {
                parent.addSubView((View)this.mHost, index);
            }
        } else {
            WXLogUtils.e("createViewImpl", "Context is null");
        }
    }

    @Deprecated
    protected void initView() {
        if (this.mContext != null) {
            this.mHost = this.initComponentHostView(this.mContext);
        }
    }

    protected T initComponentHostView(@NonNull Context context) {
        return null;
    }

    protected void onHostViewInitialized(T host) {
    }

    public T getHostView() {
        return this.mHost;
    }

    @Deprecated
    public View getView() {
        return this.mHost;
    }

    public int getAbsoluteY() {
        return this.mAbsoluteY;
    }

    public int getAbsoluteX() {
        return this.mAbsoluteX;
    }

    public void updateDom(WXDomObject dom) {
        if (dom == null) {
            return;
        }
        this.mDomObj = dom;
    }

    public final void removeEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.mDomObj.removeEvent(type);
        this.mGestureType.remove(type);
        this.removeEventFromView(type);
    }

    protected void removeEventFromView(String type) {
        if (type.equals("click") && this.getRealView() != null && this.mHostClickListeners != null) {
            this.mHostClickListeners.remove(this.mClickEventListener);
        }
        Scrollable scroller = this.getParentScroller();
        if (type.equals("appear") && scroller != null) {
            scroller.unbindAppearEvent(this);
        }
        if (type.equals("disappear") && scroller != null) {
            scroller.unbindDisappearEvent(this);
        }
    }

    public final void removeAllEvent() {
        if (this.mDomObj == null || this.mDomObj.getEvents().size() < 1) {
            return;
        }
        for (String event : this.mDomObj.getEvents()) {
            this.removeEventFromView(event);
        }
        this.mDomObj.clearEvents();
        this.mGestureType.clear();
        this.wxGesture = null;
        if (this.getRealView() != null && this.getRealView() instanceof WXGestureObservable) {
            ((WXGestureObservable)this.getRealView()).registerGestureListener(null);
        }
    }

    public final void removeStickyStyle() {
        Scrollable scroller;
        if (this.mDomObj == null) {
            return;
        }
        if (this.isSticky() && (scroller = this.getParentScroller()) != null) {
            scroller.unbindStickStyle(this);
        }
    }

    public boolean isSticky() {
        return this.mDomObj.getStyles().isSticky();
    }

    public void setDisabled(boolean disabled) {
        if (this.mHost == null) {
            return;
        }
        this.mHost.setEnabled(!disabled);
    }

    public void setSticky(String sticky) {
        Scrollable waScroller;
        if (!TextUtils.isEmpty((CharSequence)sticky) && sticky.equals("sticky") && (waScroller = this.getParentScroller()) != null) {
            waScroller.bindStickStyle(this);
        }
    }

    public void setBackgroundColor(String color) {
        int colorInt;
        if (!(TextUtils.isEmpty((CharSequence)color) || this.mHost == null || (colorInt = WXResourceUtils.getColor(color)) == 0 && this.mBackgroundDrawable == null)) {
            this.getOrCreateBorder().setColor(colorInt);
        }
    }

    public void setOpacity(float opacity) {
        if (opacity >= 0.0f && opacity <= 1.0f && this.mHost.getAlpha() != opacity) {
            this.mHost.setLayerType(2, null);
            this.mHost.setAlpha(opacity);
        }
    }

    public void setBorderRadius(String key, float borderRadius) {
        if (borderRadius >= 0.0f) {
            switch (key) {
                case "borderRadius": {
                    this.getOrCreateBorder().setBorderRadius(8, WXViewUtils.getRealSubPxByWidth(borderRadius));
                    break;
                }
                case "borderTopLeftRadius": {
                    this.getOrCreateBorder().setBorderRadius(0, WXViewUtils.getRealSubPxByWidth(borderRadius));
                    break;
                }
                case "borderTopRightRadius": {
                    this.getOrCreateBorder().setBorderRadius(1, WXViewUtils.getRealSubPxByWidth(borderRadius));
                    break;
                }
                case "borderBottomRightRadius": {
                    this.getOrCreateBorder().setBorderRadius(2, WXViewUtils.getRealSubPxByWidth(borderRadius));
                    break;
                }
                case "borderBottomLeftRadius": {
                    this.getOrCreateBorder().setBorderRadius(3, WXViewUtils.getRealSubPxByWidth(borderRadius));
                }
            }
        }
    }

    public void setBorderWidth(String key, float borderWidth) {
        if (borderWidth >= 0.0f) {
            switch (key) {
                case "borderWidth": {
                    this.getOrCreateBorder().setBorderWidth(8, WXViewUtils.getRealSubPxByWidth(borderWidth));
                    break;
                }
                case "borderTopWidth": {
                    this.getOrCreateBorder().setBorderWidth(1, WXViewUtils.getRealSubPxByWidth(borderWidth));
                    break;
                }
                case "borderRightWidth": {
                    this.getOrCreateBorder().setBorderWidth(2, WXViewUtils.getRealSubPxByWidth(borderWidth));
                    break;
                }
                case "borderBottomWidth": {
                    this.getOrCreateBorder().setBorderWidth(3, WXViewUtils.getRealSubPxByWidth(borderWidth));
                    break;
                }
                case "borderLeftWidth": {
                    this.getOrCreateBorder().setBorderWidth(0, WXViewUtils.getRealSubPxByWidth(borderWidth));
                }
            }
        }
    }

    public void setBorderStyle(String key, String borderStyle) {
        if (!TextUtils.isEmpty((CharSequence)borderStyle)) {
            switch (key) {
                case "borderStyle": {
                    this.getOrCreateBorder().setBorderStyle(8, borderStyle);
                    break;
                }
                case "borderRightStyle": {
                    this.getOrCreateBorder().setBorderStyle(2, borderStyle);
                    break;
                }
                case "borderBottomStyle": {
                    this.getOrCreateBorder().setBorderStyle(3, borderStyle);
                    break;
                }
                case "borderLeftStyle": {
                    this.getOrCreateBorder().setBorderStyle(0, borderStyle);
                    break;
                }
                case "borderTopStyle": {
                    this.getOrCreateBorder().setBorderStyle(1, borderStyle);
                }
            }
        }
    }

    public void setBorderColor(String key, String borderColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)borderColor) && (colorInt = WXResourceUtils.getColor(borderColor)) != Integer.MIN_VALUE) {
            switch (key) {
                case "borderColor": {
                    this.getOrCreateBorder().setBorderColor(8, colorInt);
                    break;
                }
                case "borderTopColor": {
                    this.getOrCreateBorder().setBorderColor(1, colorInt);
                    break;
                }
                case "borderRightColor": {
                    this.getOrCreateBorder().setBorderColor(2, colorInt);
                    break;
                }
                case "borderBottomColor": {
                    this.getOrCreateBorder().setBorderColor(3, colorInt);
                    break;
                }
                case "borderLeftColor": {
                    this.getOrCreateBorder().setBorderColor(0, colorInt);
                }
            }
        }
    }

    @Nullable
    public String getVisibility() {
        try {
            return (String)this.getDomObject().getStyles().get("visibility");
        }
        catch (Exception e) {
            return "visible";
        }
    }

    public void setVisibility(String visibility) {
        View view = this.getRealView();
        if (view != null) {
            if (TextUtils.equals((CharSequence)visibility, (CharSequence)"visible")) {
                view.setVisibility(0);
            } else if (TextUtils.equals((CharSequence)visibility, (CharSequence)"hidden")) {
                view.setVisibility(8);
            }
        }
    }

    public void registerActivityStateListener() {
        if (this.mInstance != null) {
            this.mInstance.registerActivityStateListener(this);
        }
    }

    @Override
    public void onActivityCreate() {
    }

    @Override
    public void onActivityStart() {
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    @Override
    public void onActivityStop() {
    }

    @Override
    public void onActivityDestroy() {
    }

    @Override
    public boolean onActivityBack() {
        return false;
    }

    public void destroy() {
        if (WXEnvironment.isApkDebugable() && !WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXComponent] destroy can only be called in main thread");
        }
        if (this.mHost != null && this.mHost.getLayerType() == 2) {
            this.mHost.setLayerType(0, null);
        }
        this.removeAllEvent();
        this.removeStickyStyle();
        if (this.mDomObj != null) {
            this.mDomObj.destroy();
        }
    }

    public View detachViewAndClearPreInfo() {
        T original = this.mHost;
        this.mPreRealLeft = 0;
        this.mPreRealWidth = 0;
        this.mPreRealHeight = 0;
        this.mPreRealTop = 0;
        return original;
    }

    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        View view = this.getRealView();
        pointF.set((float)view.getScrollX(), (float)view.getScrollY());
    }

    public boolean containsGesture(WXGestureType WXGestureType2) {
        return this.mGestureType != null && this.mGestureType.contains(WXGestureType2.toString());
    }

    public void notifyAppearStateChange(String wxEventType, String direction) {
        if (this.getDomObject().containsEvent("appear") || this.getDomObject().containsEvent("disappear")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("direction", direction);
            this.getInstance().fireEvent(this.getRef(), wxEventType, params, null);
        }
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public void setUsing(boolean using) {
        this.isUsing = using;
    }

    public boolean hasScrollParent(WXComponent component) {
        if (component.getParent() == null) {
            return true;
        }
        if (component.getParent() instanceof WXScroller) {
            return false;
        }
        return this.hasScrollParent(component.getParent());
    }

    @CheckResult
    protected Object convertEmptyProperty(String propName) {
        if ("backgroundColor".equals(propName)) {
            return "transparent";
        }
        return null;
    }

    static class SimpleJSCallbackCreator
    implements JSCallbackCreator {
        static SimpleJSCallbackCreator sInstance;
        String mInstanceId;

        private SimpleJSCallbackCreator() {
        }

        static JSCallbackCreator getCreatorForOnetimeUsage(String instanceId) {
            if (sInstance == null) {
                sInstance = new SimpleJSCallbackCreator();
            }
            SimpleJSCallbackCreator.sInstance.mInstanceId = instanceId;
            return sInstance;
        }

        @Override
        public JSCallback create(String callbackId) {
            return new SimpleJSCallback(this.mInstanceId, callbackId);
        }
    }

    public static class MeasureOutput {
        public int width;
        public int height;
    }

    static interface OnFocusChangeListener {
        public void onFocusChange(boolean var1);
    }

    static interface OnClickListener {
        public void onHostViewClick();
    }
}

