/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.graphics.Rect;
import com.taobao.weex.ui.component.WXComponent;

public class AppearanceHelper {
    private final WXComponent mAwareChild;
    private boolean mAppearStatus = false;
    private boolean[] mWatchFlags = new boolean[]{false, false};
    public static final int APPEAR = 0;
    public static final int DISAPPEAR = 1;
    public static final int RESULT_APPEAR = 1;
    public static final int RESULT_DISAPPEAR = -1;
    public static final int RESULT_NO_CHANGE = 0;
    private Rect mVisibleRect = new Rect();
    private int mCellPositionInScrollable;

    public AppearanceHelper(WXComponent awareChild) {
        this(awareChild, 0);
    }

    public AppearanceHelper(WXComponent awareChild, int cellPositionInScrollable) {
        this.mAwareChild = awareChild;
        this.mCellPositionInScrollable = cellPositionInScrollable;
    }

    public void setCellPosition(int pos) {
        this.mCellPositionInScrollable = pos;
    }

    public int getCellPositionINScollable() {
        return this.mCellPositionInScrollable;
    }

    public void setWatchEvent(int event, boolean enable) {
        this.mWatchFlags[event] = enable;
    }

    public boolean isWatch() {
        return this.mWatchFlags[0] || this.mWatchFlags[1];
    }

    public WXComponent getAwareChild() {
        return this.mAwareChild;
    }

    public boolean isAppear() {
        return this.mAppearStatus;
    }

    public int setAppearStatus(boolean newIsAppear) {
        if (this.mAppearStatus != newIsAppear) {
            this.mAppearStatus = newIsAppear;
            return newIsAppear ? 1 : -1;
        }
        return 0;
    }

    public boolean isViewVisible() {
        Object view = this.mAwareChild.getHostView();
        return view != null && view.getLocalVisibleRect(this.mVisibleRect);
    }
}

