/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class WXDomObject
extends CSSNode
implements Cloneable {
    public static final String TAG = WXDomObject.class.getSimpleName();
    public static final String ROOT = "_root";
    public static final String GOD = "god";
    public static final String TRANSFORM = "transform";
    public static final String TRANSFORM_ORIGIN = "transformOrigin";
    private AtomicBoolean sDestroy = new AtomicBoolean();
    @Deprecated
    public String ref = "_root";
    @Deprecated
    public String type = "div";
    @Deprecated
    public WXStyle style;
    @Deprecated
    public WXAttr attr;
    @Deprecated
    public WXEvent event;
    @Deprecated
    public List<WXDomObject> children;
    @Deprecated
    public WXDomObject parent;
    private ArrayList<String> fixedStyleRefs;
    private boolean mYoung = false;
    private boolean isModifyHeight;
    private boolean isModifyWidth;

    public boolean isModifyHeight() {
        return this.isModifyHeight;
    }

    public void setModifyHeight(boolean isModifyHeight) {
        this.isModifyHeight = isModifyHeight;
    }

    public boolean isModifyWidth() {
        return this.isModifyWidth;
    }

    public String getRef() {
        return this.ref;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public WXStyle getStyles() {
        if (this.style == null) {
            this.style = new WXStyle();
        }
        return this.style;
    }

    @NonNull
    public WXAttr getAttrs() {
        if (this.attr == null) {
            this.attr = new WXAttr();
        }
        return this.attr;
    }

    @NonNull
    public WXEvent getEvents() {
        if (this.event == null) {
            this.event = new WXEvent();
        }
        return this.event;
    }

    public void clearEvents() {
        if (this.event != null) {
            this.event.clear();
        }
    }

    public static void prepareRoot(WXDomObject obj) {
        obj.ref = ROOT;
    }

    public static void prepareGod(WXDomObject obj) {
        obj.ref = GOD;
        obj.type = "div";
    }

    protected final void copyFields(WXDomObject dest) {
        dest.cssstyle.copy(this.cssstyle);
        dest.setModifyHeight(this.isModifyHeight);
        dest.setModifyWidth(this.isModifyWidth);
        dest.ref = this.ref;
        dest.type = this.type;
        dest.style = this.style;
        dest.attr = this.attr;
        dest.event = this.event == null ? null : this.event.clone();
        dest.csslayout.copy(this.csslayout);
    }

    public void parseFromJson(JSONObject map) {
        Object event;
        Object attr;
        String type;
        if (map == null || map.size() <= 0) {
            return;
        }
        this.type = type = (String)map.get((Object)"type");
        this.ref = (String)map.get((Object)"ref");
        Object style = map.get((Object)"style");
        if (style != null && style instanceof JSONObject) {
            WXStyle styles = new WXStyle();
            WXJsonUtils.putAll(styles, (JSONObject)style);
            this.style = styles;
        }
        if ((attr = map.get((Object)"attr")) != null && attr instanceof JSONObject) {
            WXAttr attrs = new WXAttr();
            WXJsonUtils.putAll(attrs, (JSONObject)attr);
            this.attr = attrs;
        }
        if ((event = map.get((Object)"event")) != null && event instanceof JSONArray) {
            WXEvent events = new WXEvent();
            JSONArray eventArray = (JSONArray)event;
            int count = eventArray.size();
            for (int i = 0; i < count; ++i) {
                events.add(eventArray.getString(i));
            }
            this.event = events;
        }
    }

    public void setModifyWidth(boolean isModifyWidth) {
        this.isModifyWidth = isModifyWidth;
    }

    public void layoutBefore() {
    }

    public void layoutAfter() {
    }

    public final boolean hasUpdate() {
        return this.hasNewLayout() || this.isDirty();
    }

    void young() {
        this.mYoung = true;
    }

    void old() {
        this.mYoung = false;
    }

    boolean isYoung() {
        return this.mYoung;
    }

    public final void markUpdateSeen() {
        if (this.hasNewLayout()) {
            this.markLayoutSeen();
        }
    }

    public boolean isFixed() {
        return this.style == null ? false : this.style.isFixed();
    }

    public Object getExtra() {
        return null;
    }

    public void remove(WXDomObject child) {
        if (child == null || this.children == null || this.sDestroy.get()) {
            return;
        }
        int index = this.children.indexOf(child);
        this.removeFromDom(child);
        if (index != -1) {
            super.removeChildAt(index);
        }
    }

    public void removeFromDom(WXDomObject child) {
        if (child == null || this.children == null || this.sDestroy.get()) {
            return;
        }
        int index = this.children.indexOf(child);
        if (index == -1) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXDomObject] remove function error");
            }
            return;
        }
        this.children.remove((int)index).parent = null;
    }

    public int index(WXDomObject child) {
        if (child == null || this.children == null || this.sDestroy.get()) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    public void add(WXDomObject child, int index) {
        int count;
        if (child == null || index < -1 || this.sDestroy.get()) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList<WXDomObject>();
        }
        int n = index = index >= (count = this.children.size()) ? -1 : index;
        if (index == -1) {
            this.children.add(child);
            super.addChildAt(child, super.getChildCount());
        } else {
            this.children.add(index, child);
            super.addChildAt(child, index);
        }
        child.parent = this;
    }

    @Deprecated
    public void add2Dom(WXDomObject child, int index) {
        if (child == null || index < -1 || this.sDestroy.get()) {
            return;
        }
        int count = super.getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            super.addChildAt(child, super.getChildCount());
        } else {
            super.addChildAt(child, index);
        }
        child.parent = this;
    }

    public WXDomObject getChild(int index) {
        if (this.children == null || this.sDestroy.get()) {
            return null;
        }
        return this.children.get(index);
    }

    public void addEvent(String e) {
        if (TextUtils.isEmpty((CharSequence)e)) {
            return;
        }
        if (this.event == null) {
            this.event = new WXEvent();
        }
        if (this.containsEvent(e)) {
            return;
        }
        this.event.add(e);
    }

    public boolean containsEvent(String e) {
        if (this.event == null) {
            return false;
        }
        return this.event.contains(e);
    }

    public void removeEvent(String e) {
        if (TextUtils.isEmpty((CharSequence)e)) {
            return;
        }
        if (this.event == null) {
            return;
        }
        this.event.remove(e);
    }

    public void updateAttr(Map<String, Object> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        if (this.attr == null) {
            this.attr = new WXAttr();
        }
        this.attr.putAll(attrs);
        super.dirty();
    }

    public void updateStyle(Map<String, Object> styles) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        if (this.style == null) {
            this.style = new WXStyle();
        }
        this.style.putAll(styles);
        super.dirty();
    }

    public void applyStyleToNode() {
        WXStyle stylesMap = this.getStyles();
        if (!stylesMap.isEmpty()) {
            this.setAlignItems(stylesMap.getAlignItems());
            this.setAlignSelf(stylesMap.getAlignSelf());
            this.setFlex(stylesMap.getFlex());
            this.setFlexDirection(stylesMap.getFlexDirection());
            this.setJustifyContent(stylesMap.getJustifyContent());
            this.setWrap(stylesMap.getCSSWrap());
            this.setMinWidth(WXViewUtils.getRealPxByWidth(stylesMap.getMinWidth()));
            this.setMaxWidth(WXViewUtils.getRealPxByWidth(stylesMap.getMaxWidth()));
            this.setMinHeight(WXViewUtils.getRealPxByWidth(stylesMap.getMinHeight()));
            this.setMaxHeight(WXViewUtils.getRealPxByWidth(stylesMap.getMaxHeight()));
            this.setMargin(0, WXViewUtils.getRealPxByWidth(stylesMap.getMarginLeft()));
            this.setMargin(1, WXViewUtils.getRealPxByWidth(stylesMap.getMarginTop()));
            this.setMargin(2, WXViewUtils.getRealPxByWidth(stylesMap.getMarginRight()));
            this.setMargin(3, WXViewUtils.getRealPxByWidth(stylesMap.getMarginBottom()));
            this.setPadding(0, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingLeft()));
            this.setPadding(1, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingTop()));
            this.setPadding(2, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingRight()));
            this.setPadding(3, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingBottom()));
            this.setPositionType(stylesMap.getPosition());
            this.setPositionLeft(WXViewUtils.getRealPxByWidth(stylesMap.getLeft()));
            this.setPositionTop(WXViewUtils.getRealPxByWidth(stylesMap.getTop()));
            this.setPositionRight(WXViewUtils.getRealPxByWidth(stylesMap.getRight()));
            this.setPositionBottom(WXViewUtils.getRealPxByWidth(stylesMap.getBottom()));
            this.setBorder(1, WXViewUtils.getRealPxByWidth(stylesMap.getBorderTopWidth()));
            this.setBorder(2, WXViewUtils.getRealPxByWidth(stylesMap.getBorderRightWidth()));
            this.setBorder(3, WXViewUtils.getRealPxByWidth(stylesMap.getBorderBottomWidth()));
            this.setBorder(0, WXViewUtils.getRealPxByWidth(stylesMap.getBorderLeftWidth()));
            this.setStyleHeight(WXViewUtils.getRealPxByWidth(stylesMap.getHeight()));
            this.setStyleWidth(WXViewUtils.getRealPxByWidth(stylesMap.getWidth()));
        }
    }

    public int childCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    public boolean isVisible() {
        return super.isShow();
    }

    public WXDomObject clone() {
        WXDomObject dom;
        block3: {
            if (this.sDestroy.get()) {
                return null;
            }
            dom = null;
            try {
                dom = new WXDomObject();
                this.copyFields(dom);
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block3;
                WXLogUtils.e("WXDomObject clone error: ", e);
            }
        }
        return dom;
    }

    public void destroy() {
        this.sDestroy.set(true);
        if (this.style != null) {
            this.style.clear();
        }
        if (this.attr != null) {
            this.attr.clear();
        }
        if (this.event != null) {
            this.event.clear();
        }
        if (this.children != null) {
            int count = this.children.size();
            for (int i = 0; i < count; ++i) {
                this.children.get(i).destroy();
            }
            this.children.clear();
        }
    }

    protected Map<String, String> getDefaultStyle() {
        return null;
    }

    public ArrayList<String> getFixedStyleRefs() {
        return this.fixedStyleRefs;
    }

    public void add2FixedDomList(String ref) {
        if (this.fixedStyleRefs == null) {
            this.fixedStyleRefs = new ArrayList();
        }
        this.fixedStyleRefs.add(ref);
    }

    public String dumpDomTree() {
        return this.ref + ": " + this.toString();
    }
}

