/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.navigator;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.utils.WXLogUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class WXNavigatorModule
extends WXModule {
    public static final String MSG_SUCCESS = "WX_SUCCESS";
    public static final String MSG_FAILED = "WX_FAILED";
    private static final String INSTANCE_ID = "instanceId";
    private static final String TAG = "Navigator";
    private static final String WEEX = "com.taobao.android.intent.category.WEEX";
    private static final String URL = "url";

    @WXModuleAnno
    public void push(String param, String callbackId) {
        if (!TextUtils.isEmpty((CharSequence)param)) {
            if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().push(param)) {
                WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
                return;
            }
            try {
                JSONObject jsonObject = new JSONObject(param);
                String url = jsonObject.optString(URL, "");
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    Uri rawUri = Uri.parse((String)url);
                    String scheme = rawUri.getScheme();
                    Uri.Builder builder = rawUri.buildUpon();
                    if (TextUtils.isEmpty((CharSequence)scheme)) {
                        builder.scheme("http");
                    }
                    Intent intent = new Intent("android.intent.action.VIEW", builder.build());
                    intent.addCategory(WEEX);
                    intent.putExtra(INSTANCE_ID, this.mWXSDKInstance.getInstanceId());
                    this.mWXSDKInstance.getContext().startActivity(intent);
                    WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
                }
            }
            catch (Exception e) {
                WXLogUtils.eTag(TAG, e);
                WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
            }
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void pop(String param, String callbackId) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().pop(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            ((Activity)this.mWXSDKInstance.getContext()).finish();
        }
    }

    @WXModuleAnno
    public void setNavBarRightItem(String param, String callbackId) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarRightItem(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void clearNavBarRightItem(String param, String callbackId) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().clearNavBarRightItem(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void setNavBarLeftItem(String param, String callbackId) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarLeftItem(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void clearNavBarLeftItem(String param, String callbackId) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().clearNavBarLeftItem(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void setNavBarMoreItem(String param, String callbackId) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarMoreItem(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void clearNavBarMoreItem(String param, String callbackId) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().clearNavBarMoreItem(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void setNavBarTitle(String param, String callbackId) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarTitle(param)) {
            WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_SUCCESS);
            return;
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callbackId, MSG_FAILED);
    }

    @WXModuleAnno
    public void setNavBarHidden(String param, String callback) {
        String message = MSG_FAILED;
        try {
            JSONObject jsObj = new JSONObject(param);
            int visibility = jsObj.getInt("hidden");
            boolean success = this.changeVisibilityOfActionBar(this.mWXSDKInstance.getContext(), visibility);
            if (success) {
                message = MSG_SUCCESS;
            }
        }
        catch (JSONException e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callback, message);
    }

    private boolean changeVisibilityOfActionBar(Context context, int visibility) {
        ActionBar actionbar;
        boolean result = false;
        if (this.mWXSDKInstance.getContext() instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionbar2 = ((AppCompatActivity)this.mWXSDKInstance.getContext()).getSupportActionBar();
            if (actionbar2 != null) {
                switch (visibility) {
                    case 1: {
                        actionbar2.hide();
                        result = true;
                        break;
                    }
                    case 0: {
                        actionbar2.show();
                        result = true;
                    }
                }
            }
        } else if (this.mWXSDKInstance.getContext() instanceof Activity && (actionbar = ((Activity)this.mWXSDKInstance.getContext()).getActionBar()) != null) {
            switch (visibility) {
                case 1: {
                    actionbar.hide();
                    result = true;
                    break;
                }
                case 0: {
                    actionbar.show();
                    result = true;
                }
            }
        }
        return result;
    }
}

