/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXGlobalEventReceiver;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.http.WXHttpUtil;
import com.taobao.weex.ui.component.NestedContainer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WXSDKInstance
implements IWXActivityStateListener,
View.OnLayoutChangeListener {
    public boolean mEnd = false;
    public static final String BUNDLE_URL = "bundleUrl";
    protected IWXUserTrackAdapter mUserTrackAdapter;
    protected IWXHttpAdapter mWXHttpAdapter;
    private IWXRenderListener mRenderListener;
    Context mContext;
    volatile String mInstanceId;
    private WXComponent mGodCom;
    private boolean mRendered;
    private WXRefreshData mLastRefreshData;
    private float refreshMargin = 0.0f;
    private NestedInstanceInterceptor mNestedInstanceInterceptor;
    private String mBundleUrl = "";
    private boolean isDestroy = false;
    private Map<String, Serializable> mUserTrackParams;
    private boolean isCommit = false;
    private WXGlobalEventReceiver mGlobalEventReceiver = null;
    private WXRenderStrategy mRenderStrategy = WXRenderStrategy.APPEND_ASYNC;
    private int mGodViewWidth = -1;
    private int mGodViewHeight = -1;
    private long mRenderStartTime;
    private long mRefreshStartTime;
    private ConcurrentLinkedQueue<IWXActivityStateListener> mActivityStateListeners = new ConcurrentLinkedQueue();
    private WXPerformance mWXPerformance;
    private ScrollView mScrollView;
    private WXScrollView.WXScrollViewListener mWXScrollViewListener;
    private List<OnWXScrollListener> mWXScrollListeners;
    private ViewGroup rootView;
    private int mMaxDeepLayer;
    private List<OnInstanceVisibleListener> mVisibleListeners = new ArrayList<OnInstanceVisibleListener>();
    private boolean mCreateInstance = true;
    private HashMap<String, List<String>> mGlobalEvents = new HashMap();

    public WXSDKInstance(Context context) {
        this.init(context);
    }

    public WXComponent getGodCom() {
        return this.mGodCom;
    }

    public WXComponent getRootCom() {
        if (this.getGodCom() == null) {
            return null;
        }
        return ((WXVContainer)this.getGodCom()).getChild(0);
    }

    public void setNestedInstanceInterceptor(NestedInstanceInterceptor interceptor) {
        this.mNestedInstanceInterceptor = interceptor;
    }

    public WXSDKInstance createNestedInstance(NestedContainer container) {
        WXSDKInstance sdkInstance = new WXSDKInstance(this.mContext);
        if (this.mNestedInstanceInterceptor != null) {
            this.mNestedInstanceInterceptor.onCreateNestInstance(sdkInstance, container);
        }
        return sdkInstance;
    }

    public void addOnInstanceVisibleListener(OnInstanceVisibleListener l) {
        this.mVisibleListeners.add(l);
    }

    public void removeOnInstanceVisibleListener(OnInstanceVisibleListener l) {
        this.mVisibleListeners.remove(l);
    }

    public void init(Context context) {
        this.mContext = context;
        this.mWXPerformance = new WXPerformance();
        this.mWXPerformance.WXSDKVersion = WXEnvironment.WXSDK_VERSION;
        this.mWXPerformance.JSLibInitTime = WXEnvironment.sJSLibInitTime;
        this.mUserTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
        this.mWXHttpAdapter = WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public void setBizType(String bizType) {
        if (!TextUtils.isEmpty((CharSequence)bizType)) {
            this.mWXPerformance.bizType = bizType;
        }
    }

    public ScrollView getScrollView() {
        return this.mScrollView;
    }

    public void setRootScrollView(ScrollView scrollView) {
        this.mScrollView = scrollView;
        if (this.mWXScrollViewListener != null) {
            ((WXScrollView)this.mScrollView).addScrollViewListener(this.mWXScrollViewListener);
        }
    }

    @Deprecated
    public void registerScrollViewListener(WXScrollView.WXScrollViewListener scrollViewListener) {
        this.mWXScrollViewListener = scrollViewListener;
    }

    @Deprecated
    public WXScrollView.WXScrollViewListener getScrollViewListener() {
        return this.mWXScrollViewListener;
    }

    @Deprecated
    public void setIWXUserTrackAdapter(IWXUserTrackAdapter adapter) {
    }

    public void render(String template, Map<String, Object> options, String jsonInitData) {
        this.render(template, options, jsonInitData, WXRenderStrategy.APPEND_ASYNC);
    }

    public void render(String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.render("default", template, options, jsonInitData, -1, -1, flag);
    }

    public void render(String pageName, String template, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        if (this.mRendered || TextUtils.isEmpty((CharSequence)template)) {
            return;
        }
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        if (WXEnvironment.sDynamicMode && !TextUtils.isEmpty((CharSequence)WXEnvironment.sDynamicUrl) && options != null && options.get("dynamicMode") == null) {
            options.put("dynamicMode", "true");
            this.renderByUrl(pageName, WXEnvironment.sDynamicUrl, options, jsonInitData, width, height, flag);
            return;
        }
        this.mWXPerformance.pageName = pageName;
        this.mWXPerformance.JSTemplateSize = template.length() / 1024;
        this.mRenderStartTime = System.currentTimeMillis();
        this.mRenderStrategy = flag;
        this.mGodViewWidth = width;
        this.mGodViewHeight = height;
        this.mInstanceId = WXSDKManager.getInstance().generateInstanceId();
        WXSDKManager.getInstance().createInstance(this, template, options, jsonInitData);
        this.mRendered = true;
        if (TextUtils.isEmpty((CharSequence)this.mBundleUrl)) {
            this.mBundleUrl = pageName;
        }
    }

    public void render(String template, int width, int height) {
        this.render("default", template, null, null, width, height, this.mRenderStrategy);
    }

    public void renderByUrl(String pageName, String url, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        Uri uri;
        pageName = this.wrapPageName(pageName, url);
        this.mBundleUrl = url;
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        if (!options.containsKey(BUNDLE_URL)) {
            options.put(BUNDLE_URL, url);
        }
        if ((uri = Uri.parse((String)url)) != null && TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file")) {
            this.render(pageName, WXFileUtils.loadAsset(this.assembleFilePath(uri), this.mContext), options, jsonInitData, width, height, flag);
            return;
        }
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        WXRequest wxRequest = new WXRequest();
        wxRequest.url = this.rewriteUri(Uri.parse((String)url), "bundle").toString();
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, String>();
        }
        wxRequest.paramMap.put("user-agent", WXHttpUtil.assembleUserAgent(this.mContext, WXEnvironment.getConfig()));
        adapter.sendRequest(wxRequest, new WXHttpListener(pageName, options, jsonInitData, width, height, flag, System.currentTimeMillis()));
        this.mWXHttpAdapter = adapter;
    }

    private String wrapPageName(String pageName, String url) {
        if (TextUtils.equals((CharSequence)pageName, (CharSequence)"default")) {
            pageName = url;
            try {
                Uri uri = Uri.parse((String)url);
                if (uri != null) {
                    Uri.Builder builder = new Uri.Builder();
                    builder.scheme(uri.getScheme());
                    builder.authority(uri.getAuthority());
                    builder.path(uri.getPath());
                    pageName = builder.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pageName;
    }

    private String assembleFilePath(Uri uri) {
        if (uri != null && uri.getPath() != null) {
            return uri.getPath().replaceFirst("/", "");
        }
        return "";
    }

    public void refreshInstance(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.refreshInstance(WXJsonUtils.fromObjectToJSONString(data));
    }

    public void refreshInstance(String jsonData) {
        if (jsonData == null) {
            return;
        }
        this.mRefreshStartTime = System.currentTimeMillis();
        if (this.mLastRefreshData != null) {
            this.mLastRefreshData.isDirty = true;
        }
        this.mLastRefreshData = new WXRefreshData(jsonData, false);
        WXSDKManager.getInstance().refreshInstance(this.mInstanceId, this.mLastRefreshData);
    }

    public WXRenderStrategy getRenderStrategy() {
        return this.mRenderStrategy;
    }

    public String getInstanceId() {
        return this.mInstanceId;
    }

    public Context getContext() {
        if (this.mContext == null) {
            WXLogUtils.e("WXSdkInstance mContext == null");
        }
        return this.mContext;
    }

    public int getWeexHeight() {
        return this.mGodViewHeight;
    }

    public int getWeexWidth() {
        return this.mGodViewWidth;
    }

    public IWXImgLoaderAdapter getImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    public URIAdapter getURIAdapter() {
        return WXSDKManager.getInstance().getURIAdapter();
    }

    public Uri rewriteUri(Uri uri, String type) {
        return this.getURIAdapter().rewrite(this, type, uri);
    }

    @Deprecated
    public void setImgLoaderAdapter(IWXImgLoaderAdapter adapter) {
    }

    public IWXHttpAdapter getWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public void reloadImages() {
        if (this.mScrollView == null) {
            return;
        }
    }

    public void registerRenderListener(IWXRenderListener listener) {
        this.mRenderListener = listener;
    }

    public void registerActivityStateListener(IWXActivityStateListener listener) {
        if (listener == null || this.mActivityStateListeners == null) {
            return;
        }
        if (this.mActivityStateListeners == null) {
            this.mActivityStateListeners = new ConcurrentLinkedQueue();
        }
        if (!this.mActivityStateListeners.contains(listener)) {
            this.mActivityStateListeners.add(listener);
        }
    }

    @Override
    public void onActivityCreate() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityCreate();
        }
        this.mGlobalEventReceiver = new WXGlobalEventReceiver(this);
        this.getContext().registerReceiver((BroadcastReceiver)this.mGlobalEventReceiver, new IntentFilter("wx_global_action"));
    }

    @Override
    public void onActivityStart() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityStart();
        }
    }

    @Override
    public void onActivityPause() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityPause();
        }
        this.onViewDisappear();
        if (!this.isCommit) {
            Set<String> componentTypes = WXComponentFactory.getComponentTypesByInstanceId(this.getInstanceId());
            if (componentTypes != null && componentTypes.contains("scroller")) {
                this.mWXPerformance.useScroller = 1;
            }
            this.mWXPerformance.maxDeepViewLayer = this.getMaxDeepLayer();
            if (this.mUserTrackAdapter != null) {
                this.mUserTrackAdapter.commit(this.mContext, null, "load", this.mWXPerformance, this.getUserTrackParams());
            }
            this.isCommit = true;
        }
    }

    public void onViewDisappear() {
        WXComponent comp = this.getRootCom();
        if (comp != null) {
            WXBridgeManager.getInstance().fireEvent(this.mInstanceId, comp.getRef(), "viewdisappear", null, null);
            for (OnInstanceVisibleListener instance : this.mVisibleListeners) {
                instance.onDisappear();
            }
        }
    }

    public void onViewAppear() {
        WXComponent comp = this.getRootCom();
        if (comp != null) {
            WXBridgeManager.getInstance().fireEvent(this.mInstanceId, comp.getRef(), "viewappear", null, null);
            for (OnInstanceVisibleListener instance : this.mVisibleListeners) {
                instance.onAppear();
            }
        }
    }

    @Override
    public void onActivityResume() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityResume();
        }
        this.onViewAppear();
    }

    @Override
    public void onActivityStop() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityStop();
        }
    }

    @Override
    public void onActivityDestroy() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityDestroy();
        }
        this.destroy();
    }

    @Override
    public boolean onActivityBack() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            boolean isIntercept = listener.onActivityBack();
            if (!isIntercept) continue;
            return true;
        }
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        WXModuleManager.onActivityResult(this.getInstanceId(), requestCode, resultCode, data);
    }

    public void onViewCreated(final WXComponent component) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mGodCom = component;
                        WXSDKInstance.this.onViewAppear();
                        Object wxView = component.getHostView();
                        if (WXEnvironment.isApkDebugable() && WXSDKManager.getInstance().getIWXDebugAdapter() != null) {
                            wxView = WXSDKManager.getInstance().getIWXDebugAdapter().wrapContainer(WXSDKInstance.this, (View)wxView);
                        }
                        WXSDKInstance.this.mRenderListener.onViewCreated(WXSDKInstance.this, (View)wxView);
                    }
                }
            });
        }
    }

    public void onUpdateFinish() {
        WXLogUtils.d("Instance onUpdateSuccess");
    }

    public void runOnUiThread(Runnable action) {
        WXSDKManager.getInstance().postOnUiThread(action, 0L);
    }

    public void onRenderSuccess(final int width, final int height) {
        this.firstScreenRenderFinished();
        long time = System.currentTimeMillis() - this.mRenderStartTime;
        WXLogUtils.renderPerformanceLog("onRenderSuccess", time);
        WXLogUtils.renderPerformanceLog("   invokeCreateInstance", this.mWXPerformance.communicateTime);
        WXLogUtils.renderPerformanceLog("   TotalCallNativeTime", this.mWXPerformance.callNativeTime);
        WXLogUtils.renderPerformanceLog("       TotalJsonParseTime", this.mWXPerformance.parseJsonTime);
        WXLogUtils.renderPerformanceLog("   TotalBatchTime", this.mWXPerformance.batchTime);
        WXLogUtils.renderPerformanceLog("       TotalCssLayoutTime", this.mWXPerformance.cssLayoutTime);
        WXLogUtils.renderPerformanceLog("       TotalApplyUpdateTime", this.mWXPerformance.applyUpdateTime);
        WXLogUtils.renderPerformanceLog("       TotalUpdateDomObjTime", this.mWXPerformance.updateDomObjTime);
        this.mWXPerformance.totalTime = time;
        if ((double)this.mWXPerformance.screenRenderTime < 0.001) {
            this.mWXPerformance.screenRenderTime = time;
        }
        this.mWXPerformance.componentCount = WXComponent.mComponentNum;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("weex_perf", "mComponentNum:" + WXComponent.mComponentNum);
        }
        WXComponent.mComponentNum = 0;
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onRenderSuccess(WXSDKInstance.this, width, height);
                        if (WXSDKInstance.this.mUserTrackAdapter != null) {
                            WXPerformance performance = new WXPerformance();
                            performance.errCode = WXErrorCode.WX_SUCCESS.getErrorCode();
                            performance.args = WXSDKInstance.this.getBundleUrl();
                            WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.mContext, null, "jsBridge", performance, WXSDKInstance.this.getUserTrackParams());
                        }
                        if (WXEnvironment.isApkDebugable()) {
                            WXLogUtils.d("weex_perf", WXSDKInstance.this.mWXPerformance.toString());
                        }
                    }
                }
            });
        }
        if (!WXEnvironment.isApkDebugable()) {
            Log.e((String)"weex_perf", (String)this.mWXPerformance.getPerfData());
        }
    }

    public void onRefreshSuccess(final int width, final int height) {
        WXLogUtils.renderPerformanceLog("onRefreshSuccess", System.currentTimeMillis() - this.mRefreshStartTime);
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onRefreshSuccess(WXSDKInstance.this, width, height);
                    }
                }
            });
        }
    }

    public void onRenderError(final String errCode, final String msg) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, msg);
                    }
                }
            });
        }
    }

    public void onJSException(final String errCode, final String function, final String exception) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(function);
                        builder.append(exception);
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, builder.toString());
                    }
                }
            });
        }
    }

    public final void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.onLayoutChange(v);
        }
    }

    public void onLayoutChange(View godView) {
    }

    public void firstScreenCreateInstanceTime(long time) {
        if (this.mCreateInstance) {
            this.mWXPerformance.firstScreenJSFExecuteTime = time - this.mRenderStartTime;
            this.mCreateInstance = false;
        }
    }

    public void callNativeTime(long time) {
        this.mWXPerformance.callNativeTime += time;
    }

    public void jsonParseTime(long time) {
        this.mWXPerformance.parseJsonTime += time;
    }

    public void firstScreenRenderFinished() {
        if (this.mEnd) {
            return;
        }
        this.mEnd = true;
        this.mWXPerformance.screenRenderTime = System.currentTimeMillis() - this.mRenderStartTime;
        WXLogUtils.renderPerformanceLog("firstScreenRenderFinished", this.mWXPerformance.screenRenderTime);
        WXLogUtils.renderPerformanceLog("   firstScreenJSFExecuteTime", this.mWXPerformance.firstScreenJSFExecuteTime);
        WXLogUtils.renderPerformanceLog("   firstScreenCallNativeTime", this.mWXPerformance.callNativeTime);
        WXLogUtils.renderPerformanceLog("       firstScreenJsonParseTime", this.mWXPerformance.parseJsonTime);
        WXLogUtils.renderPerformanceLog("   firstScreenBatchTime", this.mWXPerformance.batchTime);
        WXLogUtils.renderPerformanceLog("       firstScreenCssLayoutTime", this.mWXPerformance.cssLayoutTime);
        WXLogUtils.renderPerformanceLog("       firstScreenApplyUpdateTime", this.mWXPerformance.applyUpdateTime);
        WXLogUtils.renderPerformanceLog("       firstScreenUpdateDomObjTime", this.mWXPerformance.updateDomObjTime);
    }

    public void batchTime(long time) {
        this.mWXPerformance.batchTime += time;
    }

    public void cssLayoutTime(long time) {
        this.mWXPerformance.cssLayoutTime += time;
    }

    public void applyUpdateTime(long time) {
        this.mWXPerformance.applyUpdateTime += time;
    }

    public void updateDomObjTime(long time) {
        this.mWXPerformance.updateDomObjTime += time;
    }

    public void createInstanceFinished(long time) {
        if (time > 0L) {
            this.mWXPerformance.communicateTime = time;
        }
    }

    public void commitUTStab(final String type, final WXErrorCode errorCode) {
        if (this.mUserTrackAdapter == null || TextUtils.isEmpty((CharSequence)type) || errorCode == null) {
            return;
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WXPerformance performance = new WXPerformance();
                performance.errCode = errorCode.getErrorCode();
                performance.args = errorCode.getArgs();
                if (errorCode != WXErrorCode.WX_SUCCESS) {
                    performance.errMsg = errorCode.getErrorMsg();
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d(performance.toString());
                    }
                }
                if (WXSDKInstance.this.mUserTrackAdapter != null) {
                    WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.mContext, null, type, performance, WXSDKInstance.this.getUserTrackParams());
                }
            }
        });
    }

    private void destroyView(View rootView) {
        try {
            if (rootView instanceof ViewGroup) {
                ViewGroup cViewGroup = (ViewGroup)rootView;
                for (int index = 0; index < cViewGroup.getChildCount(); ++index) {
                    this.destroyView(cViewGroup.getChildAt(index));
                }
                cViewGroup.removeViews(0, ((ViewGroup)rootView).getChildCount());
                WXReflectionUtils.setValue(rootView, "mChildrenCount", 0);
            }
            if (rootView instanceof Destroyable) {
                ((Destroyable)rootView).destroy();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("WXSDKInstance destroyView Exception: ", e);
        }
    }

    public synchronized void destroy() {
        WXSDKManager.getInstance().destroyInstance(this.mInstanceId);
        WXComponentFactory.removeComponentTypesByInstanceId(this.getInstanceId());
        if (this.mGlobalEventReceiver != null) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mGlobalEventReceiver);
            this.mGlobalEventReceiver = null;
        }
        if (this.mGodCom != null && this.mGodCom.getHostView() != null) {
            this.mGodCom.getRealView().removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            this.mGodCom.destroy();
            this.destroyView((View)this.mGodCom.getHostView());
            this.mGodCom = null;
        }
        if (this.mActivityStateListeners != null) {
            this.mActivityStateListeners.clear();
            this.mActivityStateListeners = null;
        }
        if (this.mGlobalEvents != null) {
            this.mGlobalEvents.clear();
        }
        this.mNestedInstanceInterceptor = null;
        this.mUserTrackAdapter = null;
        this.mWXHttpAdapter = null;
        this.rootView = null;
        this.mScrollView = null;
        this.mContext = null;
        this.mRenderListener = null;
        this.isDestroy = true;
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    public String getBundleUrl() {
        return this.mBundleUrl;
    }

    public void setBundleUrl(String url) {
        this.mBundleUrl = url;
    }

    public ViewGroup getRootView() {
        return this.rootView;
    }

    public void setRootView(ViewGroup rootView) {
        this.rootView = rootView;
    }

    public synchronized List<OnWXScrollListener> getWXScrollListeners() {
        return this.mWXScrollListeners;
    }

    public synchronized void registerOnWXScrollListener(OnWXScrollListener wxScrollListener) {
        if (this.mWXScrollListeners == null) {
            this.mWXScrollListeners = new ArrayList<OnWXScrollListener>();
        }
        this.mWXScrollListeners.add(wxScrollListener);
    }

    public float getRefreshMargin() {
        return this.refreshMargin;
    }

    public void setRefreshMargin(float refreshMargin) {
        this.refreshMargin = refreshMargin;
    }

    private void updateRootComponentStyle(JSONObject style) {
        Message message = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.getInstanceId();
        if (task.args == null) {
            task.args = new ArrayList<Object>();
        }
        task.args.add("_root");
        task.args.add(style);
        message.obj = task;
        message.what = 2;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(message);
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams layoutParams;
        Object godView;
        if (width < 0 || height < 0) {
            return;
        }
        this.mGodViewWidth = width;
        this.mGodViewHeight = height;
        float realWidth = WXViewUtils.getWebPxByWidth(width);
        float realHeight = WXViewUtils.getWebPxByWidth(height);
        if (this.mGodCom != null && (godView = this.mGodCom.getHostView()) != null && (layoutParams = godView.getLayoutParams()) != null) {
            layoutParams.width = width;
            layoutParams.height = height;
            godView.setLayoutParams(layoutParams);
            JSONObject style = new JSONObject();
            if (this.mGodCom instanceof WXVContainer) {
                WXComponent rootComponent = ((WXVContainer)this.mGodCom).getChild(0);
                if (rootComponent != null && rootComponent.getDomObject() != null && rootComponent.getDomObject().isModifyHeight()) {
                    style.put("height", (Object)Float.valueOf(realHeight));
                }
                if (rootComponent != null && rootComponent.getDomObject() != null && rootComponent.getDomObject().isModifyWidth()) {
                    style.put("width", (Object)Float.valueOf(realWidth));
                }
                this.updateRootComponentStyle(style);
            }
        }
    }

    public void fireGlobalEventCallback(String eventName, Map<String, Object> params) {
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks != null) {
            for (String callback : callbacks) {
                WXSDKManager.getInstance().callback(this.mInstanceId, callback, params, true);
            }
        }
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        WXBridgeManager.getInstance().fireEventOnNode(this.getInstanceId(), elementRef, type, data, domChanges);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data) {
        this.fireEvent(elementRef, type, data, null);
    }

    public void fireEvent(String ref, String type) {
        this.fireEvent(ref, type, new HashMap<String, Object>());
    }

    protected void addEventListener(String eventName, String callback) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks == null) {
            callbacks = new ArrayList<String>();
            this.mGlobalEvents.put(eventName, callbacks);
        }
        callbacks.add(callback);
    }

    protected void removeEventListener(String eventName, String callback) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks != null) {
            callbacks.remove(callback);
        }
    }

    protected void removeEventListener(String eventName) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        this.mGlobalEvents.remove(eventName);
    }

    public void fireModuleEvent(String callback, Map<String, Object> params, boolean isOnce) {
        WXSDKManager.getInstance().callback(this.getInstanceId(), callback, params, isOnce);
    }

    public Map<String, Serializable> getUserTrackParams() {
        return this.mUserTrackParams;
    }

    public void addUserTrackParameter(String key, Serializable value) {
        if (this.mUserTrackParams == null) {
            this.mUserTrackParams = new ConcurrentHashMap<String, Serializable>();
        }
        this.mUserTrackParams.put(key, value);
    }

    public void clearUserTrackParameters() {
        if (this.mUserTrackParams != null) {
            this.mUserTrackParams.clear();
        }
    }

    public void removeUserTrackParameter(String key) {
        if (this.mUserTrackParams != null) {
            this.mUserTrackParams.remove(key);
        }
    }

    public int getMaxDeepLayer() {
        return this.mMaxDeepLayer;
    }

    public void setMaxDeepLayer(int maxDeepLayer) {
        this.mMaxDeepLayer = maxDeepLayer;
    }

    public static interface NestedInstanceInterceptor {
        public void onCreateNestInstance(WXSDKInstance var1, NestedContainer var2);
    }

    class WXHttpListener
    implements IWXHttpAdapter.OnHttpListener {
        private String pageName;
        private Map<String, Object> options;
        private String jsonInitData;
        private int width;
        private int height;
        private WXRenderStrategy flag;
        private long startRequestTime;

        private WXHttpListener(String pageName, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag, long startRequestTime) {
            this.pageName = pageName;
            this.options = options;
            this.jsonInitData = jsonInitData;
            this.width = width;
            this.height = height;
            this.flag = flag;
            this.startRequestTime = startRequestTime;
        }

        @Override
        public void onHttpStart() {
        }

        @Override
        public void onHeadersReceived(int statusCode, Map<String, List<String>> headers) {
        }

        @Override
        public void onHttpUploadProgress(int uploadProgress) {
        }

        @Override
        public void onHttpResponseProgress(int loadedLength) {
        }

        @Override
        public void onHttpFinish(WXResponse response) {
            ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.networkTime = System.currentTimeMillis() - this.startRequestTime;
            if (response.extendParams != null) {
                Object actualNetworkTime = response.extendParams.get("actualNetworkTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.actualNetworkTime = actualNetworkTime instanceof Long ? (Long)actualNetworkTime : 0L;
                WXLogUtils.renderPerformanceLog("actualNetworkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.actualNetworkTime);
                Object pureNetworkTime = response.extendParams.get("pureNetworkTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.pureNetworkTime = pureNetworkTime instanceof Long ? (Long)pureNetworkTime : 0L;
                WXLogUtils.renderPerformanceLog("pureNetworkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.pureNetworkTime);
                Object connectionType = response.extendParams.get("connectionType");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.connectionType = connectionType instanceof String ? (String)connectionType : "";
                Object packageSpendTime = response.extendParams.get("packageSpendTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.packageSpendTime = packageSpendTime instanceof Long ? (Long)packageSpendTime : 0L;
                Object syncTaskTime = response.extendParams.get("syncTaskTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.syncTaskTime = syncTaskTime instanceof Long ? (Long)syncTaskTime : 0L;
                Object requestType = response.extendParams.get("requestType");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.requestType = requestType instanceof String ? (String)requestType : "";
            }
            WXLogUtils.renderPerformanceLog("networkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.networkTime);
            if (response != null && response.originalData != null && TextUtils.equals((CharSequence)"200", (CharSequence)response.statusCode)) {
                String template = new String(response.originalData);
                WXSDKInstance.this.render(this.pageName, template, this.options, this.jsonInitData, this.width, this.height, this.flag);
            } else if (TextUtils.equals((CharSequence)"wx_user_intercept_error", (CharSequence)response.statusCode)) {
                WXLogUtils.d("user intercept");
                WXSDKInstance.this.onRenderError("wx_user_intercept_error", response.errorMsg);
            } else {
                WXSDKInstance.this.onRenderError("wx_network_error", response.errorMsg);
            }
        }
    }

    public static interface OnInstanceVisibleListener {
        public void onAppear();

        public void onDisappear();
    }
}

