/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.flex;

import com.taobao.weex.dom.flex.CSSAlign;
import com.taobao.weex.dom.flex.CSSDirection;
import com.taobao.weex.dom.flex.CSSFlexDirection;
import com.taobao.weex.dom.flex.CSSJustify;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.flex.CSSPositionType;
import com.taobao.weex.dom.flex.CSSWrap;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.dom.flex.MeasureOutput;

public class LayoutEngine {
    private static final int CSS_FLEX_DIRECTION_COLUMN = CSSFlexDirection.COLUMN.ordinal();
    private static final int CSS_FLEX_DIRECTION_COLUMN_REVERSE = CSSFlexDirection.COLUMN_REVERSE.ordinal();
    private static final int CSS_FLEX_DIRECTION_ROW = CSSFlexDirection.ROW.ordinal();
    private static final int CSS_FLEX_DIRECTION_ROW_REVERSE = CSSFlexDirection.ROW_REVERSE.ordinal();
    private static final int CSS_POSITION_RELATIVE = CSSPositionType.RELATIVE.ordinal();
    private static final int CSS_POSITION_ABSOLUTE = CSSPositionType.ABSOLUTE.ordinal();
    private static final int[] leading = new int[]{1, 3, 0, 2};
    private static final int[] trailing = new int[]{3, 1, 2, 0};
    private static final int[] pos = new int[]{1, 3, 0, 2};
    private static final int[] dim = new int[]{1, 1, 0, 0};
    private static final int[] leadingSpacing = new int[]{1, 3, 6, 6};
    private static final int[] trailingSpacing = new int[]{3, 1, 7, 7};

    private static float boundAxis(CSSNode node, int axis, float value) {
        float min = Float.NaN;
        float max = Float.NaN;
        if (axis == CSS_FLEX_DIRECTION_COLUMN || axis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
            min = node.cssstyle.minHeight;
            max = node.cssstyle.maxHeight;
        } else if (axis == CSS_FLEX_DIRECTION_ROW || axis == CSS_FLEX_DIRECTION_ROW_REVERSE) {
            min = node.cssstyle.minWidth;
            max = node.cssstyle.maxWidth;
        }
        float boundValue = value;
        if (!Float.isNaN(max) && (double)max >= 0.0 && boundValue > max) {
            boundValue = max;
        }
        if (!Float.isNaN(min) && (double)min >= 0.0 && boundValue < min) {
            boundValue = min;
        }
        return boundValue;
    }

    private static void setDimensionFromStyle(CSSNode node, int axis) {
        float maxLayoutDimension;
        if (!Float.isNaN(node.csslayout.dimensions[dim[axis]])) {
            return;
        }
        if (Float.isNaN(node.cssstyle.dimensions[dim[axis]]) || (double)node.cssstyle.dimensions[dim[axis]] <= 0.0) {
            return;
        }
        node.csslayout.dimensions[LayoutEngine.dim[axis]] = maxLayoutDimension = Math.max(LayoutEngine.boundAxis(node, axis, node.cssstyle.dimensions[dim[axis]]), node.cssstyle.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + node.cssstyle.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + node.cssstyle.border.getWithFallback(leadingSpacing[axis], leading[axis]) + node.cssstyle.border.getWithFallback(trailingSpacing[axis], trailing[axis]));
    }

    private static float getRelativePosition(CSSNode node, int axis) {
        float lead = node.cssstyle.position[leading[axis]];
        if (!Float.isNaN(lead)) {
            return lead;
        }
        float trailingPos = node.cssstyle.position[trailing[axis]];
        return Float.isNaN(trailingPos) ? 0.0f : -trailingPos;
    }

    private static int resolveAxis(int axis, CSSDirection direction) {
        if (direction == CSSDirection.RTL) {
            if (axis == CSS_FLEX_DIRECTION_ROW) {
                return CSS_FLEX_DIRECTION_ROW_REVERSE;
            }
            if (axis == CSS_FLEX_DIRECTION_ROW_REVERSE) {
                return CSS_FLEX_DIRECTION_ROW;
            }
        }
        return axis;
    }

    private static CSSDirection resolveDirection(CSSNode node, CSSDirection parentDirection) {
        CSSDirection direction = node.cssstyle.direction;
        if (direction == CSSDirection.INHERIT) {
            direction = parentDirection == null ? CSSDirection.LTR : parentDirection;
        }
        return direction;
    }

    private static int getFlexDirection(CSSNode node) {
        return node.cssstyle.flexDirection.ordinal();
    }

    private static int getCrossFlexDirection(int axis, CSSDirection direction) {
        if (axis == CSS_FLEX_DIRECTION_COLUMN || axis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
            return LayoutEngine.resolveAxis(CSS_FLEX_DIRECTION_ROW, direction);
        }
        return CSS_FLEX_DIRECTION_COLUMN;
    }

    private static CSSAlign getAlignItem(CSSNode node, CSSNode child) {
        if (child.cssstyle.alignSelf != CSSAlign.AUTO) {
            return child.cssstyle.alignSelf;
        }
        return node.cssstyle.alignItems;
    }

    private static boolean isMeasureDefined(CSSNode node) {
        return node.isMeasureDefined();
    }

    static boolean needsRelayout(CSSNode node, float parentMaxWidth) {
        return node.isDirty() || !FloatUtil.floatsEqual(node.lastLayout.requestedHeight, node.csslayout.dimensions[1]) || !FloatUtil.floatsEqual(node.lastLayout.requestedWidth, node.csslayout.dimensions[0]) || !FloatUtil.floatsEqual(node.lastLayout.parentMaxWidth, parentMaxWidth);
    }

    static void layoutNode(CSSLayoutContext layoutContext, CSSNode node, float parentMaxWidth, CSSDirection parentDirection) {
        if (LayoutEngine.needsRelayout(node, parentMaxWidth)) {
            node.lastLayout.requestedWidth = node.csslayout.dimensions[0];
            node.lastLayout.requestedHeight = node.csslayout.dimensions[1];
            node.lastLayout.parentMaxWidth = parentMaxWidth;
            LayoutEngine.layoutNodeImpl(layoutContext, node, parentMaxWidth, parentDirection);
            node.updateLastLayout(node.csslayout);
        } else {
            node.csslayout.copy(node.lastLayout);
            node.updateLastLayout(node.lastLayout);
        }
        node.markHasNewLayout();
    }

    private static void layoutNodeImpl(CSSLayoutContext layoutContext, CSSNode node, float parentMaxWidth, CSSDirection parentDirection) {
        int axis;
        int ii;
        CSSNode child;
        int i;
        int childCount = node.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            node.getChildAt((int)i2).csslayout.resetResult();
        }
        if (!node.isShow()) {
            return;
        }
        CSSDirection direction = LayoutEngine.resolveDirection(node, parentDirection);
        int mainAxis = LayoutEngine.resolveAxis(LayoutEngine.getFlexDirection(node), direction);
        int crossAxis = LayoutEngine.getCrossFlexDirection(mainAxis, direction);
        int resolvedRowAxis = LayoutEngine.resolveAxis(CSS_FLEX_DIRECTION_ROW, direction);
        LayoutEngine.setDimensionFromStyle(node, mainAxis);
        LayoutEngine.setDimensionFromStyle(node, crossAxis);
        node.csslayout.direction = direction;
        int n = leading[mainAxis];
        node.csslayout.position[n] = node.csslayout.position[n] + (node.cssstyle.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + LayoutEngine.getRelativePosition(node, mainAxis));
        int n2 = trailing[mainAxis];
        node.csslayout.position[n2] = node.csslayout.position[n2] + (node.cssstyle.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + LayoutEngine.getRelativePosition(node, mainAxis));
        int n3 = leading[crossAxis];
        node.csslayout.position[n3] = node.csslayout.position[n3] + (node.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + LayoutEngine.getRelativePosition(node, crossAxis));
        int n4 = trailing[crossAxis];
        node.csslayout.position[n4] = node.csslayout.position[n4] + (node.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + LayoutEngine.getRelativePosition(node, crossAxis));
        int childCount2 = node.getChildCount();
        float paddingAndBorderAxisResolvedRow = node.cssstyle.padding.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.cssstyle.border.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + (node.cssstyle.padding.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis]) + node.cssstyle.border.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis]));
        if (LayoutEngine.isMeasureDefined(node)) {
            boolean isColumnUndefined;
            boolean isResolvedRowDimDefined = !Float.isNaN(node.csslayout.dimensions[dim[resolvedRowAxis]]);
            float width = Float.NaN;
            width = !Float.isNaN(node.cssstyle.dimensions[dim[resolvedRowAxis]]) && (double)node.cssstyle.dimensions[dim[resolvedRowAxis]] >= 0.0 ? node.cssstyle.dimensions[0] : (isResolvedRowDimDefined ? node.csslayout.dimensions[dim[resolvedRowAxis]] : parentMaxWidth - (node.cssstyle.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.cssstyle.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis])));
            width -= paddingAndBorderAxisResolvedRow;
            boolean isRowUndefined = !(!Float.isNaN(node.cssstyle.dimensions[dim[resolvedRowAxis]]) && (double)node.cssstyle.dimensions[dim[resolvedRowAxis]] >= 0.0 || isResolvedRowDimDefined);
            boolean bl = isColumnUndefined = !(!Float.isNaN(node.cssstyle.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]) && (double)node.cssstyle.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0 || !Float.isNaN(node.csslayout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]));
            if (isRowUndefined || isColumnUndefined) {
                MeasureOutput measureDim = node.measure(layoutContext.measureOutput, width);
                if (isRowUndefined) {
                    node.csslayout.dimensions[0] = measureDim.width + paddingAndBorderAxisResolvedRow;
                }
                if (isColumnUndefined) {
                    node.csslayout.dimensions[1] = measureDim.height + (node.cssstyle.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.cssstyle.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + (node.cssstyle.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]) + node.cssstyle.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN])));
                }
            }
            if (childCount2 == 0) {
                return;
            }
        }
        boolean isNodeFlexWrap = node.cssstyle.flexWrap == CSSWrap.WRAP;
        CSSJustify justifyContent = node.cssstyle.justifyContent;
        float leadingPaddingAndBorderMain = node.cssstyle.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + node.cssstyle.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]);
        float leadingPaddingAndBorderCross = node.cssstyle.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + node.cssstyle.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
        float paddingAndBorderAxisMain = node.cssstyle.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + node.cssstyle.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (node.cssstyle.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + node.cssstyle.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
        float paddingAndBorderAxisCross = node.cssstyle.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + node.cssstyle.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (node.cssstyle.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + node.cssstyle.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
        boolean isMainDimDefined = !Float.isNaN(node.csslayout.dimensions[dim[mainAxis]]);
        boolean isCrossDimDefined = !Float.isNaN(node.csslayout.dimensions[dim[crossAxis]]);
        boolean isMainRowDirection = mainAxis == CSS_FLEX_DIRECTION_ROW || mainAxis == CSS_FLEX_DIRECTION_ROW_REVERSE;
        CSSNode firstAbsoluteChild = null;
        CSSNode currentAbsoluteChild = null;
        float definedMainDim = Float.NaN;
        if (isMainDimDefined) {
            definedMainDim = node.csslayout.dimensions[dim[mainAxis]] - paddingAndBorderAxisMain;
        }
        int startLine = 0;
        int endLine = 0;
        boolean alreadyComputedNextLayout = false;
        float linesCrossDim = 0.0f;
        float linesMainDim = 0.0f;
        int linesCount = 0;
        while (endLine < childCount2) {
            float maxWidth;
            float mainContentDim = 0.0f;
            int flexibleChildrenCount = 0;
            float totalFlexible = 0.0f;
            int nonFlexibleChildrenCount = 0;
            boolean isSimpleStackMain = isMainDimDefined && justifyContent == CSSJustify.FLEX_START || !isMainDimDefined && justifyContent != CSSJustify.CENTER;
            int firstComplexMain = isSimpleStackMain ? childCount2 : startLine;
            boolean isSimpleStackCross = true;
            int firstComplexCross = childCount2;
            CSSNode firstFlexChild = null;
            CSSNode currentFlexChild = null;
            float mainDim = leadingPaddingAndBorderMain;
            float crossDim = 0.0f;
            for (i = startLine; i < childCount2; ++i) {
                child = node.getChildAt(i);
                if (!child.isShow()) {
                    endLine = i + 1;
                    continue;
                }
                child.lineIndex = linesCount;
                child.nextAbsoluteChild = null;
                child.nextFlexChild = null;
                CSSAlign alignItem = LayoutEngine.getAlignItem(node, child);
                if (alignItem == CSSAlign.STRETCH && child.cssstyle.positionType == CSSPositionType.RELATIVE && isCrossDimDefined && (Float.isNaN(child.cssstyle.dimensions[dim[crossAxis]]) || !((double)child.cssstyle.dimensions[dim[crossAxis]] >= 0.0))) {
                    child.csslayout.dimensions[LayoutEngine.dim[crossAxis]] = Math.max(LayoutEngine.boundAxis(child, crossAxis, node.csslayout.dimensions[dim[crossAxis]] - paddingAndBorderAxisCross - (child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]))), child.cssstyle.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (child.cssstyle.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + child.cssstyle.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                } else if (child.cssstyle.positionType == CSSPositionType.ABSOLUTE) {
                    if (firstAbsoluteChild == null) {
                        firstAbsoluteChild = child;
                    }
                    if (currentAbsoluteChild != null) {
                        currentAbsoluteChild.nextAbsoluteChild = child;
                    }
                    currentAbsoluteChild = child;
                    for (ii = 0; ii < 2; ++ii) {
                        int n5 = axis = ii != 0 ? CSS_FLEX_DIRECTION_ROW : CSS_FLEX_DIRECTION_COLUMN;
                        if (Float.isNaN(node.csslayout.dimensions[dim[axis]]) || !Float.isNaN(child.cssstyle.dimensions[dim[axis]]) && (double)child.cssstyle.dimensions[dim[axis]] >= 0.0 || Float.isNaN(child.cssstyle.position[leading[axis]]) || Float.isNaN(child.cssstyle.position[trailing[axis]])) continue;
                        child.csslayout.dimensions[LayoutEngine.dim[axis]] = Math.max(LayoutEngine.boundAxis(child, axis, node.csslayout.dimensions[dim[axis]] - (node.cssstyle.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + node.cssstyle.border.getWithFallback(leadingSpacing[axis], leading[axis]) + (node.cssstyle.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + node.cssstyle.border.getWithFallback(trailingSpacing[axis], trailing[axis]))) - (child.cssstyle.margin.getWithFallback(leadingSpacing[axis], leading[axis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[axis], trailing[axis])) - (Float.isNaN(child.cssstyle.position[leading[axis]]) ? 0.0f : child.cssstyle.position[leading[axis]]) - (Float.isNaN(child.cssstyle.position[trailing[axis]]) ? 0.0f : child.cssstyle.position[trailing[axis]])), child.cssstyle.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + child.cssstyle.border.getWithFallback(leadingSpacing[axis], leading[axis]) + (child.cssstyle.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + child.cssstyle.border.getWithFallback(trailingSpacing[axis], trailing[axis])));
                    }
                }
                float nextContentDim = 0.0f;
                if (isMainDimDefined && child.cssstyle.positionType == CSSPositionType.RELATIVE && child.cssstyle.flex > 0.0f) {
                    ++flexibleChildrenCount;
                    totalFlexible += child.cssstyle.flex;
                    if (firstFlexChild == null) {
                        firstFlexChild = child;
                    }
                    if (currentFlexChild != null) {
                        currentFlexChild.nextFlexChild = child;
                    }
                    currentFlexChild = child;
                    nextContentDim = child.cssstyle.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.cssstyle.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (child.cssstyle.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + child.cssstyle.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])) + (child.cssstyle.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
                } else {
                    maxWidth = Float.NaN;
                    if (!isMainRowDirection) {
                        maxWidth = !Float.isNaN(node.cssstyle.dimensions[dim[resolvedRowAxis]]) && (double)node.cssstyle.dimensions[dim[resolvedRowAxis]] >= 0.0 ? node.csslayout.dimensions[dim[resolvedRowAxis]] - paddingAndBorderAxisResolvedRow : parentMaxWidth - (node.cssstyle.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.cssstyle.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis])) - paddingAndBorderAxisResolvedRow;
                    }
                    if (!alreadyComputedNextLayout) {
                        LayoutEngine.layoutNode(layoutContext, child, maxWidth, direction);
                    }
                    if (child.cssstyle.positionType == CSSPositionType.RELATIVE) {
                        ++nonFlexibleChildrenCount;
                        nextContentDim = child.csslayout.dimensions[dim[mainAxis]] + child.cssstyle.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]);
                    }
                }
                if (isNodeFlexWrap && isMainDimDefined && mainContentDim + nextContentDim > definedMainDim && i != startLine) {
                    --nonFlexibleChildrenCount;
                    alreadyComputedNextLayout = true;
                    break;
                }
                if (isSimpleStackMain && (child.cssstyle.positionType != CSSPositionType.RELATIVE || child.cssstyle.positionType == CSSPositionType.RELATIVE && child.cssstyle.flex > 0.0f)) {
                    isSimpleStackMain = false;
                    firstComplexMain = i;
                }
                if (isSimpleStackCross && (child.cssstyle.positionType != CSSPositionType.RELATIVE || alignItem != CSSAlign.STRETCH && alignItem != CSSAlign.FLEX_START || Float.isNaN(child.csslayout.dimensions[dim[crossAxis]]))) {
                    isSimpleStackCross = false;
                    firstComplexCross = i;
                }
                if (isSimpleStackMain) {
                    int n6 = pos[mainAxis];
                    child.csslayout.position[n6] = child.csslayout.position[n6] + mainDim;
                    if (isMainDimDefined) {
                        child.csslayout.position[LayoutEngine.trailing[mainAxis]] = node.csslayout.dimensions[dim[mainAxis]] - child.csslayout.dimensions[dim[mainAxis]] - child.csslayout.position[pos[mainAxis]];
                    }
                    mainDim += child.csslayout.dimensions[dim[mainAxis]] + child.cssstyle.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]);
                    crossDim = Math.max(crossDim, LayoutEngine.boundAxis(child, crossAxis, child.csslayout.dimensions[dim[crossAxis]] + child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                }
                if (isSimpleStackCross) {
                    int n7 = pos[crossAxis];
                    child.csslayout.position[n7] = child.csslayout.position[n7] + (linesCrossDim + leadingPaddingAndBorderCross);
                    if (isCrossDimDefined) {
                        child.csslayout.position[LayoutEngine.trailing[crossAxis]] = node.csslayout.dimensions[dim[crossAxis]] - child.csslayout.dimensions[dim[crossAxis]] - child.csslayout.position[pos[crossAxis]];
                    }
                }
                alreadyComputedNextLayout = false;
                mainContentDim += nextContentDim;
                endLine = i + 1;
            }
            float leadingMainDim = 0.0f;
            float betweenMainDim = 0.0f;
            float remainingMainDim = 0.0f;
            remainingMainDim = isMainDimDefined ? definedMainDim - mainContentDim : Math.max(mainContentDim, 0.0f) - mainContentDim;
            if (flexibleChildrenCount != 0) {
                float flexibleMainDim = remainingMainDim / totalFlexible;
                currentFlexChild = firstFlexChild;
                while (currentFlexChild != null) {
                    float boundMainDim;
                    float baseMainDim;
                    if (currentFlexChild.isShow() && (baseMainDim = flexibleMainDim * currentFlexChild.cssstyle.flex + (currentFlexChild.cssstyle.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + currentFlexChild.cssstyle.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (currentFlexChild.cssstyle.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + currentFlexChild.cssstyle.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])))) != (boundMainDim = LayoutEngine.boundAxis(currentFlexChild, mainAxis, baseMainDim))) {
                        remainingMainDim -= boundMainDim;
                        totalFlexible -= currentFlexChild.cssstyle.flex;
                    }
                    currentFlexChild = currentFlexChild.nextFlexChild;
                }
                flexibleMainDim = remainingMainDim / totalFlexible;
                if (flexibleMainDim < 0.0f) {
                    flexibleMainDim = 0.0f;
                }
                currentFlexChild = firstFlexChild;
                while (currentFlexChild != null) {
                    if (currentFlexChild.isShow()) {
                        currentFlexChild.csslayout.dimensions[LayoutEngine.dim[mainAxis]] = LayoutEngine.boundAxis(currentFlexChild, mainAxis, flexibleMainDim * currentFlexChild.cssstyle.flex + (currentFlexChild.cssstyle.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + currentFlexChild.cssstyle.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (currentFlexChild.cssstyle.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + currentFlexChild.cssstyle.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]))));
                        maxWidth = Float.NaN;
                        if (!Float.isNaN(node.cssstyle.dimensions[dim[resolvedRowAxis]]) && (double)node.cssstyle.dimensions[dim[resolvedRowAxis]] >= 0.0) {
                            maxWidth = node.csslayout.dimensions[dim[resolvedRowAxis]] - paddingAndBorderAxisResolvedRow;
                        } else if (!isMainRowDirection) {
                            maxWidth = parentMaxWidth - (node.cssstyle.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.cssstyle.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis])) - paddingAndBorderAxisResolvedRow;
                        }
                        LayoutEngine.layoutNode(layoutContext, currentFlexChild, maxWidth, direction);
                    }
                    child = currentFlexChild;
                    currentFlexChild = currentFlexChild.nextFlexChild;
                    child.nextFlexChild = null;
                }
            } else if (justifyContent != CSSJustify.FLEX_START) {
                if (justifyContent == CSSJustify.CENTER) {
                    leadingMainDim = remainingMainDim / 2.0f;
                } else if (justifyContent == CSSJustify.FLEX_END) {
                    leadingMainDim = remainingMainDim;
                } else if (justifyContent == CSSJustify.SPACE_BETWEEN) {
                    remainingMainDim = Math.max(remainingMainDim, 0.0f);
                    betweenMainDim = flexibleChildrenCount + nonFlexibleChildrenCount - 1 != 0 ? remainingMainDim / (float)(flexibleChildrenCount + nonFlexibleChildrenCount - 1) : 0.0f;
                } else if (justifyContent == CSSJustify.SPACE_AROUND) {
                    betweenMainDim = remainingMainDim / (float)(flexibleChildrenCount + nonFlexibleChildrenCount);
                    leadingMainDim = betweenMainDim / 2.0f;
                }
            }
            mainDim += leadingMainDim;
            for (i = firstComplexMain; i < endLine; ++i) {
                child = node.getChildAt(i);
                if (!child.isShow()) continue;
                if (child.cssstyle.positionType == CSSPositionType.ABSOLUTE && !Float.isNaN(child.cssstyle.position[leading[mainAxis]])) {
                    child.csslayout.position[LayoutEngine.pos[mainAxis]] = (Float.isNaN(child.cssstyle.position[leading[mainAxis]]) ? 0.0f : child.cssstyle.position[leading[mainAxis]]) + node.cssstyle.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.cssstyle.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]);
                    continue;
                }
                int n8 = pos[mainAxis];
                child.csslayout.position[n8] = child.csslayout.position[n8] + mainDim;
                if (isMainDimDefined) {
                    child.csslayout.position[LayoutEngine.trailing[mainAxis]] = node.csslayout.dimensions[dim[mainAxis]] - child.csslayout.dimensions[dim[mainAxis]] - child.csslayout.position[pos[mainAxis]];
                }
                if (child.cssstyle.positionType != CSSPositionType.RELATIVE) continue;
                mainDim += betweenMainDim + (child.csslayout.dimensions[dim[mainAxis]] + child.cssstyle.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
                crossDim = Math.max(crossDim, LayoutEngine.boundAxis(child, crossAxis, child.csslayout.dimensions[dim[crossAxis]] + child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
            }
            float containerCrossAxis = node.csslayout.dimensions[dim[crossAxis]];
            if (!isCrossDimDefined) {
                containerCrossAxis = Math.max(LayoutEngine.boundAxis(node, crossAxis, crossDim + paddingAndBorderAxisCross), paddingAndBorderAxisCross);
            }
            for (i = firstComplexCross; i < endLine; ++i) {
                child = node.getChildAt(i);
                if (!child.isShow()) continue;
                if (child.cssstyle.positionType == CSSPositionType.ABSOLUTE && !Float.isNaN(child.cssstyle.position[leading[crossAxis]])) {
                    child.csslayout.position[LayoutEngine.pos[crossAxis]] = (Float.isNaN(child.cssstyle.position[leading[crossAxis]]) ? 0.0f : child.cssstyle.position[leading[crossAxis]]) + node.cssstyle.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                    continue;
                }
                float leadingCrossDim = leadingPaddingAndBorderCross;
                if (child.cssstyle.positionType == CSSPositionType.RELATIVE) {
                    CSSAlign alignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignItem == CSSAlign.STRETCH) {
                        if (Float.isNaN(child.csslayout.dimensions[dim[crossAxis]])) {
                            child.csslayout.dimensions[LayoutEngine.dim[crossAxis]] = Math.max(LayoutEngine.boundAxis(child, crossAxis, containerCrossAxis - paddingAndBorderAxisCross - (child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]))), child.cssstyle.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (child.cssstyle.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + child.cssstyle.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                        }
                    } else if (alignItem != CSSAlign.FLEX_START) {
                        float remainingCrossDim = containerCrossAxis - paddingAndBorderAxisCross - (child.csslayout.dimensions[dim[crossAxis]] + child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
                        leadingCrossDim = alignItem == CSSAlign.CENTER ? (leadingCrossDim += remainingCrossDim / 2.0f) : (leadingCrossDim += remainingCrossDim);
                    }
                }
                int n9 = pos[crossAxis];
                child.csslayout.position[n9] = child.csslayout.position[n9] + (linesCrossDim + leadingCrossDim);
                if (!isCrossDimDefined) continue;
                child.csslayout.position[LayoutEngine.trailing[crossAxis]] = node.csslayout.dimensions[dim[crossAxis]] - child.csslayout.dimensions[dim[crossAxis]] - child.csslayout.position[pos[crossAxis]];
            }
            linesCrossDim += crossDim;
            linesMainDim = Math.max(linesMainDim, mainDim);
            ++linesCount;
            startLine = endLine;
        }
        if (linesCount > 1 && isCrossDimDefined) {
            float nodeCrossAxisInnerSize = node.csslayout.dimensions[dim[crossAxis]] - paddingAndBorderAxisCross;
            float remainingAlignContentDim = nodeCrossAxisInnerSize - linesCrossDim;
            float crossDimLead = 0.0f;
            float currentLead = leadingPaddingAndBorderCross;
            CSSAlign alignContent = node.cssstyle.alignContent;
            if (alignContent == CSSAlign.FLEX_END) {
                currentLead += remainingAlignContentDim;
            } else if (alignContent == CSSAlign.CENTER) {
                currentLead += remainingAlignContentDim / 2.0f;
            } else if (alignContent == CSSAlign.STRETCH && nodeCrossAxisInnerSize > linesCrossDim) {
                crossDimLead = remainingAlignContentDim / (float)linesCount;
            }
            int endIndex = 0;
            for (i = 0; i < linesCount; ++i) {
                int startIndex = endIndex;
                float lineHeight = 0.0f;
                for (ii = startIndex; ii < childCount2; ++ii) {
                    child = node.getChildAt(ii);
                    if (!child.isShow() || child.cssstyle.positionType != CSSPositionType.RELATIVE) continue;
                    if (child.lineIndex != i) break;
                    if (Float.isNaN(child.csslayout.dimensions[dim[crossAxis]])) continue;
                    lineHeight = Math.max(lineHeight, child.csslayout.dimensions[dim[crossAxis]] + (child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                }
                endIndex = ii;
                lineHeight += crossDimLead;
                for (ii = startIndex; ii < endIndex; ++ii) {
                    child = node.getChildAt(ii);
                    if (!child.isShow() || child.cssstyle.positionType != CSSPositionType.RELATIVE) continue;
                    CSSAlign alignContentAlignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignContentAlignItem == CSSAlign.FLEX_START) {
                        child.csslayout.position[LayoutEngine.pos[crossAxis]] = currentLead + child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                        continue;
                    }
                    if (alignContentAlignItem == CSSAlign.FLEX_END) {
                        child.csslayout.position[LayoutEngine.pos[crossAxis]] = currentLead + lineHeight - child.cssstyle.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) - child.csslayout.dimensions[dim[crossAxis]];
                        continue;
                    }
                    if (alignContentAlignItem == CSSAlign.CENTER) {
                        float childHeight = child.csslayout.dimensions[dim[crossAxis]];
                        child.csslayout.position[LayoutEngine.pos[crossAxis]] = currentLead + (lineHeight - childHeight) / 2.0f;
                        continue;
                    }
                    if (alignContentAlignItem != CSSAlign.STRETCH) continue;
                    child.csslayout.position[LayoutEngine.pos[crossAxis]] = currentLead + child.cssstyle.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                }
                currentLead += lineHeight;
            }
        }
        boolean needsMainTrailingPos = false;
        boolean needsCrossTrailingPos = false;
        if (!isMainDimDefined) {
            node.csslayout.dimensions[LayoutEngine.dim[mainAxis]] = Math.max(LayoutEngine.boundAxis(node, mainAxis, linesMainDim + (node.cssstyle.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + node.cssstyle.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]))), paddingAndBorderAxisMain);
            if (mainAxis == CSS_FLEX_DIRECTION_ROW_REVERSE || mainAxis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
                needsMainTrailingPos = true;
            }
        }
        if (!isCrossDimDefined) {
            node.csslayout.dimensions[LayoutEngine.dim[crossAxis]] = Math.max(LayoutEngine.boundAxis(node, crossAxis, linesCrossDim + paddingAndBorderAxisCross), paddingAndBorderAxisCross);
            if (crossAxis == CSS_FLEX_DIRECTION_ROW_REVERSE || crossAxis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
                needsCrossTrailingPos = true;
            }
        }
        if (needsMainTrailingPos || needsCrossTrailingPos) {
            for (i = 0; i < childCount2; ++i) {
                child = node.getChildAt(i);
                if (!child.isShow()) continue;
                if (needsMainTrailingPos) {
                    child.csslayout.position[LayoutEngine.trailing[mainAxis]] = node.csslayout.dimensions[dim[mainAxis]] - child.csslayout.dimensions[dim[mainAxis]] - child.csslayout.position[pos[mainAxis]];
                }
                if (!needsCrossTrailingPos) continue;
                child.csslayout.position[LayoutEngine.trailing[crossAxis]] = node.csslayout.dimensions[dim[crossAxis]] - child.csslayout.dimensions[dim[crossAxis]] - child.csslayout.position[pos[crossAxis]];
            }
        }
        currentAbsoluteChild = firstAbsoluteChild;
        while (currentAbsoluteChild != null) {
            if (currentAbsoluteChild.isShow()) {
                for (ii = 0; ii < 2; ++ii) {
                    int n10 = axis = ii != 0 ? CSS_FLEX_DIRECTION_ROW : CSS_FLEX_DIRECTION_COLUMN;
                    if (!(Float.isNaN(node.csslayout.dimensions[dim[axis]]) || !Float.isNaN(currentAbsoluteChild.cssstyle.dimensions[dim[axis]]) && (double)currentAbsoluteChild.cssstyle.dimensions[dim[axis]] >= 0.0 || Float.isNaN(currentAbsoluteChild.cssstyle.position[leading[axis]]) || Float.isNaN(currentAbsoluteChild.cssstyle.position[trailing[axis]]))) {
                        currentAbsoluteChild.csslayout.dimensions[LayoutEngine.dim[axis]] = Math.max(LayoutEngine.boundAxis(currentAbsoluteChild, axis, node.csslayout.dimensions[dim[axis]] - (node.cssstyle.border.getWithFallback(leadingSpacing[axis], leading[axis]) + node.cssstyle.border.getWithFallback(trailingSpacing[axis], trailing[axis])) - (currentAbsoluteChild.cssstyle.margin.getWithFallback(leadingSpacing[axis], leading[axis]) + currentAbsoluteChild.cssstyle.margin.getWithFallback(trailingSpacing[axis], trailing[axis])) - (Float.isNaN(currentAbsoluteChild.cssstyle.position[leading[axis]]) ? 0.0f : currentAbsoluteChild.cssstyle.position[leading[axis]]) - (Float.isNaN(currentAbsoluteChild.cssstyle.position[trailing[axis]]) ? 0.0f : currentAbsoluteChild.cssstyle.position[trailing[axis]])), currentAbsoluteChild.cssstyle.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + currentAbsoluteChild.cssstyle.border.getWithFallback(leadingSpacing[axis], leading[axis]) + (currentAbsoluteChild.cssstyle.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + currentAbsoluteChild.cssstyle.border.getWithFallback(trailingSpacing[axis], trailing[axis])));
                    }
                    if (Float.isNaN(currentAbsoluteChild.cssstyle.position[trailing[axis]]) || !Float.isNaN(currentAbsoluteChild.cssstyle.position[leading[axis]])) continue;
                    currentAbsoluteChild.csslayout.position[LayoutEngine.leading[axis]] = node.csslayout.dimensions[dim[axis]] - currentAbsoluteChild.csslayout.dimensions[dim[axis]] - (Float.isNaN(currentAbsoluteChild.cssstyle.position[trailing[axis]]) ? 0.0f : currentAbsoluteChild.cssstyle.position[trailing[axis]]);
                }
            }
            child = currentAbsoluteChild;
            currentAbsoluteChild = currentAbsoluteChild.nextAbsoluteChild;
            child.nextAbsoluteChild = null;
        }
    }
}

