/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Typeface;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;
import java.net.URI;

public class FontDO {
    private final String mFontFamilyName;
    private String mUrl = "";
    private int mType = 1;
    private Typeface mTypeface;
    private int mState = -1;
    public static final int STATE_INVALID = -1;
    public static final int STATE_INIT = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_SUCCESS = 2;
    public static final int STATE_FAILED = 3;
    public static final int TYPE_LOCAL = 0;
    public static final int TYPE_NETWORK = 1;
    public static final int TYPE_FILE = 2;

    public FontDO(String fontFamilyName, String src) {
        this.mFontFamilyName = fontFamilyName;
        this.parseSrc(src);
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    private void parseSrc(String src) {
        String string = src = src != null ? src.trim() : "";
        if (src.isEmpty()) {
            this.mState = -1;
            WXLogUtils.e("TypefaceUtil", "font src is empty.");
            return;
        }
        if (src.matches("^url\\('.*'\\)$")) {
            this.mUrl = src.substring(5, src.length() - 2);
            try {
                URI uri = URI.create(this.mUrl);
                String scheme = uri.getScheme();
                if ("http".equals(scheme) || "https".equals(scheme)) {
                    this.mType = 1;
                } else if ("file".equals(scheme)) {
                    this.mType = 2;
                    this.mUrl = uri.getPath();
                } else {
                    this.mType = 0;
                }
                this.mState = 0;
            }
            catch (Exception e) {
                this.mType = -1;
                WXLogUtils.e("TypefaceUtil", "URI.create(mUrl) failed mUrl: " + this.mUrl);
            }
        } else {
            this.mUrl = src;
            this.mState = -1;
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("TypefaceUtil", "src:" + src + ", mUrl:" + this.mUrl + ", mType:" + this.mType);
        }
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getType() {
        return this.mType;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        this.mState = state;
    }
}

