/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.WXTextDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

public abstract class AbstractEditComponent
extends WXComponent<WXEditText> {
    private final InputMethodManager mInputMethodManager;
    private String mBeforeText;
    private boolean mAutoFocus;
    private String mType;

    public AbstractEditComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
        this.mInputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        this.mBeforeText = "";
        this.mType = "text";
    }

    @Override
    protected WXEditText initComponentHostView(Context context) {
        WXEditText inputView = new WXEditText(context);
        this.appleStyleAfterCreated(inputView);
        return inputView;
    }

    protected void appleStyleAfterCreated(WXEditText editText) {
        String alignStr = (String)this.mDomObj.style.get("textAlign");
        int textAlign = this.getTextAlign(alignStr);
        if (textAlign <= 0) {
            textAlign = 3;
        }
        editText.setGravity(textAlign | 0x10);
        int colorInt = WXResourceUtils.getColor("#999999");
        if (colorInt != Integer.MIN_VALUE) {
            editText.setHintTextColor(colorInt);
        }
        editText.setTextSize(0, WXStyle.getFontSize(this.mDomObj.style));
        editText.setText((String)this.mDomObj.attr.get("value"));
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (this.mHost == null || TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        WXEditText text = (WXEditText)this.mHost;
        if (type.equals("change")) {
            text.setOnFocusChangeListener(new View.OnFocusChangeListener((TextView)text){
                CharSequence mLastValue;
                final /* synthetic */ TextView val$text;
                {
                    this.val$text = textView;
                    this.mLastValue = this.val$text.getText();
                }

                public void onFocusChange(View v, boolean hasFocus) {
                    CharSequence newValue = this.val$text.getText();
                    CharSequence charSequence = newValue = newValue == null ? "" : newValue;
                    if (!hasFocus && !newValue.equals(this.mLastValue)) {
                        this.mLastValue = newValue;
                        String event = AbstractEditComponent.this.mDomObj.event.contains("change") ? "change" : null;
                        AbstractEditComponent.this.fireEvent(event, newValue.toString());
                    }
                }
            });
        } else if (type.equals("input")) {
            text.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (AbstractEditComponent.this.mBeforeText.equals(s.toString())) {
                        return;
                    }
                    String event = AbstractEditComponent.this.mDomObj.event.contains("input") ? "input" : null;
                    AbstractEditComponent.this.fireEvent(event, s.toString());
                    AbstractEditComponent.this.mBeforeText = s.toString();
                }

                public void afterTextChanged(Editable s) {
                }
            });
        }
    }

    private void fireEvent(String event, String value) {
        if (event != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("value", value);
            params.put("timeStamp", System.currentTimeMillis());
            HashMap<String, Object> domChanges = new HashMap<String, Object>();
            HashMap<String, String> attrsChanges = new HashMap<String, String>();
            attrsChanges.put("value", value);
            domChanges.put("attrs", attrsChanges);
            WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.mDomObj.ref, event, params, domChanges);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "placeholder": {
                String placeholder = WXUtils.getString(param, null);
                if (placeholder != null) {
                    this.setPlaceholder(placeholder);
                }
                return true;
            }
            case "placeholderColor": {
                String placeholder_color = WXUtils.getString(param, null);
                if (placeholder_color != null) {
                    this.setPlaceholderColor(placeholder_color);
                }
                return true;
            }
            case "type": {
                String input_type = WXUtils.getString(param, null);
                if (input_type != null) {
                    this.setType(input_type);
                }
                return true;
            }
            case "autofocus": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAutofocus(result);
                }
                return true;
            }
            case "color": {
                String color = WXUtils.getString(param, null);
                if (color != null) {
                    this.setColor(color);
                }
                return true;
            }
            case "fontSize": {
                String fontsize = WXUtils.getString(param, null);
                if (fontsize != null) {
                    this.setFontSize(fontsize);
                }
                return true;
            }
            case "textAlign": {
                String text_align = WXUtils.getString(param, null);
                if (text_align != null) {
                    this.setTextAlign(text_align);
                }
                return true;
            }
            case "singleline": {
                Boolean singLineResult = WXUtils.getBoolean(param, null);
                if (singLineResult != null) {
                    this.setSingleLine(singLineResult);
                }
                return true;
            }
            case "lines": {
                Integer lines = WXUtils.getInteger(param, null);
                if (lines != null) {
                    this.setLines(lines);
                }
                return true;
            }
            case "maxLength": {
                Integer maxlength = WXUtils.getInteger(param, null);
                if (maxlength != null) {
                    this.setMaxLength(maxlength);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="placeholder")
    public void setPlaceholder(String placeholder) {
        if (placeholder == null || this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setHint(placeholder);
    }

    @WXComponentProp(name="placeholderColor")
    public void setPlaceholderColor(String color) {
        int colorInt;
        if (this.mHost != null && !TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((WXEditText)this.mHost).setHintTextColor(colorInt);
        }
    }

    @WXComponentProp(name="type")
    public void setType(String type) {
        if (type == null || this.mHost == null) {
            return;
        }
        this.mType = type;
        ((EditText)this.mHost).setRawInputType(this.getInputType(this.mType));
    }

    @WXComponentProp(name="autofocus")
    public void setAutofocus(boolean autofocus) {
        if (this.mHost == null) {
            return;
        }
        this.mAutoFocus = autofocus;
        EditText inputView = (EditText)this.mHost;
        if (this.mAutoFocus) {
            inputView.setFocusable(true);
            inputView.requestFocus();
            inputView.setFocusableInTouchMode(true);
            inputView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AbstractEditComponent.this.showSoftKeyboard();
                }
            }, 16L);
        } else {
            inputView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AbstractEditComponent.this.hideSoftKeyboard();
                }
            }, 16L);
        }
    }

    @WXComponentProp(name="color")
    public void setColor(String color) {
        int colorInt;
        if (this.mHost != null && !TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((WXEditText)this.mHost).setTextColor(colorInt);
        }
    }

    @WXComponentProp(name="fontSize")
    public void setFontSize(String fontSize) {
        if (this.mHost != null && fontSize != null && this.mDomObj.style != null) {
            ((WXEditText)this.mHost).setTextSize(0, WXStyle.getFontSize(this.mDomObj.style));
        }
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String textAlign) {
        int align = this.getTextAlign(textAlign);
        if (align > 0) {
            ((EditText)this.mHost).setGravity(align | 0x10);
        }
    }

    @WXComponentProp(name="singleline")
    public void setSingleLine(boolean singleLine) {
        if (this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setSingleLine(singleLine);
    }

    @WXComponentProp(name="lines")
    public void setLines(int lines) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setLines(lines);
    }

    @WXComponentProp(name="maxLength")
    public void setMaxLength(int maxLength) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
    }

    @Override
    public WXTextDomObject getDomObject() {
        return (WXTextDomObject)super.getDomObject();
    }

    private int getInputType(String type) {
        int inputType;
        switch (type) {
            case "text": {
                inputType = 1;
                break;
            }
            case "date": {
                inputType = 20;
                break;
            }
            case "datetime": {
                inputType = 4;
                break;
            }
            case "email": {
                inputType = 33;
                break;
            }
            case "password": {
                inputType = 129;
                ((WXEditText)this.getHostView()).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                break;
            }
            case "tel": {
                inputType = 3;
                break;
            }
            case "time": {
                inputType = 36;
                break;
            }
            case "url": {
                inputType = 17;
                break;
            }
            default: {
                inputType = 1;
            }
        }
        return inputType;
    }

    private boolean showSoftKeyboard() {
        if (this.mHost == null) {
            return false;
        }
        return this.mInputMethodManager.showSoftInput(this.mHost, 1);
    }

    private void hideSoftKeyboard() {
        if (this.mHost != null) {
            this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)this.mHost).getWindowToken(), 0);
        }
    }

    private int getTextAlign(String textAlign) {
        int align = 3;
        if (TextUtils.isEmpty((CharSequence)textAlign)) {
            return align;
        }
        if (textAlign.equals("left")) {
            align = 3;
        } else if (textAlign.equals("center")) {
            align = 17;
        } else if (textAlign.equals("right")) {
            align = 5;
        }
        return align;
    }
}

