/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.CSSTransformFromStyle;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXDomObjectFactory;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.IWXRenderTask;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class WXDomStatement {
    private final ConcurrentHashMap<String, WXDomObject> mRegistry;
    private String mInstanceId;
    private WXRenderManager mWXRenderManager;
    private ArrayList<IWXRenderTask> mNormalTasks;
    private Set<Pair<String, Map<String, Object>>> animations;
    private CSSLayoutContext mLayoutContext;
    private volatile boolean mDirty;
    private boolean mDestroy = false;
    private Map<String, AddDomInfo> mAddDom = new HashMap<String, AddDomInfo>();

    public WXDomStatement(String instanceId, WXRenderManager renderManager) {
        this.mInstanceId = instanceId;
        this.mLayoutContext = new CSSLayoutContext();
        this.mRegistry = new ConcurrentHashMap();
        this.mNormalTasks = new ArrayList();
        this.animations = new HashSet<Pair<String, Map<String, Object>>>();
        this.mWXRenderManager = renderManager;
    }

    private static void putAll(Map<String, Object> container, JSONObject rawValue) {
        for (Map.Entry entry : rawValue.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            container.put(key, value);
        }
    }

    public void destroy() {
        this.mDestroy = true;
        this.mRegistry.clear();
    }

    void rebuildingDomTree(WXDomObject root) {
        if (root != null && root.getFixedStyleRefs() != null) {
            int size = root.getFixedStyleRefs().size();
            for (int i = 0; i < size; ++i) {
                String fixedRef = root.getFixedStyleRefs().get(i);
                WXDomObject wxDomObject = this.mRegistry.get(fixedRef);
                if (wxDomObject == null || wxDomObject.parent == null) continue;
                wxDomObject.parent.remove(wxDomObject);
                root.add(wxDomObject, -1);
            }
        }
    }

    void batch() {
        long start0 = System.currentTimeMillis();
        if (!this.mDirty || this.mDestroy) {
            return;
        }
        WXDomObject rootDom = this.mRegistry.get("_root");
        if (rootDom == null) {
            return;
        }
        this.rebuildingDomTree(rootDom);
        this.layoutBefore(rootDom);
        long start = System.currentTimeMillis();
        rootDom.calculateLayout(this.mLayoutContext);
        if (WXSDKManager.getInstance().getSDKInstance(this.mInstanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(this.mInstanceId).cssLayoutTime(System.currentTimeMillis() - start);
        }
        this.layoutAfter(rootDom);
        start = System.currentTimeMillis();
        this.applyUpdate(rootDom);
        if (WXSDKManager.getInstance().getSDKInstance(this.mInstanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(this.mInstanceId).applyUpdateTime(System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        this.updateDomObj();
        if (WXSDKManager.getInstance().getSDKInstance(this.mInstanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(this.mInstanceId).updateDomObjTime(System.currentTimeMillis() - start);
        }
        WXLogUtils.d("Batch", "animation size :" + this.animations.size());
        this.parseAnimation();
        WXLogUtils.d("Batch", "task size :" + this.mNormalTasks.size());
        int count = this.mNormalTasks.size();
        for (int i = 0; i < count && !this.mDestroy; ++i) {
            this.mWXRenderManager.runOnThread(this.mInstanceId, this.mNormalTasks.get(i));
        }
        this.mNormalTasks.clear();
        this.mAddDom.clear();
        this.animations.clear();
        this.mDirty = false;
        if (WXSDKManager.getInstance().getSDKInstance(this.mInstanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(this.mInstanceId).batchTime(System.currentTimeMillis() - start0);
        }
    }

    private void layoutBefore(WXDomObject dom) {
        if (dom == null || !dom.hasUpdate() || this.mDestroy) {
            return;
        }
        dom.layoutBefore();
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            this.layoutBefore(dom.getChild(i));
        }
    }

    private void layoutAfter(WXDomObject dom) {
        if (dom == null || !dom.hasUpdate() || this.mDestroy) {
            return;
        }
        dom.layoutAfter();
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            this.layoutAfter(dom.getChild(i));
        }
    }

    private void applyUpdate(WXDomObject dom) {
        if (dom == null) {
            return;
        }
        if (dom.hasUpdate()) {
            dom.markUpdateSeen();
            if (!dom.isYoung()) {
                final WXDomObject copy = dom.clone();
                if (copy == null) {
                    return;
                }
                this.mNormalTasks.add(new IWXRenderTask(){

                    @Override
                    public void execute() {
                        WXDomStatement.this.mWXRenderManager.setLayout(WXDomStatement.this.mInstanceId, copy.ref, copy);
                    }

                    public String toString() {
                        return "setLayout";
                    }
                });
                if (dom.getExtra() != null) {
                    this.mNormalTasks.add(new IWXRenderTask(){

                        @Override
                        public void execute() {
                            WXDomStatement.this.mWXRenderManager.setExtra(WXDomStatement.this.mInstanceId, copy.ref, copy.getExtra());
                        }

                        public String toString() {
                            return "setExtra";
                        }
                    });
                }
            }
        }
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            this.applyUpdate(dom.getChild(i));
        }
    }

    private void parseAnimation() {
        for (final Pair<String, Map<String, Object>> pair : this.animations) {
            WXAnimationBean animationBean;
            if (TextUtils.isEmpty((CharSequence)((CharSequence)pair.first)) || (animationBean = this.createAnimationBean((String)pair.first, (Map)pair.second)) == null) continue;
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    WXDomStatement.this.mWXRenderManager.startAnimation(WXDomStatement.this.mInstanceId, (String)pair.first, animationBean, null);
                }

                public String toString() {
                    return "startAnimationByStyle";
                }
            });
        }
    }

    void createBody(JSONObject element) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (element == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_CREATEBODY);
            }
            return;
        }
        WXDomObject domObject = this.parseInner(element);
        if (domObject == null) {
            return;
        }
        HashMap<String, Object> style = new HashMap<String, Object>(5);
        if (domObject.style == null || !domObject.style.containsKey("flexDirection")) {
            style.put("flexDirection", "column");
        }
        if (domObject.style == null || !domObject.style.containsKey("backgroundColor")) {
            style.put("backgroundColor", "#ffffff");
        }
        if (domObject.style == null || !domObject.style.containsKey("width")) {
            style.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexWidth(this.mInstanceId))));
            domObject.setModifyWidth(true);
        }
        if (domObject.style == null || !domObject.style.containsKey("height")) {
            style.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexHeight(this.mInstanceId))));
            domObject.setModifyHeight(true);
        }
        domObject.ref = "_root";
        domObject.updateStyle(style);
        this.transformStyle(domObject, true);
        try {
            final WXComponent component = this.mWXRenderManager.createBodyOnDomThread(this.mInstanceId, domObject);
            AddDomInfo addDomInfo = new AddDomInfo();
            addDomInfo.component = component;
            this.mAddDom.put(domObject.ref, addDomInfo);
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(WXDomStatement.this.mInstanceId);
                    if (instance == null || instance.getContext() == null) {
                        WXLogUtils.e("instance is null or instance is destroy!");
                        return;
                    }
                    try {
                        WXDomStatement.this.mWXRenderManager.createBody(WXDomStatement.this.mInstanceId, component);
                    }
                    catch (Exception e) {
                        WXLogUtils.e("create body failed.", e);
                    }
                }

                public String toString() {
                    return "createBody";
                }
            });
            this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)domObject.ref, (Object)domObject.style));
            this.mDirty = true;
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("create body in dom thread failed." + e.getMessage());
        }
    }

    private void updateDomObj() {
        long start = System.currentTimeMillis();
        for (Map.Entry<String, AddDomInfo> entry : this.mAddDom.entrySet()) {
            AddDomInfo value = entry.getValue();
            this.updateDomObj(value.component);
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("updateDomObj", "time:" + (System.currentTimeMillis() - start));
        }
    }

    private void updateDomObj(WXComponent component) {
        if (component == null) {
            return;
        }
        WXDomObject domObject = this.mRegistry.get(component.getRef());
        if (domObject == null) {
            return;
        }
        domObject.old();
        component.updateDom(domObject.clone());
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                this.updateDomObj(container.getChild(i));
            }
        }
    }

    void addDom(JSONObject dom, final String parentRef, final int index) {
        if (this.mDestroy) {
            return;
        }
        WXDomObject parent = this.mRegistry.get(parentRef);
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (parent == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDELEMENT);
            }
            return;
        }
        WXDomObject domObject = this.parseInner(dom);
        if (domObject == null || this.mRegistry.containsKey(domObject.ref)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXDomStatement] addDom error!!");
            }
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDELEMENT);
            }
            return;
        }
        this.findFixed(domObject);
        parent.add(domObject, index);
        this.transformStyle(domObject, true);
        final WXComponent component = this.mWXRenderManager.createComponentOnDomThread(this.mInstanceId, domObject, parentRef, index);
        AddDomInfo addDomInfo = new AddDomInfo();
        addDomInfo.component = component;
        this.mAddDom.put(domObject.ref, addDomInfo);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(WXDomStatement.this.mInstanceId);
                if (instance == null || instance.getContext() == null) {
                    WXLogUtils.e("instance is null or instance is destroy!");
                    return;
                }
                try {
                    WXDomStatement.this.mWXRenderManager.addComponent(WXDomStatement.this.mInstanceId, component, parentRef, index);
                }
                catch (Exception e) {
                    WXLogUtils.e("add component failed.", e);
                }
            }

            public String toString() {
                return "AddDom";
            }
        });
        this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)domObject.ref, (Object)domObject.style));
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void findFixed(WXDomObject obj) {
        int childrenCount;
        WXDomObject rootDom = this.mRegistry.get("_root");
        if (rootDom == null) {
            return;
        }
        if (obj.isFixed()) {
            rootDom.add2FixedDomList(obj.ref);
        }
        if ((childrenCount = obj.childCount()) > 0) {
            for (int i = 0; i < childrenCount; ++i) {
                this.findFixed(obj.getChild(i));
            }
        }
    }

    void moveDom(final String ref, final String parentRef, final int index) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        WXDomObject parentObject = this.mRegistry.get(parentRef);
        if (domObject == null || domObject.parent == null || parentObject == null || parentObject.hasNewLayout()) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_MOVEELEMENT);
            }
            return;
        }
        domObject.parent.remove(domObject);
        parentObject.add(domObject, index);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.moveComponent(WXDomStatement.this.mInstanceId, ref, parentRef, index);
            }

            public String toString() {
                return "moveDom";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void removeDom(final String ref) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEELEMENT);
            }
            return;
        }
        WXDomObject parent = domObject.parent;
        if (parent == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEELEMENT);
            }
            return;
        }
        this.clearRegistryForDom(domObject);
        parent.remove(domObject);
        this.mRegistry.remove(ref);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.removeComponent(WXDomStatement.this.mInstanceId, ref);
            }

            public String toString() {
                return "removeDom";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private void clearRegistryForDom(WXDomObject domObject) {
        int count = domObject.childCount();
        this.mRegistry.remove(domObject.ref);
        for (int i = count - 1; i >= 0; --i) {
            this.clearRegistryForDom(domObject.getChild(i));
        }
    }

    void updateAttrs(String ref, final JSONObject attrs) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        final WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATEATTRS);
            }
            return;
        }
        domObject.updateAttr((Map<String, Object>)attrs);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateAttrs(WXDomStatement.this.mInstanceId, domObject.ref, (Map<String, Object>)attrs);
            }

            public String toString() {
                return "updateAttr";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void updateStyle(String ref, JSONObject style) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATESTYLE);
            }
            return;
        }
        HashMap<String, Object> animationMap = WXDataStructureUtil.newHashMapWithExpectedSize(2);
        animationMap.put("transform", style.remove((Object)"transform"));
        animationMap.put("transformOrigin", style.remove((Object)"transformOrigin"));
        this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)ref, animationMap));
        if (!style.isEmpty()) {
            domObject.updateStyle((Map<String, Object>)style);
            this.transformStyle(domObject, false);
            this.updateStyle(domObject, (Map<String, Object>)style);
        }
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private void updateStyle(final WXDomObject domObject, final Map<String, Object> update) {
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateStyle(WXDomStatement.this.mInstanceId, domObject.ref, update);
            }

            public String toString() {
                return "updateStyle";
            }
        });
        if (update.containsKey("padding") || update.containsKey("paddingTop") || update.containsKey("paddingLeft") || update.containsKey("paddingRight") || update.containsKey("paddingBottom") || update.containsKey("borderWidth")) {
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    Spacing padding = domObject.getPadding();
                    Spacing border = domObject.getBorder();
                    WXDomStatement.this.mWXRenderManager.setPadding(WXDomStatement.this.mInstanceId, domObject.ref, padding, border);
                }

                public String toString() {
                    return "setPadding";
                }
            });
        }
    }

    void addEvent(final String ref, final String type) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDEVENT);
            }
            return;
        }
        domObject.addEvent(type);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.addEvent(WXDomStatement.this.mInstanceId, ref, type);
            }

            public String toString() {
                return "Add event";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void removeEvent(final String ref, final String type) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEEVENT);
            }
            return;
        }
        domObject.removeEvent(type);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.removeEvent(WXDomStatement.this.mInstanceId, ref, type);
            }

            public String toString() {
                return "removeEvent";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void scrollToDom(final String ref, final JSONObject options) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.scrollToComponent(WXDomStatement.this.mInstanceId, ref, (Map<String, Object>)options);
            }

            public String toString() {
                return "scrollToPosition";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void createFinish() {
        if (this.mDestroy) {
            return;
        }
        final WXDomObject root = this.mRegistry.get("_root");
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.createFinish(WXDomStatement.this.mInstanceId, (int)root.getLayoutWidth(), (int)root.getLayoutHeight());
            }

            public String toString() {
                return "createFinish";
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void refreshFinish() {
        if (this.mDestroy) {
            return;
        }
        final WXDomObject root = this.mRegistry.get("_root");
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                int realWidth = (int)root.getLayoutWidth();
                int realHeight = (int)root.getLayoutHeight();
                WXDomStatement.this.mWXRenderManager.refreshFinish(WXDomStatement.this.mInstanceId, realWidth, realHeight);
            }

            public String toString() {
                return "refreshFinish";
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private WXDomObject parseInner(JSONObject map) {
        Object children;
        Object event;
        Object attr;
        if (map == null || map.size() <= 0) {
            return null;
        }
        String type = (String)map.get((Object)"type");
        WXDomObject domObject = WXDomObjectFactory.newInstance(type);
        if (domObject == null) {
            return null;
        }
        domObject.type = type;
        domObject.ref = (String)map.get((Object)"ref");
        Object style = map.get((Object)"style");
        if (style != null && style instanceof JSONObject) {
            domObject.style = new WXStyle();
            WXDomStatement.putAll(domObject.style, (JSONObject)style);
        }
        if ((attr = map.get((Object)"attr")) != null && attr instanceof JSONObject) {
            domObject.attr = new WXAttr();
            WXDomStatement.putAll(domObject.attr, (JSONObject)attr);
        }
        if ((event = map.get((Object)"event")) != null && event instanceof JSONArray) {
            domObject.event = new WXEvent();
            JSONArray eventArray = (JSONArray)event;
            int count = eventArray.size();
            for (int i = 0; i < count; ++i) {
                domObject.event.add(eventArray.getString(i));
            }
        }
        if ((children = map.get((Object)"children")) != null && children instanceof JSONArray) {
            domObject.children = new ArrayList<WXDomObject>();
            JSONArray childrenArray = (JSONArray)children;
            int count = childrenArray.size();
            for (int i = 0; i < count; ++i) {
                domObject.children.add(this.parseInner(childrenArray.getJSONObject(i)));
            }
        }
        return domObject;
    }

    void updateFinish() {
        if (this.mDestroy) {
            return;
        }
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateFinish(WXDomStatement.this.mInstanceId);
            }

            public String toString() {
                return "updateFinish";
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void startAnimation(final @NonNull String ref, @NonNull String animation, final @Nullable String callBack) {
        if (this.mDestroy) {
            return;
        }
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            return;
        }
        final WXAnimationBean animationBean = this.createAnimationBean(ref, animation);
        if (animationBean != null) {
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    WXDomStatement.this.mWXRenderManager.startAnimation(WXDomStatement.this.mInstanceId, ref, animationBean, callBack);
                }

                public String toString() {
                    return "startAnimationByCall";
                }
            });
        }
    }

    private WXAnimationBean createAnimationBean(String ref, String animation) {
        try {
            WXAnimationBean animationBean = (WXAnimationBean)JSONObject.parseObject((String)animation, WXAnimationBean.class);
            if (animationBean != null && animationBean.styles != null) {
                WXDomObject domObject = this.mRegistry.get(ref);
                int width = (int)domObject.getLayoutWidth();
                int height = (int)domObject.getLayoutHeight();
                animationBean.styles.init(animationBean.styles.transformOrigin, animationBean.styles.transform, width, height);
            }
            return animationBean;
        }
        catch (RuntimeException e) {
            WXLogUtils.e("", e);
            return null;
        }
    }

    private WXAnimationBean createAnimationBean(String ref, Map<String, Object> style) {
        if (style != null) {
            try {
                Object transform = style.get("transform");
                if (transform instanceof String && !TextUtils.isEmpty((CharSequence)((String)transform))) {
                    String transformOrigin = (String)style.get("transformOrigin");
                    WXAnimationBean animationBean = new WXAnimationBean();
                    WXDomObject domObject = this.mRegistry.get(ref);
                    int width = (int)domObject.getLayoutWidth();
                    int height = (int)domObject.getLayoutHeight();
                    animationBean.styles = new WXAnimationBean.Style();
                    animationBean.styles.init(transformOrigin, (String)transform, width, height);
                    return animationBean;
                }
            }
            catch (RuntimeException e) {
                WXLogUtils.e("", e);
                return null;
            }
        }
        return null;
    }

    private void transformStyle(WXDomObject dom, boolean isAdd) {
        if (dom == null) {
            return;
        }
        if (isAdd) {
            dom.young();
            this.mRegistry.put(dom.ref, dom);
        }
        if (dom.style == null) {
            dom.style = new WXStyle();
        }
        WXStyle style = dom.style;
        Map<String, String> defaults = dom.getDefaultStyle();
        if (defaults != null) {
            for (Map.Entry<String, String> entry : defaults.entrySet()) {
                if (style.containsKey(entry.getKey())) continue;
                style.put(entry.getKey(), entry.getValue());
            }
        }
        if (dom.style.size() > 0) {
            CSSTransformFromStyle.transformStyle(dom);
        }
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject child = dom.getChild(i);
            if (isAdd) {
                dom.add2Dom(child, i);
            }
            this.transformStyle(child, isAdd);
        }
    }

    static class AddDomInfo {
        public WXComponent component;

        AddDomInfo() {
        }
    }
}

