/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.graphics.Paint;
import android.text.TextPaint;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSConstants;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.flex.MeasureOutput;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXViewUtils;

public class BasicEditTextDomObject
extends WXDomObject {
    private TextPaint mPaint = new TextPaint();
    private int mLineHeight = -1;

    public BasicEditTextDomObject() {
        this.mPaint.setTextSize(WXViewUtils.getRealPxByWidth(32.0f));
        this.setMeasureFunction(new CSSNode.MeasureFunction(){

            @Override
            public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
                if (CSSConstants.isUndefined(width)) {
                    width = node.cssstyle.maxWidth;
                }
                measureOutput.height = BasicEditTextDomObject.this.getMeasureHeight();
                measureOutput.width = width;
            }
        });
    }

    @Override
    public void layoutBefore() {
        super.layoutBefore();
        this.updateStyleAndAttrs();
    }

    protected final float getMeasuredLineHeight() {
        return this.mLineHeight != -1 && this.mLineHeight > 0 ? (float)this.mLineHeight : this.mPaint.getFontMetrics(null);
    }

    protected float getMeasureHeight() {
        return this.getMeasuredLineHeight();
    }

    protected void updateStyleAndAttrs() {
        if (this.style != null) {
            int lineHeight;
            int fontSize = -1;
            int fontStyle = -1;
            int fontWeight = -1;
            String fontFamily = null;
            if (this.style.containsKey("fontSize")) {
                fontSize = WXStyle.getFontSize(this.style);
            }
            if (this.style.containsKey("fontFamily")) {
                fontFamily = WXStyle.getFontFamily(this.style);
            }
            if (this.style.containsKey("fontStyle")) {
                fontStyle = WXStyle.getFontStyle(this.style);
            }
            if (this.style.containsKey("fontWeight")) {
                fontWeight = WXStyle.getFontWeight(this.style);
            }
            if ((lineHeight = WXStyle.getLineHeight(this.style)) != -1) {
                this.mLineHeight = lineHeight;
            }
            if (fontSize != -1) {
                this.mPaint.setTextSize((float)fontSize);
            }
            if (fontFamily != null) {
                TypefaceUtil.applyFontStyle((Paint)this.mPaint, fontStyle, fontWeight, fontFamily);
            }
            this.dirty();
        }
    }
}

