/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.storage.StorageResultHandler;
import com.taobao.weex.appfram.storage.WXSQLiteOpenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultWXStorage
implements IWXStorageAdapter {
    private WXSQLiteOpenHelper mDatabaseSupplier;
    private ExecutorService mExecutorService;

    private void execute(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newSingleThreadExecutor();
        }
        this.mExecutorService.execute(runnable);
    }

    public DefaultWXStorage(Context context) {
        this.mDatabaseSupplier = WXSQLiteOpenHelper.getInstance(context);
    }

    @Override
    public void setItem(final String key, final String value, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.setItemResult(DefaultWXStorage.this.performSetItem(key, value));
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void getItem(final String key, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.getItemResult(DefaultWXStorage.this.performGetItem(key));
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void removeItem(final String key, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.removeItemResult(DefaultWXStorage.this.performRemoveItem(key));
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void length(final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.getLengthResult(DefaultWXStorage.this.performGetLength());
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void getAllKeys(final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.getAllkeysResult(DefaultWXStorage.this.performGetAllKeys());
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void close() {
        this.mDatabaseSupplier.closeDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSetItem(String key, String value) {
        String sql = "INSERT OR REPLACE INTO default_wx_storage VALUES (?,?);";
        try (SQLiteStatement statement = this.mDatabaseSupplier.getDatabase().compileStatement(sql);){
            statement.clearBindings();
            statement.bindString(1, key);
            statement.bindString(2, value);
            statement.execute();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performGetItem(String key) {
        try (Cursor c = this.mDatabaseSupplier.getDatabase().query("default_wx_storage", new String[]{"value"}, "key=?", new String[]{key}, null, null, null);){
            if (c.moveToNext()) {
                String string = c.getString(c.getColumnIndex("value"));
                return string;
            }
            String string = null;
            return string;
        }
    }

    private boolean performRemoveItem(String key) {
        int count = 0;
        count = this.mDatabaseSupplier.getDatabase().delete("default_wx_storage", "key=?", new String[]{key});
        return count == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long performGetLength() {
        String sql = "SELECT count(key) FROM default_wx_storage";
        try (SQLiteStatement statement = this.mDatabaseSupplier.getDatabase().compileStatement(sql);){
            long l = statement.simpleQueryForLong();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> performGetAllKeys() {
        ArrayList<String> result = new ArrayList<String>();
        try (Cursor c = this.mDatabaseSupplier.getDatabase().query("default_wx_storage", new String[]{"key"}, null, null, null, null, null);){
            while (c.moveToNext()) {
                result.add(c.getString(c.getColumnIndex("key")));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }
}

