/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import java.util.Stack;

public class BounceRecyclerView
extends BaseBounceView<WXRecyclerView> {
    private RecyclerViewBaseAdapter adapter = null;
    private Stack<FrameLayout> headerViewStack = new Stack();
    private Stack<FrameLayout> tempViewStack = new Stack();
    private Stack<WXCell> headComponentStack = new Stack();

    public BounceRecyclerView(Context context, int orientation) {
        super(context, orientation);
    }

    public BounceRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs, 1);
    }

    public void setAdapter(RecyclerViewBaseAdapter adapter) {
        this.adapter = adapter;
        if (this.getInnerView() != null) {
            ((WXRecyclerView)((Object)this.getInnerView())).setAdapter(adapter);
        }
    }

    public RecyclerViewBaseAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public WXRecyclerView setInnerView(Context context) {
        WXRecyclerView wxRecyclerView = new WXRecyclerView(context);
        wxRecyclerView.initView(context, 1, this.getOrientation());
        return wxRecyclerView;
    }

    @Override
    public void onRefreshingComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onLoadmoreComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyStickyShow(WXCell component, int index) {
        if (this.headComponentStack.isEmpty()) {
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        WXCell oldCom = this.headComponentStack.pop();
        if (!oldCom.getRef().equals(component.getRef())) {
            this.headComponentStack.push(oldCom);
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        this.headComponentStack.push(oldCom);
    }

    public void notifyStickyRemove(WXCell component, int index) {
        if (!(this.headComponentStack.isEmpty() || this.headerViewStack.isEmpty() || this.tempViewStack.isEmpty())) {
            this.removeSticky(component);
        }
    }

    private void showSticky() {
        WXCell headComponent = this.headComponentStack.pop();
        this.headComponentStack.push(headComponent);
        FrameLayout headerView = (FrameLayout)headComponent.getView().getChildAt(0);
        this.headerViewStack.push(headerView);
        int headerViewOffsetX = this.getLeft();
        int headerViewOffsetY = this.getTop();
        headComponent.getView().removeView((View)headerView);
        FrameLayout tempView = new FrameLayout(this.getContext());
        this.tempViewStack.push(tempView);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(headerView.getMeasuredWidth(), headerView.getMeasuredHeight());
        headComponent.getView().addView((View)tempView, (ViewGroup.LayoutParams)lp);
        ((ViewGroup)this.getParent()).addView((View)headerView);
        headerView.setTranslationX((float)headerViewOffsetX);
        headerView.setTranslationY((float)headerViewOffsetY);
    }

    private void removeSticky(WXComponent component) {
        WXCell headComponent = this.headComponentStack.pop();
        if (!component.getRef().equals(headComponent.getRef())) {
            this.headComponentStack.push(headComponent);
            return;
        }
        FrameLayout tempView = this.tempViewStack.pop();
        FrameLayout headerView = this.headerViewStack.pop();
        headComponent.getView().removeView((View)tempView);
        ((ViewGroup)this.getParent()).removeView((View)headerView);
        headComponent.getView().addView((View)headerView);
        headerView.setTranslationX(0.0f);
        headerView.setTranslationY(0.0f);
    }

    public void clearSticky() {
        int size = this.headComponentStack.size();
        while (size > 0 && this.tempViewStack.size() == size && this.headerViewStack.size() == size) {
            WXCell headComponent = this.headComponentStack.pop();
            FrameLayout tempView = this.tempViewStack.pop();
            FrameLayout headerView = this.headerViewStack.pop();
            headComponent.getView().removeView((View)tempView);
            ((ViewGroup)this.getParent()).removeView((View)headerView);
            headComponent.getView().addView((View)headerView);
            headerView.setTranslationX(0.0f);
            headerView.setTranslationY(0.0f);
        }
    }
}

