/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXVideoView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;

public class WXVideo
extends WXComponent {
    private WXVideoView mVideoView;
    private boolean mAutoPlay;
    private String mSrc;
    private boolean mPrepared;
    private boolean mError;
    private ProgressBar mProgressBar;
    private boolean mStopped;

    public WXVideo(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
    }

    @Override
    protected void initView() {
        FrameLayout videoRoot = new FrameLayout(this.mContext);
        videoRoot.setBackgroundColor(WXResourceUtils.getColor("#ee000000"));
        this.mVideoView = new WXVideoView(this.mContext);
        FrameLayout.LayoutParams videoLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        videoLayoutParams.gravity = 17;
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoLayoutParams);
        videoRoot.addView((View)this.mVideoView);
        this.mProgressBar = new ProgressBar(this.mContext);
        FrameLayout.LayoutParams pLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)pLayoutParams);
        pLayoutParams.gravity = 17;
        videoRoot.addView((View)this.mProgressBar);
        final MediaController controller = new MediaController(this.mContext);
        controller.setAnchorView((View)videoRoot);
        this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onError:" + what);
                }
                WXVideo.this.mProgressBar.setVisibility(8);
                WXVideo.this.mPrepared = false;
                WXVideo.this.mError = true;
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("fail")) {
                    WXSDKManager.getInstance().fireEvent(WXVideo.this.mInstanceId, WXVideo.this.getRef(), "fail");
                }
                return true;
            }
        });
        this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPrepared");
                }
                WXVideo.this.mProgressBar.setVisibility(8);
                WXVideo.this.mPrepared = true;
                if (WXVideo.this.mAutoPlay) {
                    WXVideo.this.mVideoView.start();
                }
                WXVideo.this.mVideoView.seekTo(5);
                if (!WXVideo.this.mStopped) {
                    controller.show(3);
                } else {
                    controller.hide();
                }
                WXVideo.this.mStopped = false;
            }
        });
        this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onCompletion");
                }
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("finish")) {
                    WXSDKManager.getInstance().fireEvent(WXVideo.this.mInstanceId, WXVideo.this.getRef(), "finish");
                }
            }
        });
        this.mVideoView.setOnVideoPauseListener(new WXVideoView.VideoPlayListener(){

            @Override
            public void onPause() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPause");
                }
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("pause")) {
                    WXSDKManager.getInstance().fireEvent(WXVideo.this.mInstanceId, WXVideo.this.getRef(), "pause");
                }
            }

            @Override
            public void onStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onStart");
                }
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("start")) {
                    WXSDKManager.getInstance().fireEvent(WXVideo.this.mInstanceId, WXVideo.this.getRef(), "start");
                }
            }
        });
        this.mVideoView.setMediaController(controller);
        controller.setMediaPlayer((MediaController.MediaPlayerControl)this.mVideoView);
        this.mHost = videoRoot;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (TextUtils.isEmpty((CharSequence)src) || this.mHost == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)src)) {
            this.mVideoView.setVideoURI(Uri.parse((String)src));
            this.mProgressBar.setVisibility(0);
            this.mSrc = src;
        }
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
    }

    @WXComponentProp(name="playStatus")
    public void setPlaystatus(String playstatus) {
        if (this.mPrepared && !this.mError && !this.mStopped) {
            if (playstatus.equals("play")) {
                this.mVideoView.start();
            } else if (playstatus.equals("pause")) {
                this.mVideoView.pause();
            } else if (playstatus.equals("stop")) {
                this.mVideoView.stopPlayback();
                this.mStopped = true;
            }
        } else if ((this.mError || this.mStopped) && playstatus.equals("play")) {
            this.mError = false;
            this.mVideoView.resume();
            this.mProgressBar.setVisibility(0);
        }
    }
}

