/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import java.util.ArrayList;

public abstract class WXVContainer
extends WXComponent {
    private static final String TAG = "WXVContainer";
    protected ArrayList<WXComponent> mChildren = new ArrayList();

    public WXVContainer(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    public void applyLayoutAndEvent(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            super.applyLayoutAndEvent(component);
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.getChild(i).applyLayoutAndEvent(((WXVContainer)component).getChild(i));
            }
        }
    }

    @Override
    public void lazy(boolean lazy) {
        super.lazy(lazy);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).lazy(lazy);
        }
    }

    @Override
    public void bindData(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            super.bindData(component);
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.getChild(i).bindData(((WXVContainer)component).getChild(i));
            }
        }
    }

    public ViewGroup getRealView() {
        return (ViewGroup)super.getRealView();
    }

    @Override
    public void createViewImpl(WXVContainer parent, int index) {
        super.createViewImpl(parent, index);
        this.getOrCreateBorder().attachView(this.mHost);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).createViewImpl(this, i);
        }
        if (this.getView() != null) {
            this.getView().setClipToPadding(false);
        }
    }

    public ViewGroup getView() {
        return (ViewGroup)super.getView();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mChildren != null) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).destroy();
            }
            this.mChildren.clear();
        }
    }

    @Override
    public View detachViewAndClearPreInfo() {
        View original = super.detachViewAndClearPreInfo();
        if (this.mChildren != null) {
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).detachViewAndClearPreInfo();
            }
        }
        return original;
    }

    public int childCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public WXComponent getChild(int index) {
        return this.mChildren.get(index);
    }

    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    public void addChild(WXComponent child, int index) {
        if (child == null || index < -1) {
            return;
        }
        int count = this.mChildren.size();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
    }

    protected void addSubView(View child, int index) {
        if (child == null || this.getRealView() == null) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.getRealView().addView(child);
        } else {
            this.getRealView().addView(child, index);
        }
    }

    public void remove(WXComponent child) {
        this.remove(child, true);
    }

    public void remove(WXComponent child, boolean destroy) {
        if (child == null || this.mChildren == null || this.mChildren.size() == 0) {
            return;
        }
        this.mChildren.remove(child);
        if (this.mInstance != null && this.mInstance.getRootView() != null && child.mDomObj.isFixed()) {
            this.mInstance.getRootView().removeView(child.getView());
        } else if (this.getRealView() != null) {
            this.getRealView().removeView(child.getView());
        }
        if (destroy) {
            child.destroy();
        }
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        super.notifyAppearStateChange(wxEventType, direction);
        if (this.getView() == null || this.mChildren == null) {
            return;
        }
        for (WXComponent component : this.mChildren) {
            if (component.getView() != null && component.getView().getVisibility() != 0) {
                wxEventType = "disappear";
            }
            component.notifyAppearStateChange(wxEventType, direction);
        }
    }
}

