/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXBackgroundDrawable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WXAnimationModule
extends WXModule {
    @WXModuleAnno
    public void transition(@Nullable String ref, @Nullable String animation, @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)ref) && !TextUtils.isEmpty((CharSequence)animation)) {
            Message msg = Message.obtain();
            WXDomTask task = new WXDomTask();
            task.instanceId = this.mWXSDKInstance.getInstanceId();
            task.args = new ArrayList<Object>();
            task.args.add(ref);
            task.args.add(animation);
            task.args.add(callBack);
            msg.what = 12;
            msg.obj = task;
            WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
        }
    }

    public static void startAnimation(WXSDKInstance mWXSDKInstance, WXComponent component, @Nullable String callback) {
        try {
            WXAnimationBean animationBean = component.getDomObject().style.getAnimationBean();
            ObjectAnimator animator = WXAnimationModule.createAnimator(animationBean, component.getRealView());
            if (animator != null) {
                Animator.AnimatorListener animatorCallback = WXAnimationModule.createAnimatorListener(mWXSDKInstance, callback);
                component.getRealView().setLayerType(2, null);
                Interpolator interpolator = WXAnimationModule.createTimeInterpolator(animationBean);
                if (animatorCallback != null) {
                    animator.addListener(animatorCallback);
                }
                if (interpolator != null) {
                    animator.setInterpolator((TimeInterpolator)interpolator);
                }
                animator.setDuration(animationBean.duration);
                animator.start();
            }
        }
        catch (RuntimeException e) {
            WXLogUtils.e(WXLogUtils.getStackTrace(e));
        }
    }

    @Nullable
    private static ObjectAnimator createAnimator(@NonNull WXAnimationBean animation, @NonNull View target) {
        WXAnimationBean.Style style = animation.styles;
        if (style != null) {
            List<PropertyValuesHolder> holders = style.getHolders();
            if (!TextUtils.isEmpty((CharSequence)style.backgroundColor)) {
                if (target.getBackground() instanceof WXBackgroundDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{((WXBackgroundDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                } else if (target.getBackground() instanceof ColorDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{((ColorDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                }
            }
            if (style.getPivot() != null) {
                Pair<Float, Float> pair = style.getPivot();
                target.setPivotX(((Float)pair.first).floatValue());
                target.setPivotY(((Float)pair.second).floatValue());
            }
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            animator.setStartDelay(animation.delay);
            return animator;
        }
        return null;
    }

    @Nullable
    public static Animator.AnimatorListener createAnimatorListener(final WXSDKInstance mWXSDKInstance, final @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)callBack)) {
            return new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (mWXSDKInstance == null) {
                        WXLogUtils.e("WXRenderStatement-onAnimationEnd mWXSDKInstance == null NPE");
                    } else {
                        WXSDKManager.getInstance().callback(mWXSDKInstance.getInstanceId(), callBack, new HashMap<String, Object>());
                    }
                }
            };
        }
        return null;
    }

    private static Animator.AnimatorListener prepareLayerType(final View target) {
        if (Build.VERSION.SDK_INT < 18) {
            final int originalLayerType = target.getLayerType();
            target.setLayerType(1, null);
            return new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    target.setLayerType(originalLayerType, null);
                }
            };
        }
        return null;
    }

    @Nullable
    private static Interpolator createTimeInterpolator(@NonNull WXAnimationBean animation) {
        String interpolator = animation.timingFunction;
        if (!TextUtils.isEmpty((CharSequence)interpolator)) {
            switch (interpolator) {
                case "ease-in": {
                    return new AccelerateInterpolator();
                }
                case "ease-out": {
                    return new DecelerateInterpolator();
                }
                case "ease-in-out": {
                    return new AccelerateDecelerateInterpolator();
                }
                case "linear": {
                    return new LinearInterpolator();
                }
            }
        }
        return null;
    }
}

