/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.http;

import java.util.HashMap;
import java.util.Map;

class Options {
    private String method;
    private String url;
    private Map<String, String> headers;
    private String body;
    private Type type = Type.text;

    private Options(String method, String url, Map<String, String> headers, String body, Type type) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.type = type;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public Type getType() {
        return this.type;
    }

    public static class Builder {
        private String method;
        private String url;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;
        private Type type;

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setType(String type) {
            this.type = Type.json.name().equals(type) || "jsonp".equals(type) ? Type.json : Type.text;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Options createOptions() {
            return new Options(this.method, this.url, this.headers, this.body, this.type);
        }
    }

    public static enum Type {
        json,
        text;

    }
}

