/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.flex;

import com.taobao.weex.dom.flex.CSSAlign;
import com.taobao.weex.dom.flex.CSSDirection;
import com.taobao.weex.dom.flex.CSSFlexDirection;
import com.taobao.weex.dom.flex.CSSJustify;
import com.taobao.weex.dom.flex.CSSLayout;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.dom.flex.CSSPositionType;
import com.taobao.weex.dom.flex.CSSStyle;
import com.taobao.weex.dom.flex.CSSWrap;
import com.taobao.weex.dom.flex.CachedCSSLayout;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.dom.flex.LayoutEngine;
import com.taobao.weex.dom.flex.MeasureOutput;
import com.taobao.weex.dom.flex.Spacing;
import java.util.ArrayList;

public class CSSNode {
    public final CSSStyle cssstyle = new CSSStyle();
    public final CSSLayout csslayout = new CSSLayout();
    final CachedCSSLayout lastLayout = new CachedCSSLayout();
    public int lineIndex = 0;
    CSSNode nextAbsoluteChild;
    CSSNode nextFlexChild;
    private ArrayList<CSSNode> mChildren;
    private CSSNode mParent;
    private MeasureFunction mMeasureFunction = null;
    private LayoutState mLayoutState = LayoutState.DIRTY;
    private boolean mShow = true;
    private boolean mIsLayoutChanged = true;

    public boolean isShow() {
        return this.mShow;
    }

    public void setVisible(boolean isShow) {
        if (!this.mShow && isShow) {
            this.mLayoutState = LayoutState.UP_TO_DATE;
        }
        this.mShow = isShow;
        this.dirty();
    }

    public boolean isLayoutChanged() {
        return this.mIsLayoutChanged;
    }

    public boolean updateLastLayout(CSSLayout newLayout) {
        boolean bl = this.mIsLayoutChanged = !this.lastLayout.equals(newLayout);
        if (this.mIsLayoutChanged) {
            this.lastLayout.copy(newLayout);
        }
        return this.mIsLayoutChanged;
    }

    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public CSSNode getChildAt(int i) {
        return this.mChildren.get(i);
    }

    public void addChildAt(CSSNode child, int i) {
        if (child.mParent != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList(4);
        }
        this.mChildren.add(i, child);
        child.mParent = this;
        this.dirty();
    }

    public CSSNode removeChildAt(int i) {
        CSSNode removed = this.mChildren.remove(i);
        removed.mParent = null;
        this.dirty();
        return removed;
    }

    public void setParentNull() {
        this.mParent = null;
    }

    public CSSNode getParent() {
        return this.mParent;
    }

    public int indexOf(CSSNode child) {
        return this.mChildren.indexOf(child);
    }

    public void setMeasureFunction(MeasureFunction measureFunction) {
        if (this.mMeasureFunction != measureFunction) {
            this.mMeasureFunction = measureFunction;
            this.dirty();
        }
    }

    MeasureOutput measure(MeasureOutput measureOutput, float width) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        measureOutput.height = Float.NaN;
        measureOutput.width = Float.NaN;
        if (this.mMeasureFunction != null) {
            this.mMeasureFunction.measure(this, width, measureOutput);
        }
        return measureOutput;
    }

    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    public void calculateLayout(CSSLayoutContext layoutContext) {
        this.csslayout.resetResult();
        LayoutEngine.layoutNode(layoutContext, this, Float.NaN, null);
    }

    protected boolean isDirty() {
        return this.mLayoutState == LayoutState.DIRTY;
    }

    protected void dirty() {
        if (this.mLayoutState == LayoutState.DIRTY) {
            return;
        }
        if (this.mLayoutState == LayoutState.HAS_NEW_LAYOUT) {
            throw new IllegalStateException("Previous csslayout was ignored! markLayoutSeen() never called");
        }
        this.mLayoutState = LayoutState.DIRTY;
        if (this.mParent != null) {
            this.mParent.dirty();
        }
    }

    void markHasNewLayout() {
        this.mLayoutState = LayoutState.HAS_NEW_LAYOUT;
    }

    public void markLayoutSeen() {
        if (!this.hasNewLayout()) {
            throw new IllegalStateException("Expected node to have a new csslayout to be seen!");
        }
        this.mLayoutState = LayoutState.UP_TO_DATE;
    }

    public boolean hasNewLayout() {
        return this.mLayoutState == LayoutState.HAS_NEW_LAYOUT;
    }

    private void toStringWithIndentation(StringBuilder result, int level) {
        int i;
        StringBuilder indentation = new StringBuilder();
        for (i = 0; i < level; ++i) {
            indentation.append("__");
        }
        result.append(indentation.toString());
        result.append(this.csslayout.toString());
        result.append(this.cssstyle.toString());
        if (this.getChildCount() == 0) {
            return;
        }
        result.append(", children: [\n");
        for (i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).toStringWithIndentation(result, level + 1);
            result.append("\n");
        }
        result.append(indentation + "]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringWithIndentation(sb, 0);
        return sb.toString();
    }

    protected boolean valuesEqual(float f1, float f2) {
        return FloatUtil.floatsEqual(f1, f2);
    }

    public CSSDirection getStyleDirection() {
        return this.cssstyle.direction;
    }

    public void setDirection(CSSDirection direction) {
        if (this.cssstyle.direction != direction) {
            this.cssstyle.direction = direction;
            this.dirty();
        }
    }

    public CSSFlexDirection getFlexDirection() {
        return this.cssstyle.flexDirection;
    }

    public void setFlexDirection(CSSFlexDirection flexDirection) {
        if (this.cssstyle.flexDirection != flexDirection) {
            this.cssstyle.flexDirection = flexDirection;
            this.dirty();
        }
    }

    public CSSJustify getJustifyContent() {
        return this.cssstyle.justifyContent;
    }

    public void setJustifyContent(CSSJustify justifyContent) {
        if (this.cssstyle.justifyContent != justifyContent) {
            this.cssstyle.justifyContent = justifyContent;
            this.dirty();
        }
    }

    public CSSAlign getAlignItems() {
        return this.cssstyle.alignItems;
    }

    public void setAlignItems(CSSAlign alignItems) {
        if (this.cssstyle.alignItems != alignItems) {
            this.cssstyle.alignItems = alignItems;
            this.dirty();
        }
    }

    public CSSAlign getAlignSelf() {
        return this.cssstyle.alignSelf;
    }

    public void setAlignSelf(CSSAlign alignSelf) {
        if (this.cssstyle.alignSelf != alignSelf) {
            this.cssstyle.alignSelf = alignSelf;
            this.dirty();
        }
    }

    public CSSPositionType getPositionType() {
        return this.cssstyle.positionType;
    }

    public void setPositionType(CSSPositionType positionType) {
        if (this.cssstyle.positionType != positionType) {
            this.cssstyle.positionType = positionType;
            this.dirty();
        }
    }

    public void setWrap(CSSWrap flexWrap) {
        if (this.cssstyle.flexWrap != flexWrap) {
            this.cssstyle.flexWrap = flexWrap;
            this.dirty();
        }
    }

    public float getFlex() {
        return this.cssstyle.flex;
    }

    public void setFlex(float flex) {
        if (!this.valuesEqual(this.cssstyle.flex, flex)) {
            this.cssstyle.flex = flex;
            this.dirty();
        }
    }

    public Spacing getMargin() {
        return this.cssstyle.margin;
    }

    public void setMargin(int spacingType, float margin) {
        if (this.cssstyle.margin.set(spacingType, margin)) {
            this.dirty();
        }
    }

    public void setMinWidth(float minWidth) {
        if (!this.valuesEqual(this.cssstyle.minWidth, minWidth)) {
            this.cssstyle.minWidth = minWidth;
            this.dirty();
        }
    }

    public void setMaxWidth(float maxWidth) {
        if (!this.valuesEqual(this.cssstyle.maxWidth, maxWidth)) {
            this.cssstyle.maxWidth = maxWidth;
            this.dirty();
        }
    }

    public void setMinHeight(float minHeight) {
        if (!this.valuesEqual(this.cssstyle.minHeight, minHeight)) {
            this.cssstyle.minHeight = minHeight;
            this.dirty();
        }
    }

    public void setMaxHeight(float maxHeight) {
        if (!this.valuesEqual(this.cssstyle.maxHeight, maxHeight)) {
            this.cssstyle.maxHeight = maxHeight;
            this.dirty();
        }
    }

    public Spacing getPadding() {
        return this.cssstyle.padding;
    }

    public void setPadding(int spacingType, float padding) {
        if (this.cssstyle.padding.set(spacingType, padding)) {
            this.dirty();
        }
    }

    public Spacing getBorder() {
        return this.cssstyle.border;
    }

    public void setBorder(int spacingType, float border) {
        if (this.cssstyle.border.set(spacingType, border)) {
            this.dirty();
        }
    }

    public float getPositionTop() {
        return this.cssstyle.position[1];
    }

    public void setPositionTop(float positionTop) {
        if (!this.valuesEqual(this.cssstyle.position[1], positionTop)) {
            this.cssstyle.position[1] = positionTop;
            this.dirty();
        }
    }

    public float getPositionBottom() {
        return this.cssstyle.position[3];
    }

    public void setPositionBottom(float positionBottom) {
        if (!this.valuesEqual(this.cssstyle.position[3], positionBottom)) {
            this.cssstyle.position[3] = positionBottom;
            this.dirty();
        }
    }

    public float getPositionLeft() {
        return this.cssstyle.position[0];
    }

    public void setPositionLeft(float positionLeft) {
        if (!this.valuesEqual(this.cssstyle.position[0], positionLeft)) {
            this.cssstyle.position[0] = positionLeft;
            this.dirty();
        }
    }

    public float getPositionRight() {
        return this.cssstyle.position[2];
    }

    public void setPositionRight(float positionRight) {
        if (!this.valuesEqual(this.cssstyle.position[2], positionRight)) {
            this.cssstyle.position[2] = positionRight;
            this.dirty();
        }
    }

    public float getStyleWidth() {
        return this.cssstyle.dimensions[0];
    }

    public void setStyleWidth(float width) {
        if (!this.valuesEqual(this.cssstyle.dimensions[0], width)) {
            this.cssstyle.dimensions[0] = width;
            this.dirty();
        }
    }

    public float getStyleHeight() {
        return this.cssstyle.dimensions[1];
    }

    public void setStyleHeight(float height) {
        if (!this.valuesEqual(this.cssstyle.dimensions[1], height)) {
            this.cssstyle.dimensions[1] = height;
            this.dirty();
        }
    }

    public float getLayoutX() {
        return this.csslayout.position[0];
    }

    public void setLayoutX(float x) {
        this.csslayout.position[0] = x;
    }

    public float getLayoutY() {
        return this.csslayout.position[1];
    }

    public void setLayoutY(float y) {
        this.csslayout.position[1] = y;
    }

    public float getLayoutWidth() {
        return this.csslayout.dimensions[0];
    }

    public void setLayoutWidth(float width) {
        this.csslayout.dimensions[0] = width;
    }

    public float getLayoutHeight() {
        return this.csslayout.dimensions[1];
    }

    public void setLayoutHeight(float height) {
        this.csslayout.dimensions[1] = height;
    }

    public CSSDirection getLayoutDirection() {
        return this.csslayout.direction;
    }

    public void setDefaultPadding(int spacingType, float padding) {
        if (this.cssstyle.padding.setDefault(spacingType, padding)) {
            this.dirty();
        }
    }

    public void reset() {
        if (this.mParent != null || this.mChildren != null && this.mChildren.size() > 0) {
            throw new IllegalStateException("You should not reset an attached CSSNode");
        }
        this.cssstyle.reset();
        this.csslayout.resetResult();
        this.lineIndex = 0;
        this.mLayoutState = LayoutState.DIRTY;
    }

    public static interface MeasureFunction {
        public void measure(CSSNode var1, float var2, MeasureOutput var3);
    }

    private static enum LayoutState {
        DIRTY,
        HAS_NEW_LAYOUT,
        UP_TO_DATE;

    }
}

