/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TypeModuleFactory<T extends WXModule>
implements ModuleFactory<T> {
    public static final String TAG = "TypeModuleFactory";
    Class<T> mClazz;
    ArrayList<String> mMethods;
    Map<String, Invoker> mMethodMap;

    public TypeModuleFactory(Class<T> clz) {
        this.mClazz = clz;
    }

    private void generateMethodMap() {
        WXLogUtils.d(TAG, "extractMethodNames");
        ArrayList<String> methods = new ArrayList<String>();
        HashMap<String, Invoker> methodMap = new HashMap<String, Invoker>();
        try {
            block2: for (Method method : this.mClazz.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    if (anno == null || !(anno instanceof WXModuleAnno)) continue;
                    methods.add(method.getName());
                    methodMap.put(method.getName(), new MethodInvoker(method));
                    continue block2;
                }
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXModuleManager] extractMethodNames:" + e.getStackTrace());
        }
        this.mMethods = methods;
        this.mMethodMap = methodMap;
    }

    @Override
    public T buildInstance() throws IllegalAccessException, InstantiationException {
        return (T)((WXModule)this.mClazz.newInstance());
    }

    @Override
    public ArrayList<String> getMethodNames() {
        if (this.mMethods == null) {
            this.generateMethodMap();
        }
        return this.mMethods;
    }

    @Override
    public Map<String, Invoker> getMethodMap() {
        if (this.mMethodMap == null) {
            this.generateMethodMap();
        }
        return this.mMethodMap;
    }
}

