/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WXModuleManager {
    private static Map<String, ModuleFactory> sModuleFactoryMap = new HashMap<String, ModuleFactory>();
    private static Map<String, WXModule> sGlobalModuleMap = new HashMap<String, WXModule>();
    private static Map<String, HashMap<String, WXModule>> sInstanceModuleMap = new HashMap<String, HashMap<String, WXModule>>();

    public static boolean registerModule(final String moduleName, final ModuleFactory factory, final boolean global) throws WXException {
        if (moduleName == null || factory == null) {
            return false;
        }
        WXBridgeManager.getInstance().getJSHandler().post(new Runnable(){

            @Override
            public void run() {
                if (sModuleFactoryMap.containsKey(moduleName)) {
                    WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + moduleName);
                }
                if (global) {
                    try {
                        Object wxModule = factory.buildInstance();
                        sGlobalModuleMap.put(moduleName, wxModule);
                    }
                    catch (Exception e) {
                        WXLogUtils.e(moduleName + " class must have a default constructor without params. " + WXLogUtils.getStackTrace(e));
                    }
                }
                try {
                    WXModuleManager.registerNativeModule(moduleName, factory);
                }
                catch (WXException e) {
                    e.printStackTrace();
                }
                WXModuleManager.registerJSModule(moduleName, factory);
            }
        });
        return true;
    }

    static boolean registerNativeModule(String moduleName, ModuleFactory factory) throws WXException {
        if (factory == null) {
            return false;
        }
        sModuleFactoryMap.put(moduleName, factory);
        return true;
    }

    static boolean registerJSModule(String moduleName, ModuleFactory factory) {
        HashMap<String, Object> modules = new HashMap<String, Object>();
        modules.put(moduleName, factory.getMethodNames());
        WXSDKManager.getInstance().registerModules(modules);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        ModuleFactory factory = sModuleFactoryMap.get(moduleStr);
        if (factory == null) {
            WXLogUtils.e("[WXModuleManager] module factory not found.");
            return false;
        }
        final WXModule wxModule = WXModuleManager.findModule(instanceId, moduleStr, factory);
        if (wxModule == null) {
            return false;
        }
        wxModule.mWXSDKInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        Map<String, Invoker> methodsMap = factory.getMethodMap();
        if (methodsMap == null) {
            WXLogUtils.e("[WXModuleManager] callModuleMethod methodsMap is null.");
            return false;
        }
        final Invoker invoker = methodsMap.get(methodStr);
        try {
            Type[] paramClazzs = invoker.getParameterTypes();
            final Object[] params = new Object[paramClazzs.length];
            for (int i = 0; i < paramClazzs.length; ++i) {
                Type paramClazz = paramClazzs[i];
                if (i >= args.size() && !paramClazz.getClass().isPrimitive()) {
                    params[i] = null;
                    continue;
                }
                Object value = args.get(i);
                if (paramClazz == JSONObject.class) {
                    params[i] = value;
                    continue;
                }
                if (JSCallback.class == paramClazz) {
                    if (value instanceof String) {
                        params[i] = new SimpleJSCallback(instanceId, (String)value);
                        continue;
                    }
                    throw new Exception("Parameter type not match.");
                }
                params[i] = WXReflectionUtils.parseArgument(paramClazz, value);
            }
            if (invoker.isRunInUIThread()) {
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            invoker.invoke(wxModule, params);
                        }
                        catch (Exception e) {
                            WXLogUtils.e("callModuleMethod >>> invoke module:" + WXLogUtils.getStackTrace(e));
                        }
                    }
                }, 0L);
            } else {
                invoker.invoke(wxModule, params);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("callModuleMethod >>> invoke module:" + moduleStr + ", method:" + methodStr + " failed. " + WXLogUtils.getStackTrace(e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (wxModule instanceof WXDomModule) {
                wxModule.mWXSDKInstance = null;
            }
        }
        return true;
    }

    private static WXModule findModule(String instanceId, String moduleStr, ModuleFactory factory) {
        WXModule wxModule = sGlobalModuleMap.get(moduleStr);
        if (wxModule == null) {
            HashMap<String, WXModule> moduleMap = sInstanceModuleMap.get(instanceId);
            if (moduleMap == null) {
                moduleMap = new HashMap();
                sInstanceModuleMap.put(instanceId, moduleMap);
            }
            if ((wxModule = moduleMap.get(moduleStr)) == null) {
                try {
                    wxModule = factory.buildInstance();
                }
                catch (Exception e) {
                    WXLogUtils.e(moduleStr + " module build instace failed." + WXLogUtils.getStackTrace(e));
                    return null;
                }
                moduleMap.put(moduleStr, wxModule);
            }
        }
        return wxModule;
    }

    public static void destroyInstanceModules(String instanceId) {
        HashMap<String, WXModule> moduleMap = sInstanceModuleMap.remove(instanceId);
        if (moduleMap == null || moduleMap.size() < 1) {
            return;
        }
        for (Map.Entry<String, WXModule> entry : moduleMap.entrySet()) {
            WXModule module = entry.getValue();
            if (!(module instanceof Destroyable)) continue;
            ((Destroyable)((Object)module)).destroy();
        }
    }

    public static void reload() {
        if (sModuleFactoryMap != null) {
            Set<String> keys = sModuleFactoryMap.keySet();
            for (String key : keys) {
                WXModuleManager.registerJSModule(key, sModuleFactoryMap.get(key));
            }
        }
    }

    private static class SimpleJSCallback
    implements JSCallback {
        String mInstanceId;
        String mCallbackId;

        SimpleJSCallback(String instanceId, String callbackId) {
            this.mCallbackId = callbackId;
            this.mInstanceId = instanceId;
        }

        @Override
        public void invoke(Map<String, Object> data) {
            WXBridgeManager.getInstance().callback(this.mInstanceId, this.mCallbackId, data, false);
        }

        @Override
        public void invokeAndKeepAlive(Map<String, Object> data) {
            WXBridgeManager.getInstance().callback(this.mInstanceId, this.mCallbackId, data, true);
        }
    }
}

