/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.taobao.weex.ui.component.list;

import android.graphics.Color;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.*;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXEventType;
import com.taobao.weex.ui.component.WXHeader;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.TransformItemDecoration;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Unlike other components, there is immutable bi-directional association between View and
 * ViewHolder, while only mutable and temporal uni-directional association between view and
 * components. The association only exist from {@link #onBindViewHolder(ListBaseViewHolder, int)} to
 * {@link #onViewRecycled(ListBaseViewHolder)}. In other situations, the association may not valid
 * or not even exist.
 */
public class WXListComponent extends WXVContainer implements
        IRecyclerAdapterListener<ListBaseViewHolder>,IOnLoadMoreListener,Scrollable {

    public static final String TRANSFORM = "transform";
    private String TAG = "WXListComponent";
    private int mListCellCount = 0;
    private String mLoadMoreRetry = "";
    private ArrayList<ListBaseViewHolder> recycleViewList = new ArrayList<>();
    private static final Pattern transformPattern = Pattern.compile("([a-z]+)\\(([0-9\\.]+),?([0-9\\.]+)?\\)");

    private SparseArray<WXComponent> mAppearComponents = new SparseArray<>();
    private HashMap<String, Long> mRefToViewType;

    protected BounceRecyclerView bounceRecyclerView;

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    /**
     * Measure the size of the recyclerView.
     *
     * @param width  the expected width
     * @param height the expected height
     * @return the result of measurement
     */
    @Override
    protected MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight(WXEnvironment.sApplication);
        int weexH = WXViewUtils.getWeexHeight(mInstanceId);
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - mAbsoluteY : height;
        return super.measure(width, outHeight);
    }

    protected int getOrientation(){
        return VERTICAL;
    }

  /**
   * These transform functions are supported:
   - `scale(x,y)`: scale item, x and y should be a positive float number.
   - `translate(x,y)`: translate item, `x` and `y` shoule be integer numbers.
   - `opacity(n)`: change the transparency of item, `n` must in `[0,1.0]`.
   - `rotate(n)`: rotate item, n is integer number.
   * @param raw
   * @return
   */
    private RecyclerView.ItemDecoration parseTransforms(String raw){
        if(raw == null){
            return null;
        }
        float scaleX = 0f,scaleY = 0f;
        int translateX = 0,translateY = 0;
        float opacity = 0f;
        int rotate = 0;
            //public TransformItemDecoration(boolean isVertical,float alpha,int translateX,int translateY,int rotation,float scale)
        Matcher matcher = transformPattern.matcher(raw);
        while(matcher.find()){
            String match = matcher.group();
            String name = matcher.group(1);
            try {
                switch (name) {
                    case "scale":
                        scaleX = Float.parseFloat(matcher.group(2));
                        scaleY = Float.parseFloat(matcher.group(3));
                        break;
                    case "translate":
                        translateX = Integer.parseInt(matcher.group(2));
                        translateY = Integer.parseInt(matcher.group(3));
                        break;
                    case "opacity":
                        opacity = Float.parseFloat(matcher.group(2));
                        break;
                    case "rotate":
                        rotate = Integer.parseInt(matcher.group(2));
                        break;
                    default:
                        WXLogUtils.e(TAG, "Invaild transform expression:" + match);
                        break;
                }
            }catch (NumberFormatException e){
                e.printStackTrace();
                WXLogUtils.e(TAG, "Invaild transform expression:" + match);
            }
        }
        return new TransformItemDecoration(getOrientation() == VERTICAL, opacity, translateX, translateY, rotate, scaleX, scaleY);
    }

    @Override
    protected void initView() {
        bounceRecyclerView = new BounceRecyclerView(mContext, getOrientation());

        String transforms = (String) mDomObj.attr.get(TRANSFORM);
        if (transforms != null) {
            bounceRecyclerView.getInnerView().addItemDecoration(parseTransforms(transforms));
        }

        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter<>(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        bounceRecyclerView.setAdapter(recyclerViewBaseAdapter);
        bounceRecyclerView.setOverScrollMode(View.OVER_SCROLL_NEVER);
        bounceRecyclerView.getInnerView().clearOnScrollListeners();
        bounceRecyclerView.getInnerView().addOnScrollListener(new WXRecyclerViewOnScrollListener(this));
        bounceRecyclerView.getInnerView().addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
              super.onScrollStateChanged(recyclerView, newState);

                if(newState == RecyclerView.SCROLL_STATE_IDLE ){
                    for(ListBaseViewHolder holder:recycleViewList){
                        if(holder!=null
                                && holder.getComponent()!=null
                                && !holder.getComponent().isUsing()) {
                            recycleImage(holder.getView());
                        }
                    }
                    recycleViewList.clear();
                }
              List<OnWXScrollListener> listeners = mInstance.getWXScrollListeners();
              if (listeners != null && listeners.size() > 0) {
                for (OnWXScrollListener listener : listeners) {
                  if (listener != null) {
                    View topView = recyclerView.getChildAt(0);
                    if (topView != null && listener != null) {
                      int y = topView.getTop();
                      listener.onScrollStateChanged(recyclerView, 0, y, newState);
                    }
                  }
                }
              }
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                List<OnWXScrollListener> listeners = mInstance.getWXScrollListeners();
                if(listeners!=null && listeners.size()>0){
                    for (OnWXScrollListener listener : listeners) {
                        if (listener != null) {
                            listener.onScrolled(recyclerView, dx, dy);
                        }
                    }
                }
            }
        });
      mHost = bounceRecyclerView;
    }

  @Override
  public void bindStickStyle(WXComponent component) {
    //TODO
  }

  @Override
  public void unbindStickStyle(WXComponent component) {
//TODO
  }

  @Override
  public void bindAppearEvent(WXComponent component) {
//TODO
  }

  @Override
  public void bindDisappearEvent(WXComponent component) {
//TODO
  }

  @Override
  public void unbindAppearEvent(WXComponent component) {
//TODO
  }

  @Override
  public void unbindDisappearEvent(WXComponent component) {
//TODO
  }

  @Override
  public void scrollTo(WXComponent component,final int offset) {
    if(bounceRecyclerView == null){
      return;
    }

    WXComponent parent = component;
    WXCell cell = null;
    while(parent != null){
      if(parent instanceof WXCell){
        cell = (WXCell) parent;
        break;
      }
      parent = parent.getParent();
    }
    if(cell !=null){
      int pos = mChildren.indexOf(cell);
      final WXRecyclerView view = bounceRecyclerView.getInnerView();
      view.scrollToPosition(pos);
      final WXComponent cellComp = cell;
      //scroll cell to top
      view.postDelayed(new Runnable() {
        @Override
        public void run() {
          if(mOrientation == VERTICAL){
            int scrollY = cellComp.getView().getTop()+offset;
            view.smoothScrollBy(0,scrollY );
          }else{
            int  scrollX = cellComp.getView().getLeft()+offset;
            view.smoothScrollBy(scrollX,0);
          }
        }
      },50);

      onPostScrollToPosition(pos);
    }

  }

  /**
   * Call after onPostScrollToPosition
   * @param pos
   */
  private void onPostScrollToPosition(int pos){
    if (pos < 0)
      return;
    checkLastSticky(pos);
  }

  /**
   * Check last Sticky after scrollTo
   * @param position scroll to position
   */
  public void checkLastSticky(int position) {
    bounceRecyclerView.clearSticky();
    for (int i = 0; i <= position; i++) {
      WXComponent component = getChild(i);
      if (component.getDomObject() != null && (component.getDomObject().isSticky() && component instanceof WXCell) || component instanceof WXHeader) {
        if (component.getView() == null) {
          return;
        }
        bounceRecyclerView.notifyStickyShow((WXCell) component, i);
      }
    }
  }

  @Override
  public int getScrollY() {
    return bounceRecyclerView == null?0:bounceRecyclerView.getInnerView().getScrollY();
  }

  @Override
  public int getScrollX() {
    return bounceRecyclerView == null?0:bounceRecyclerView.getInnerView().getScrollX();
  }

    /**
        * @return BounceRecyclerView
        */
    public BounceRecyclerView getView() {
        return (BounceRecyclerView) super.getView();
    }

    /**
        * @return BounceRecyclerView
        */
    @Override
    public BounceRecyclerView getRealView() {
        return (BounceRecyclerView) super.getView();
    }

    /**
        * @return RecyclerView
        */
    public RecyclerView getInnerView() {
        return bounceRecyclerView.getInnerView();
    }

    /**
        * Append a child component to the end of WXListComponent. This will not refresh the underlying
        * view immediately. The message of index of the inserted child is given to the adapter, and the
        * adapter will determine when to refresh. The default implementation of adapter will push the
        * message into a message and refresh the view in a period of time.
        *
        * @param child the inserted child
        */
    @Override
    public void addChild(WXComponent child) {
        addChild(child, -1);
    }

    /**
        * @param child the inserted child
        * @param index the index of the child to be inserted.
        * @see #addChild(WXComponent)
        */
    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);

        int adapterPosition = index == -1 ? mChildren.size() - 1 : index;
        BounceRecyclerView view =  getView();
        if(view != null) {
        view.getAdapter().notifyItemInserted(adapterPosition);
        }

        if(hasAppearAndDisAppearEvent(child)){
        mAppearComponents.put(adapterPosition, child);
        child.registerAppearEvent = true;
        }
    }

  private boolean hasAppearAndDisAppearEvent(WXComponent child) {

    if(child.getDomObject().containsEvent(WXEventType.APPEAR) || child.getDomObject().containsEvent(WXEventType.DISAPPEAR)){
      return true;
    }else if(child instanceof WXVContainer){
      WXVContainer container=(WXVContainer)child;
      for(int i=0;i<container.childCount();i++){
        WXComponent component=container.getChild(i);
        if(hasAppearAndDisAppearEvent(component)){
          return true;
        }
      }
    }

    return false;
  }


    /**
     * RecyclerView manage its children in a way that different from {@link WXVContainer}. Therefore,
     * {@link WXVContainer#addSubView(View, int)} is an empty implementation in {@link
     * com.taobao.weex.ui.view.listview.WXRecyclerView}
     */
    @Override
    protected void addSubView(View child, int index) {
      BounceRecyclerView view =  getView();
      if(view == null){
        return;
      }
    }

    /**
     * Remove the child from WXListComponent. This method will use {@link
     * java.util.List#indexOf(Object)} to retrieve the component to be deleted. Like {@link
     * #addChild(WXComponent)}, this method will not refresh the view immediately, the adapter will
     * decide when to refresh.
     *
     * @param child the child to be removed
     */
    @Override
    public void remove(WXComponent child) {
        remove(child, true);
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        int index = mChildren.indexOf(child);
        if (destroy) {
            child.detachViewAndClearPreInfo();
        }
        getView().getAdapter().notifyItemRemoved(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "removeChild child at " + index);
        }
        super.remove(child, destroy);
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
      RecyclerView view = getView().getInnerView();
      pointF.set(view.computeHorizontalScrollOffset(), view.computeVerticalScrollOffset());
    }

    /**
     * Recycle viewHolder and its underlying view. This may because the view is removed or reused.
     * Either case, this method will be called.
     *
     * @param holder The view holder to be recycled.
     */
    @Override
    public void onViewRecycled(ListBaseViewHolder holder) {
        long begin=System.currentTimeMillis();
        holder.setComponentUsing(false);
        recycleViewList.add(holder);
        WXLogUtils.d(TAG, "Recycle holder " +(System.currentTimeMillis()-begin)+"  Thread:"+Thread.currentThread().getName());
    }

    /**
     * Bind the component of the position to the holder. Then flush the view.
     *
     * @param holder   viewHolder, which holds reference to the view
     * @param position position of component in WXListComponent
     */
    @Override
    public void onBindViewHolder(ListBaseViewHolder holder, int position) {
        if (holder == null) return;
        holder.setComponentUsing(true);
        WXComponent component = getChild(position);
        if ( component == null
                || (component instanceof WXRefresh)
                || (component instanceof WXLoading)
                || (component.mDomObj!=null && component.mDomObj.isFixed())
                ) {

            WXLogUtils.d(TAG, "Bind WXRefresh & WXLoading " + holder);
            return;
        }

        if (component != null
            && holder.getComponent() != null
                && holder.getComponent() instanceof WXCell) {
            holder.getComponent().bindData(component);
        }

    }

    /**
     * Create an instance of {@link ListBaseViewHolder} for the given viewType (not for the given
     * index). This method will look up for the first component that fits the viewType requirement and
     * doesn't be used. Then create the certain type of view, detach the view f[rom the component.
     *
     * @param parent   the ViewGroup into which the new view will be inserted
     * @param viewType the type of the new view
     * @return the created view holder.
     */
    @Override
    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (mChildren != null) {
            for (int i = 0; i < childCount(); i++) {
                WXComponent component = getChild(i);
                setRefreshOrLoadingListener(component);
                if (component == null
                        || component.isUsing()
                        || getItemViewType(i) != viewType)
                    continue;
                if (component instanceof WXRefresh) {
                    if (getOrientation() == VERTICAL)
                      bounceRecyclerView.setHeaderView(component.getView());
                    return createVHForWXRefresh(component, viewType);
                } else if (component instanceof WXLoading) {
                    if (getOrientation() == VERTICAL)
                      bounceRecyclerView.setFooterView(component.getView());
                    return createVHForWXLoading(component, viewType);
                } else if (component.mDomObj!=null && component.mDomObj.isFixed()) {
                    return createVHForFakeComponent(viewType);
                } else {
                    if (component.getRealView() != null) {
                        return new ListBaseViewHolder(component, viewType);
                    } else {
                         component.lazy(false);
                         component.createView(this, -1);
                         component.applyLayoutAndEvent(component);
                         return new ListBaseViewHolder(component, viewType);
                    }

                }
            }
        }
        WXLogUtils.e(TAG, "Cannot find request viewType: " + viewType);
        throw new WXRuntimeException("mChildren is null");
    }

  private void setRefreshOrLoadingListener(WXComponent child) {
    if (child instanceof WXRefresh) {
      bounceRecyclerView.setOnRefreshListener((WXRefresh)child);
    }

    if (child instanceof WXLoading) {
      bounceRecyclerView.setOnLoadingListener((WXLoading)child);
    }
  }

    /**
     * Return the child component type. The type is defined by scopeValue in .we file.
     *
     * @param position the position of the child component.
     * @return the type of certain component.
     */
    @Override
    public int getItemViewType(int position) {
        long id;
        try {
            id = Integer.parseInt(getChild(position).getDomObject().ref);
            String type = mChildren.get(position).getDomObject().attr.getScope();

            if (!TextUtils.isEmpty(type)) {
                if (mRefToViewType == null) {
                    mRefToViewType = new HashMap<>();
                }
                if (!mRefToViewType.containsKey(type)) {
                    mRefToViewType.put(type, id);
                }
                id = mRefToViewType.get(type);

            }
        } catch (RuntimeException e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
            id = RecyclerView.NO_ID;
            WXLogUtils.e(TAG, "getItemViewType: NO ID, this will crash the whole render system of WXListRecyclerView");

        }
        return (int) id;
    }

    /**
     * Get child component num.
     *
     * @return return the size of {@link #mChildren} if mChildren is not empty, otherwise, return 0;
     */
    @Override
    public int getItemCount() {
        if (mChildren != null) {
            return mChildren.size();
        }
        return 0;
    }

    @Override
    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        WXLogUtils.d(TAG, "Failed to recycle " + holder);
        return false;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public void onLoadMore(int offScreenY) {
      try {
        String offset = mDomObj.attr.getLoadMoreOffset();

            if (TextUtils.isEmpty(offset)) {
                offset="0";
            }

        if (offScreenY < Integer.parseInt(offset)) {
          String loadMoreRetry = mDomObj.attr.getLoadMoreRetry();

          if (mListCellCount != mChildren.size()
              || mLoadMoreRetry == null || !mLoadMoreRetry.equals(loadMoreRetry)) {
            WXSDKManager.getInstance().fireEvent(mInstanceId, mDomObj.ref, WXEventType.LIST_LOAD_MORE);
            mListCellCount = mChildren.size();
            mLoadMoreRetry = loadMoreRetry;
          }
        }
      } catch (Exception e) {
        WXLogUtils.d(TAG, "onLoadMore :" + WXLogUtils.getStackTrace(e));
      }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible,int directionX,int directionY) {
        List<Integer> unRegisterKeys = new ArrayList<>();

        //notify appear state
        for (int i = 0, len = mAppearComponents.size(); i < len; i++) {
            int key = mAppearComponents.keyAt(i);
            WXComponent value = mAppearComponents.get(key);
            if (!value.registerAppearEvent) {
                unRegisterKeys.add(key);
                continue;
            }
            if (key >= firstVisible && key <= lastVisible && !value.appearState) {
              String direction=directionY>0?"up":"down";
                value.notifyAppearStateChange(WXEventType.APPEAR,direction);
                value.appearState = true;
            } else if ((key < firstVisible || key > lastVisible) && value.appearState) {
              String direction=directionY>0?"up":"down";
              value.notifyAppearStateChange(WXEventType.DISAPPEAR,direction);
              value.appearState = false;
            }
        }

        //remove unregister Event
        for (int i = 0, len = unRegisterKeys.size(); i < len; i++) {
            mAppearComponents.remove(unRegisterKeys.get(i));
        }
    }

  @Override
  public void onBeforeScroll(int dx, int dy) {
    for (int i = 0, len = childCount(); i < len; i++) {
      WXComponent value = getChild(i);
      if (value.getDomObject() != null && (value.getDomObject().isSticky() && value
          instanceof WXCell) ||
          value instanceof WXHeader) {
        if (value.getView() == null)
          return;
        int top = value.getView().getTop();

        if (((WXCell)value).lastLocationY >= 0 && top < 0  && dy > 0) {
          bounceRecyclerView.notifyStickyShow((WXCell) value, i);
        } else if (((WXCell)value).lastLocationY <= 0 && top > 0  && dy < 0) {
          bounceRecyclerView.notifyStickyRemove((WXCell) value, i);
        }
        ((WXCell)value).lastLocationY = top;
      }
    }
  }

  public void unbindAppearComponents(WXComponent component) {
        mAppearComponents.remove(mAppearComponents.indexOfValue(component));
    }

    private void recycleImage(View view) {
        if (view instanceof ImageView) {
            if (mInstance.getImgLoaderAdapter() != null) {
                mInstance.getImgLoaderAdapter().setImage(null, (ImageView) view,
                        null, null);
            } else {
                if (WXEnvironment.isApkDebugable()) {
                    throw new WXRuntimeException("getImgLoaderAdapter() == null");
                }
                WXLogUtils.e("Error getImgLoaderAdapter() == null");
            }

        } else if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup) view).getChildCount(); i++) {
                recycleImage(((ViewGroup) view).getChildAt(i));
            }
        }
    }

    @NonNull
    private ListBaseViewHolder createVHForFakeComponent(int viewType) {
        FrameLayout view = new FrameLayout(mContext);
        view.setBackgroundColor(Color.WHITE);
        view.setLayoutParams(new FrameLayout.LayoutParams(0, 0));
        return new ListBaseViewHolder(view, viewType);
    }

    @NonNull
    private ListBaseViewHolder createVHForWXLoading(WXComponent component, int viewType) {
        FrameLayout view = new FrameLayout(mContext);
        view.setBackgroundColor(Color.TRANSPARENT);
        view.setLayoutParams(new FrameLayout.LayoutParams(1, 1));
        return new ListBaseViewHolder(view, viewType);
    }

    @NonNull
    private ListBaseViewHolder createVHForWXRefresh(WXComponent component, int viewType) {
        FrameLayout view = new FrameLayout(mContext);
        view.setBackgroundColor(Color.TRANSPARENT);
        view.setLayoutParams(new FrameLayout.LayoutParams(1, 1));
        return new ListBaseViewHolder(view, viewType);
    }

}
